package net.sf.gluebooster.demos.pojo.learning;


/**
 * Configuration of an excercise group (one yoga class, one yoga course, ...)
 * 
 * @author CBauer
 *
 */
public class ExcerciseGroupConfiguration implements Cloneable {

	/**
	 * The style of the excercises. Example: There are different yoga styles.
	 * TODO find a better wording
	 */
	private ExcerciseGroup style;

	/**
	 * The theme of the excercises. Excample in yoga: breathing, hip-opening,
	 * ...
	 */
	private String excerciseTheme;

	// private String excerciseName;

	/**
	 * The knowledge level of the excercises.
	 */
	private KnowledgeLevel knowledgeLevel;


	// public String getExcerciseName() {
	// return excerciseName;
	// }
	//
	// public void setExcerciseName(String excerciseName) {
	// this.excerciseName = excerciseName;
	// }

	public KnowledgeLevel getKnowledgeLevel() {
		return knowledgeLevel;
	}

	public void setKnowledgeLevel(KnowledgeLevel knowledgeLevel) {
		this.knowledgeLevel = knowledgeLevel;
	}

	public ExcerciseGroup getStyle() {
		return style;
	}

	public void setStyle(ExcerciseGroup style) {
		this.style = style;
	}

	public String getExcerciseTheme() {
		return excerciseTheme;
	}

	public void setExcerciseTheme(String excerciseTheme) {
		this.excerciseTheme = excerciseTheme;
	}

	/**
	 * Creates an excercise for the style.
	 * 
	 * @return the created excercise
	 */
	public Excercise createExcercise() {

		Excercise result = getStyle().createInstance(this);
		return result;
	}

}
