package net.sf.gluebooster.demos.pojo.math;

public class MathML {

	private static final int TYPE_CONTENT_MARKUP = 1;
	private static final int TYPE_PRESENTATION_MARKUP = 2;

	/**
	 * May be a mixture between content and presentation
	 */
	private static final int TYPE_PREFERRED_MARKUP = 0;

	private int type;

	private String trueRepresentation = "┬";
	private String falseRepresentation = "┴";

	private MathML() {
	}

	private MathML(int type) {
		this.type = type;
	}

	public static MathML createContentMarkup() {
		return new MathML(TYPE_CONTENT_MARKUP);
	}

	public static MathML createPresentationMarkup() {
		return new MathML(TYPE_PRESENTATION_MARKUP);
	}

	public static MathML createPreferredMarkup() {
		return new MathML(TYPE_PREFERRED_MARKUP);
	}

	public void true_(StringBuilder result){
		switch (type){
		case TYPE_CONTENT_MARKUP:
			result.append("<true/>");
			break;
		default:
			result.append(trueRepresentation);
		}
	}

	public void false_(StringBuilder result) {
		switch (type) {
		case TYPE_CONTENT_MARKUP:
			result.append("<false/>");
			break;
		default:
			result.append(falseRepresentation);
		}

	}

	public String getTrueRepresentation() {
		return trueRepresentation;
	}

	public void setTrueRepresentation(String trueRepresentation) {
		this.trueRepresentation = trueRepresentation;
	}

	public String getFalseRepresentation() {
		return falseRepresentation;
	}

	public void setFalseRepresentation(String falseRepresentation) {
		this.falseRepresentation = falseRepresentation;
	}
}
