package net.sf.gluebooster.demos.pojo.math;

import java.util.Collection;
import java.util.List;

public class MathStudiesProofs {

	/**
	 * Gets all statements of the math studies before a given statement.
	 * 
	 * @param statement
	 * @return
	 * @throws Exception
	 */
	public static Collection<Statement> getStatementsUpTo(Statement statement) throws Exception {
		List<Statement> all = MathStudies.allStatements();
		if (!all.contains(statement)) {
			throw new IllegalStateException("statement not contained " + statement);
		} else {
			int index = all.indexOf(statement);
			// TODO add all other statements necessary for proofs at the beginning.
			return all.subList(0, index);
		}

	}
}
