package net.sf.gluebooster.demos.pojo.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Relation;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationSpecial;
import net.sf.gluebooster.demos.pojo.prolog.AbstractProlog;
import net.sf.gluebooster.demos.pojo.prolog.Prolog;

public class ProofGenerator {

	private PrologProofGenerator prolog = new PrologProofGenerator();

	public Statement displayValueTable(Collection<Statement> availableStatements, Statement... functions) throws Exception {
		return prolog.displayValueTable(availableStatements, functions);
	}

	public Statement proofByFunctionTable(Collection<Statement> availableStatements, Statement equalityStatement) throws Exception {

		List<Statement> be = equalityStatement.getAllBe();

		HashMap<Statement, Statement> beVars = new HashMap<Statement, Statement>();
		for (Statement statement : be) {
			if (ClassesSets.ELEMENT_OF.is(statement)) {
				List<Statement> args = statement.getVariables();// variable
				beVars.put(args.get(0), args.get(1)); // class of variable
			}
		}

		List<Statement> mainList = equalityStatement.getMain();

		if (mainList.size() != 1) {
			throw new IllegalStateException("main: only size 1 supported");
		}

		Statement main = mainList.get(0);

		if (!Logic.EQUALS.is(main)) {
			throw new IllegalStateException("main: only Logic.EQUALS supported");
		}

		List<Statement> functions = main.getVariables();
		HashMap<Statement, Statement> usedVars = new HashMap<Statement, Statement>();
		for (Statement function : functions) {
			for (Statement var : function.getVariables()) {
				if (beVars.containsKey(var)) {
					usedVars.put(var, beVars.get(var));
				}
			}
		}

		List<Pair<Statement/* name */, Collection<Object> /* domain of var */>> variables = new ArrayList();
		for (Map.Entry<Statement, Statement> var : usedVars.entrySet()) {
			Statement domain = var.getValue();
			if (ClassesSets.EXPLICIT_SET.is(domain)) {

				variables.add(new MutablePair/* <Statement, Collection<Object>> */(var.getKey(), domain.getVariables()));// get domain values
			} else {
				throw new IllegalStateException("domain not yet supported: " + domain);
			}
		}

		for (Statement function : functions) {
			// separte for, so that the usedVars are complete

			// value mapping

			// first find definition
			Statement definition = null;
			for (Statement def : availableStatements) {
				if (def.is(function)) {
					definition = def;
					break;
				}
			}

			if (definition == null) {
				throw new IllegalStateException("no definition found");
			} else {
				List<Statement> mainPart = definition.getMain();
				if (mainPart.size() != 1) {
					throw new IllegalStateException("currently only main size 1 supported");
				} else {
					Statement mainElement = mainPart.get(0);
					if (!Basics.MATH_TABLE.is(mainElement)) {
						throw new IllegalStateException("currently only math table supported");
					} else {
						mainPart = mainElement.getMain();
						if (mainPart.size() != 1) {
							throw new IllegalStateException("currently only inner main size 1 supported");
						} else {
							mainElement = mainPart.get(0);
							if (!RelationSpecial.EXPLICIT_RELATION.is(mainElement)) {
								throw new IllegalStateException("currently only explicit relation supported");
							} else {
								throw new IllegalStateException("not yet implemented");
								// List<Statement> variables = function.getVariables();
								//
								// List<Statement> key = new ArrayList<>();

							}
						}
					}
				}
			}

			// TODO create mapping
		}


		// List<Pair<Statement /* functionname */, MultiValuedMap /* key(list of object = var values) value mapping */ >> theFunctions
		//
		// Statement result = Basics.toTable(rows.toArray());

		throw new IllegalStateException("not yet implemented");
	}

}
