package net.sf.gluebooster.demos.pojo.math;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.EmptySet;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Relation;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationSpecial;
import net.sf.gluebooster.java.booster.essentials.utils.Check;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;

/**
 * Prolog representation of statements
 * 
 * @author cbauer
 *
 */
public class StatementProlog {

	private static final String becauseOf = "because_of";

	private Statement statement;
	private List<StatementProlog> variables;

	private StatementProlog() {


	}

	public StatementProlog(Statement statement) {
		this.statement = statement;
		variables = new ArrayList<>();
		if (statement != null) {
			for (Statement var : statement.getVariables()) {
				variables.add(new StatementProlog(var));
			}
		}
	}

	/**
	 * Returns the functor (or name) of a statement.
	 * 
	 * @return
	 */
	private String functor() {

		if (statement == null) {
			return "_"; // any variable
		} else if (Logic.VARIABLE.is(statement)) {
			String name = statement.getIdentifier().get(3);
			return "Var_" + name;
		} else {
			String name = statement.getIdentifyingName().toString();
			return "'" + name + "'";
		}
	}

	/**
	 * not finished yet
	 * 
	 * @param afterLastStatement
	 * @return
	 * @throws Exception
	 */
	public String toProlog(boolean mainStatement) throws Exception {
		StringBuilder result = new StringBuilder();

		if (mainStatement) {
			result.append("% ").append(functor()).append("\n");
		}

		if (statement == null) {
			return "_"; // any variable
		} else if (Bool.VERUM.is(statement)) {
			result.append("true");
		} else if (Bool.FALSUM.is(statement)) {
			result.append("false");
		} else if (isAtom()) {
			result.append(functor());
		} else {

			if (Bool.NOT_RELATION.is(statement)) {
				System.out.println("breakpoint test");
			}



			if (ClassesSets.EXPLICIT_SET.is(statement) && variables.size() > 1) {
				// String proof = "[ because"
				for (StatementProlog var : variables) {
					StatementProlog part = new StatementProlog(statement);
					part.variables.clear();
					part.variables.add(var);
					result.append(part.toProlog(true));
				}
			} else if (RelationSpecial.EXPLICIT_RELATION.is(statement)) {

				String functor = functor();

				for (Object row : (Object[]) statement.getRawData()) {
					Object[] rowData = (Object[]) row;
					result.append(functor).append("(");
					boolean allBoolean = true;
					String[] parts = new String[rowData.length];
					Statement lastStatement = null;
					int i = -1;
					for (Object column : rowData) {
						i++;
						if (!(column instanceof Statement)) {
							throw new IllegalStateException("class not supported: " + column.getClass().getSimpleName());
						}

						lastStatement = (Statement) column;

						if (!(Bool.VERUM.is(lastStatement) || Bool.FALSUM.is(lastStatement))) {
							allBoolean = false;
						}

						parts[i] = new StatementProlog(lastStatement).toProlog(false);
						result.append(parts[i]);
						result.append(", ");
					}
					result.delete(result.length() - 2, result.length()); // remove the last ,
					result.append(").\n");

					if (allBoolean) {
						// make a funktion form of the true results
						if (Bool.VERUM.is(lastStatement)) {
							result.append(functor).append("(");
							for (int j = 0; j < parts.length - 1; j++) {
								result.append(parts[j]);
								if (j < parts.length - 2) {
									result.append(", ");
								}
							}
							result.append(").\n");
						}

					}

				}

			} else if (ClassesSets.ELEMENT_OF.is(statement)) {
				StatementProlog element = variables.get(0);
				StatementProlog clasz = variables.get(1);
				result.append(clasz.functor() + "(" + element.functor() + ")");
				if (mainStatement) {
					result.append(".\n");
				}
			} else if (Logic.BRACKET.is(statement)) {
				if (variables.size() != 1) {
					throw new IllegalStateException("only size 1 supported");
				}
				StatementProlog element = variables.get(0);
				return element.toProlog(mainStatement);
			} else {

				if (variables.size() > 0) {

					result.append(functor()).append("(  ");

					for (StatementProlog var : variables) {
						result.append(var.toProlog(false));
						result.append(", ");
					}
					result.delete(result.length() - 2, result.length()); // remove the last ,

					result.append(")");

					if (mainStatement) {
						result.append(".\n");
					}

					// result.append(":-");
					// result.append(".");
				} else {


					if (statement.getMain().size() != 1) {
						result.append("Main statement size != 1 not supported: " + statement + "\n");
					} else {
						StatementProlog main = new StatementProlog(statement.getMain().get(0));
						result.append(main.toProlog(false));
						result.append(":-");
						for (Statement be : statement.getAllBe()) {
							result.append(new StatementProlog(be).toProlog(false)).append(", ");
						}
						result.delete(result.length() - 2, result.length()); // remove the last ,
						result.append(".\n");
					}

				}
			}

		}
		return result.toString();
	}

	public boolean isConvertable() {
		return !isAtom();
	}

	private boolean isAtom() {

		return (statement == null) || ((variables.size() == 0) && statement.getMain().isEmpty() && !RelationSpecial.EXPLICIT_RELATION.is(statement));

	}

	@Override
	public String toString() {
		if (statement == null) {
			return "null statement";
		}
		return statement.toString();
	}

	// working is
	// and(true,true).
	// implies(A,C) :- and(implies(A,B),implies(B,C)).
	//
	// implies(a,b).
	// implies(b,c).
	//
	// ?-implies(a,X).
	// X=b

}
