package net.sf.gluebooster.demos.pojo.math.library;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationSpecial;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.RuleTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.Write;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.basic.container.ComparatorBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class Basics extends BasicsFactory {


	/**
	 * Display of a table with rows and columns
	 */
	public static Statement TABLE;

	/**
	 * Mathematical table that displays computed values.
	 */
	public static Statement MATH_TABLE;

	/**
	 * Just state that there are more elements (...)
	 */
	public static Statement MORE;

	public static Statement ASSUMPTION;

	public static Statement BE;
	public static Statement BE_STATEMENT;

	public static Statement COMMENT;

	public static Statement CONTRADICTION;
	public static Statement TRIVIAL;
	public static Statement ANALOGOUS;

	public static Statement DEFINITION;

	public static Statement MULTILINE;

	public static Statement UNDEROVER;

	public static Statement MANTISSA_INDEX_EXPONENT;

	/**
	 * An enumeration of statements. Insert a comma between the statements.
	 */
	public static Statement COMMA_SEPARATED;
	/**
	 * An enumeration of statements. Insert a blank between the statements.
	 */
	public static Statement BLANK_SEPARATED;
	public static Statement NOT_SEPARATED;

	/**
	 * A line of a proof with the first variable as the part of the proof, the following variables the explanation of this line.
	 */
	public static Statement PROOFLINE;

	public static Statement TO_PROOF;

	/**
	 * Only the names of the definitions of the variables are important
	 */
	public static Statement DEF_NAMES;

	public static Statement PROOF_END;


	public static Statement END_OF_PROVEN_LEMMATA;
	public static Statement MISSING_PROOF;

	// public static Statement SUB_SUPERSCRIPT;

	public static Statement NAME_OF_INSTANCE;

	public static Statement NAME_OF_FIRST_VARIABLE;

	public static Statement IN_THE_CASE_OF;

	public static Statement WLOG;

	public static Statement SUBPROOF;

	static {
		try {
			titleText(SINGLETON.getCategory(), "Basics", null, "Grundlagen", null);

			// set the MathMLGenerator constants here to prevent initialization problems

			DEF_NAMES = defNames();
			MathMLGenerator.NAME_OF_DEFINITION = new RuleTransformation(DEF_NAMES, SELF);
			MathMLGenerator.WRITE_NAME_OF_DEFINITION = new WriteAfterStatementTransformation(MathMLGenerator.NAME_OF_DEFINITION);

			NOT_SEPARATED = notSeparated();
			MathMLGenerator.NAME_OF_INSTANCE = new RuleTransformation(Basics.NOT_SEPARATED, NAME);
			MathMLGenerator.WRITE_NAME_OF_INSTANCE = new WriteAfterStatementTransformation(MathMLGenerator.NAME_OF_INSTANCE);

			MathMLGenerator.SHORT_NAME_DEFAULT_TUPLE_EXTENDED_DEFINED = WriteExtended.shortDefault(MathMLGenerator.WRITE_NAME,
					MathMLGenerator.WRITE_OPERATION_BRACKETS_AND_COMMA, new WriteMulti(NAME, ":= ", MathMLGenerator.WRITE_OPERATION_BRACKETS_AND_COMMA),
					new WriteMulti(NAME, ":= ", MathMLGenerator.WRITE_OPERATION_BRACKETS_AND_COMMA, " ", MathMLGenerator.WRITE_NAME_OF_DEFINITION));

			MathMLGenerator.WRITE_DELEGATE_TO_FIRST_VARIABLE = WriteExtended.shortDefault(
					WriteAfterStatementTransformation.selectThenWrite(MathMLGenerator.selectFirstVariable, MathMLGenerator.WRITE_NAME), //
					WriteAfterStatementTransformation.selectThenWrite(MathMLGenerator.selectFirstVariable, MathMLGenerator.WRITE_OPERATION_BRACKETS_AND_COMMA), //
					WriteAfterStatementTransformation.selectThenWrite(MathMLGenerator.selectFirstVariable,
							new WriteMulti(NAME, ":= ", MathMLGenerator.WRITE_OPERATION_BRACKETS_AND_COMMA)), //
					new WriteMulti(
							WriteAfterStatementTransformation.selectThenWrite(MathMLGenerator.selectFirstVariable,
									new WriteMulti(NAME, ":= ", MathMLGenerator.WRITE_OPERATION_BRACKETS_AND_COMMA)),
							" ", MathMLGenerator.WRITE_NAME_OF_DEFINITION)//
			);

			TABLE = table(null);

			MATH_TABLE = mathTable(null, null);

			MORE = SINGLETON.naive("more");

			COMMENT = comment("");
			
			COMMA_SEPARATED = commaSeparated();
			// MathMLGenerator.RULES.put(COMMA_SEPARATED, new WriteOperation(", ")/* MathMLGenerator.WRITE_OPERATION_COMMA_SEPARATED */);

			BLANK_SEPARATED = blankSeparated();

			ASSUMPTION = assumption(null);
			titleText(ASSUMPTION, "assumption", null, "Annahme", null);
			MathMLGenerator.displayRule(Basics.ASSUMPTION, MathMLGenerator.WRITE_NAME_OF_DEFINITION);

			BE = SINGLETON.naive("BE: ");
			titleText(BE, "Be", null, "Sei", null);
			MathMLGenerator.displayRule(Basics.BE, MathMLGenerator.WRITE_NAME_OF_DEFINITION);

			BE_STATEMENT = be(null);
			titleText(BE_STATEMENT, "Be: ", null, "Sei: ", null);
			MathMLGenerator.displayRule(Basics.BE_STATEMENT,
					WriteAfterStatementTransformation.ruleTransformation(Basics.BLANK_SEPARATED, new Object[] { Basics.DEF_NAMES, SELF }, FIRST_VARIABLE));

			CONTRADICTION = SINGLETON.naive("CONTRADICTION");
			titleText(CONTRADICTION, "contradiction", null, "Widerspruch", null);
			MathMLGenerator.displayRule(Basics.CONTRADICTION, MathMLGenerator.WRITE_NAME_OF_DEFINITION);

			TRIVIAL = SINGLETON.naive("trivial");
			titleText(TRIVIAL, "trivial", null, "trivial", null);
			MathMLGenerator.displayRule(Basics.TRIVIAL, MathMLGenerator.WRITE_NAME_OF_DEFINITION);

			DEFINITION = SINGLETON.naive("definition");
			titleText(DEFINITION, "definition", null, "Definition", null);
			MathMLGenerator.displayRule(Basics.DEFINITION, MathMLGenerator.WRITE_NAME_OF_DEFINITION);

			MULTILINE = multiline();

			PROOFLINE = proofline();
			MathMLGenerator.displayRule(Basics.PROOFLINE,
					WriteAfterStatementTransformation.ruleTransformation(Basics.BLANK_SEPARATED, FIRST_VARIABLE, "(", AFTER_FIRST_VARIABLE, ")"));


			NAME_OF_INSTANCE = nameOfInstance();
			MathMLGenerator.displayRule(Basics.NAME_OF_INSTANCE, MathMLGenerator.WRITE_NAME);

			NAME_OF_FIRST_VARIABLE = nameOfFirstVariable(null);
			MathMLGenerator.displayRule(Basics.NAME_OF_FIRST_VARIABLE, new WriteMulti(NAME_OF_FIRST_VARIABLE));

			TO_PROOF = SINGLETON.naive("to proof");
			titleText(TO_PROOF, null, null, "Zu beweisen", null);

			PROOF_END = comment("□");

			UNDEROVER = underOver(null, null, null);

			MANTISSA_INDEX_EXPONENT = mantissaIndexExponent(null, null, null);

			IN_THE_CASE_OF = inCaseOf(null);
			titleText(IN_THE_CASE_OF, "in the case of ", null, "falls", null);
			MathMLGenerator.displayRule(Basics.IN_THE_CASE_OF,
					WriteAfterStatementTransformation.ruleTransformation(Basics.BLANK_SEPARATED, MathMLGenerator.NAME_OF_DEFINITION, FIRST_VARIABLE));

			END_OF_PROVEN_LEMMATA = SINGLETON.naive("END_OF_PROVEN_LEMMATA");
			titleText(END_OF_PROVEN_LEMMATA, null, null, "Ab hier fehlen Beweise (Beweisende)", null);

			MISSING_PROOF = SINGLETON.naive("MISSING_PROOF");
			titleText(MISSING_PROOF, null, null, "Beweis fehlt noch.", null);

			WLOG = SINGLETON.naive("WLOG");
			WLOG.setReferences(References.wikiDe("Ohne_Beschränkung_der_Allgemeinheit"), References.wikiEn("Without_loss_of_generality"));
			titleText(WLOG, "without loss of generality", null, "Ohne Beschränkung der Allgemeinheit", null);

			ANALOGOUS = analogous(null);
			MathMLGenerator.displayRule(ANALOGOUS, WriteAfterStatementTransformation.ruleTransformation(Basics.BLANK_SEPARATED, "Analog: ", FIRST_VARIABLE));

			SUBPROOF = subproof(null, null);
			MathMLGenerator.displayRule(SUBPROOF,
					WriteAfterStatementTransformation.ruleTransformation(Basics.MULTILINE, FIRST_VARIABLE, SECOND_VARIABLE, PROOF_END));

			// SUB_SUPERSCRIPT = subSuperscript(null, null, null);
			endOfInitialization();

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	/**
	 * Additional initialization that should (because of circles in the static class loading) be done at the end of the initialization.
	 * 
	 * @throws Exception
	 */
	private static void endOfInitialization() throws Exception {
		MATH_TABLE.setReferences(References.wikiEn("Mathematical_table"), References.wikiDe("Wertetabelle"));

	}
	private Basics() {
	}


	public static Statement toTable(Statement mathTable) throws Exception {
		if (Basics.MATH_TABLE.is(mathTable)) {
			List<Statement> variableNames = mathTable.getVariables();
			int varSize = variableNames.size();
			List<Statement> functions = mathTable.getMain();// all functions must have all variables as arguments
			int functSize = functions.size();
			
			
			List<Pair<Statement/*name*/, Collection<Object> /* domain of var*/>> variables = new ArrayList();
			List<Pair<Statement /*function*/, MultiValuedMap  /*key(list of object = var values) value mapping*/ >> theFunctions = new ArrayList();

			for (Statement var: variableNames){
				variables.add(new MutablePair<Statement, Collection<Object>>(var, null));
			}
			
			for (int i = 0; i < functSize; i++) {
				Statement function = functions.get(i);

				Statement nameOfFunction = function.getNameOfInstance();
				if (nameOfFunction == null) {
					throw new IllegalStateException("no function name (maybe no function at all) " + function);
				}
				Statement functionName = nameOfFunction.cloneMe();
				functionName.setVariables(variableNames);


				ArrayListValuedHashMap mapping = new ArrayListValuedHashMap<Object, Object>();
				Pair<List<Object>, List<Object>> keyValues = RelationSpecial.splitAtColumn(function, varSize);
				List<Object> keys = keyValues.getLeft();
				List<Object> values = keyValues.getRight();
				int size = keys.size();
				for (int j = 0; j < size; j++) {
					mapping.put(keys.get(j), values.get(j));
				}

				theFunctions.add(new MutablePair<Statement, MultiValuedMap>(functionName, mapping));
			}
			
			
			List<Object>[] domains = new List[varSize];
			for (int i = 0; i < varSize; i++) {
				HashSet<Object> domain = new HashSet();
				for (int j = 0; j < functSize; j++) {
					domain.addAll(RelationSpecial.getColumn(functions.get(j), i));
				}
				variables.get(i).setValue(domain);
			}			
			
			
			return toTable(variables, theFunctions);

		} else {
			throw new IllegalStateException("unsupported statement: " + mathTable);
		}
	}

	public static StudyUnit createStudyUnit() {

		return new StudyUnit(SINGLETON, 1,(List) Arrays.asList(),
				Arrays.asList(
						TABLE, MATH_TABLE, MORE, ASSUMPTION, BE, BE_STATEMENT, COMMENT, CONTRADICTION, TRIVIAL, DEFINITION, MULTILINE, UNDEROVER,
						MANTISSA_INDEX_EXPONENT, COMMA_SEPARATED, BLANK_SEPARATED, NOT_SEPARATED, PROOFLINE, TO_PROOF, DEF_NAMES, PROOF_END,
						END_OF_PROVEN_LEMMATA, NAME_OF_INSTANCE, NAME_OF_FIRST_VARIABLE, IN_THE_CASE_OF, WLOG, ANALOGOUS, MISSING_PROOF, SUBPROOF
						)
				);
	}

}
