package net.sf.gluebooster.demos.pojo.math.library;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationSpecial;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.basic.container.ComparatorBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class BasicsFactory extends Statements {

	protected static final BasicsFactory SINGLETON = new BasicsFactory();

	private static final Statement[] EMPTY_STATEMENTS = {};



	protected BasicsFactory() {
		super("basics", null);
	}

	public static Statement assumption(Statement assumption) {
		return SINGLETON.naive("assumption", assumption);
	}

	public static Statement be(Statement statement) {
		return SINGLETON.naive("BE (statement) ", statement);
	}

	public static Statement defNames(Statement... onlyTheirNameIsImportant) {
		return SINGLETON.naive("DEF_NAMES", onlyTheirNameIsImportant);
	}

	public static Statement nameOfInstance() {
		return SINGLETON.naive("nameOfInstance");
	}

	public static Statement nameOfFirstVariable(Statement onlyTheInstanceNameIsImportant) {
		return SINGLETON.naive("nameOfFirstVariable", onlyTheInstanceNameIsImportant);
	}

	/**
	 * 
	 * @param rowsColumns
	 *            the first row should contain the names of the columns
	 * @return
	 */
	public static Statement table(Object[][] rowsColumns) {
		Statement result = SINGLETON.naive("table");
		result.setRawData(rowsColumns);
		return result;
	}

	public static Statement table(Object[]/* [] */ rowsColumns) {
		Object[][] data = new Object[rowsColumns.length][((Object[]) rowsColumns[0]).length];
		for (int i = 0; i < rowsColumns.length; i++) {

			Object[] cols = (Object[]) rowsColumns[i];
			data[i] = cols;
		}
		return table(data);

	}

	public static Statement comment(Object comment) {
		Statement result = SINGLETON.naive("comment");
		if (comment != null) {
			result.setDescription(comment.toString());
		}
		return result;
	}

	public static Statement commaSeparated(Statement... parts) {
		Statement result = SINGLETON.normal("commaSeparated", parts);
		return result;
	}


	public static Statement blankSeparated(Statement... parts) {
		Statement result = SINGLETON.normal("blankSeparated", parts);
		return result;
	}

	public static Statement blankSeparated(Object... parts) {
		Statement[] result = new Statement[parts.length];
		for (int i = 0; i < parts.length; i++) {
			if (parts[i] instanceof Statement) {
				result[i] = (Statement) parts[i];
			} else {
				result[i] = comment(parts[i]);
			}
		}
		return blankSeparated(result);
	}

	public static Statement blankSeparated(List<Statement> parts) {
		return blankSeparated(parts.toArray(EMPTY_STATEMENTS));
	}

	public static Statement notSeparated(Statement... parts) {
		Statement result = SINGLETON.normal("notSeparated", parts);
		return result;
	}

	public static Statement notSeparated(Object... parts) {
		Statement[] result = new Statement[parts.length];
		for (int i = 0; i < parts.length; i++) {
			if (parts[i] instanceof Statement) {
				result[i] = (Statement) parts[i];
			} else {
				result[i] = comment(parts[i]);
			}
		}
		return notSeparated(result);
	}

	/**
	 * Each statement should be displayed in one separate line
	 * 
	 * @param parts
	 * @return
	 */
	public static Statement multiline(Statement... parts) {
		Statement result = SINGLETON.normal("multiline", parts);
		return result;
	}

	public static Statement underOver(Statement base, Statement under, Statement over) {
		Statement result = SINGLETON.normal("underOver", base, under, over);
		return result;
	}

	public static Statement mantissaIndexExponent(Statement mantissa, Statement index, Statement exponent) {
		Statement result = SINGLETON.normal("mantissaIndexExponent", mantissa, index, exponent);
		return result;
	}

	public static Statement mantissaIndex(Statement mantissa, Statement index) {
		return mantissaIndexExponent(mantissa, index, EMPTY);
	}

	public static Statement mantissaExponent(Statement mantissa, Statement exponent) {
		return mantissaIndexExponent(mantissa, EMPTY, exponent);
	}

	/**
	 * One line of a proof. The first statement is the content of the proof, the remaining statements are the definitions and lemmata used.
	 * 
	 * @param lineAndReferences
	 * @return
	 */
	public static Statement proofline(Statement... lineAndReferences) {
		Statement result = SINGLETON.normal("proofline", lineAndReferences);
		return result;
	}

	public static Statement inCaseOf(Statement condition) {
		Statement result = SINGLETON.normal("inCaseOf", condition);
		return result;
	}


	/**
	 * displays a table with values of functions
	 * 
	 * @param variableNames
	 *            the names of the arguments of the functions
	 * @param relations
	 *            all functions must have the same number of arguments.
	 * @return
	 */
	public static Statement mathTable(List<Statement> variableNames, List<Statement> functions) {
		Statement result = SINGLETON.naive("mathTable", variableNames, functions);
		return result;
	}

	/**
	 * 
	 * @param variables
	 * @param theFunctions
	 *            keys of the mappings are lists (variable values) values are lists (multidim function results).
	 * @return
	 */
	public static Statement toTable(List<Pair<Statement/* name */, Collection<Object> /* domain of var */>> variables,
			List<Pair<Statement /* functionname */, MultiValuedMap /* key(list of object = var values) value mapping */ >> theFunctions) {

		int varSize = variables.size();
		List<Statement> variableNames = new ArrayList(variables.size());// the names of the variables
		List<Object>[] domains = new List[varSize]; // the corresponding domain of the variable

		int functSize = theFunctions.size();
		// List<Statement> functions = new ArrayList(functSize);// the functions
		MultiValuedMap<Object, Object>[] valuesMap = new MultiValuedMap[functSize];// the mappings of the functions.

		Object[] columnNames = new Object[varSize + functSize];

		for (int i = 0; i < varSize; i++) {
			Pair<Statement/* name */, Collection<Object> /* domain of var */> var = variables.get(i);
			variableNames.add(var.getLeft());
			columnNames[i] = var.getLeft();
			domains[i] = new ArrayList(var.getRight());
			Collections.sort(domains[i], ComparatorBoostUtils.createComparatorWithStringAsDefault());
		}
		
		for (int i = 0; i < functSize; i++) {
			Pair<Statement/* name */, MultiValuedMap /* domain of var */> fun = theFunctions.get(i);
			// functions.add(fun.getLeft());
			columnNames[varSize + i] = fun.getLeft();// .getNameOfInstance();
			valuesMap[i] = fun.getRight();
		}

		int rows = 1;
		for (List domain : domains) {
			rows = rows * domain.size();
		}

		List<Object[]> rowList = new ArrayList(rows); // new Object[columnNames.length][rows];
		rowList.add(columnNames);

		Iterator[] domainIterators = new Iterator[domains.length];
		Object[] domainValue = new Object[domains.length];
		for (int i = 0; i < domains.length; i++) {
			domainIterators[i] = domains[i].iterator();
			domainValue[i] = domainIterators[i].next();
		}

		boolean doContinue;
		do {
			Object[] row = new Object[columnNames.length];
			ArrayList<Object> key = new ArrayList(domains.length);
			for (int i = 0; i < varSize; i++) {
				key.add(domainValue[i]);
				row[i] = domainValue[i];
			}
			for (int i = 0; i < functSize; i++) {
				row[varSize + i] = valuesMap[i].get(key);
			}

			rowList.add(row);

			doContinue = false;
			int i = domains.length - 1;
			while (i >= 0 && !doContinue) {
				if (domainIterators[i].hasNext()) {
					domainValue[i] = domainIterators[i].next();
					doContinue = true;
				} else {
					if (i > 0) {
						domainIterators[i] = domains[i].iterator(); // start again
						domainValue[i] = domainIterators[i].next();
					}
					i = i - 1;
				}
			}

		} while (doContinue);

		return BasicsFactory.table(rowList.toArray());

	}

	public static Statement analogous(Statement statement) {
		Statement result = SINGLETON.normal("analogous", statement);
		return result;
	}

	public static Statement subproof(Statement title, Statement proof) {
		Statement result = SINGLETON.normal("subproof", title, proof);
		return result;
	}

}
