package net.sf.gluebooster.demos.pojo.math.library;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.algebra.Algebra;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class General extends GeneralFactory {



	public static Statement SPACE;

	public static Statement STRUCTURE;

	private General() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "Spaces", null, "Räume", null);

			titleText(SINGLETON.unit(1), "Spaces", null, "Räume", null);

			Statement U = Logic.var("U");

			Statement s1 = Logic.var("S", ONE);
			Statement sn = Logic.var("S", n);


			SPACE = SINGLETON.naive("space");
			SPACE.setReferences(References.wikiDe("Raum_(Mathematik)"), References.wikiEn("Space_(mathematics)"));
			titleText(SPACE, "space", null, "Raum", "Ein Raum besteht aus einem Universum U mit zusätzlicher Struktur. Meist wird ein solcher Raum als Tuple ",
					Tuples.tuple(U, s1, DOTS, sn), " geschrieben, wobei die ", Tuples.tupleWithoutBrackets(s1, DOTS, sn),
					" die Struktureigenschaften beschreiben.");

			STRUCTURE = structure(null, null, null, null);
			STRUCTURE.setReferences(References.wikiDe("Struktur_(erste_Stufe)"));
			STRUCTURE.be(ClassesSets.clasz(A));
			Statement operationFamily = RelationBinary.indexedFamily(f_i, i, I, null);
			Statement relationFamily = RelationBinary.indexedFamily(Rj, j, J, null);

			// HETEROGENOUS_ALGEBRA.setMain();
			Statement structure = structure(S, A, operationFamily, relationFamily);
			structure.setDisplayLevel(EXTENDED);
			definition(STRUCTURE, "(first order) structure", null, "Struktur (erster Stufe) ", "Eine Struktur erster Stufe  ", structure,
					" ist eine Klasse (in der Regel Menge) ", A, " zusammen mit einer Familie von Operationen ", operationFamily,
					" und einer Famile von homogenen Relationen ", relationFamily,
					" auf dieser Klasse. Es handelt sich somit um eine Spezialisierung eines Raumes, bei dem die Struktureigenschaften durch Operationen und Relationen definiert werden.");
			MathMLGenerator.displayRule(STRUCTURE,
					WriteExtended.defaultExtended(MathMLGenerator.WRITE_NAME, MathMLGenerator.WRITE_NAME_DEFINED_AS_FIRST_SECOND_THIRD));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1, Arrays.asList(SPACE, STRUCTURE), (List) Arrays.asList());
	}

}
