package net.sf.gluebooster.demos.pojo.math.library;

import java.util.Arrays;
import java.util.Locale;

import javax.swing.JOptionPane;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class References extends Statements {

	private static final References FACTORY = new References();
	// public static final String REFERENCES = "references";

	public static Statement REFERENCE;

	private static Statement WIKIPEDIA_DE;
	private static Statement WIKIPEDIA_EN;
	private static Statement WIKIBOOKS_DE;

	private static Statement FERNUNIVERSITAET;
	private static Statement FU_NAIVE_MENGENLEHRE;
	private static Statement FU_NAIVE_MENGENLEHRE_1;
	private static Statement FU_NAIVE_MENGENLEHRE_2;

	private static Statement FU_LINEARE_ALGEBRA;
	private static Statement FU_LINEARE_ALGEBRA_2;
	private static Statement FU_LINEARE_ALGEBRA_3;

	private static Statement FU_KATEGORIENTHEORIE;
	private static Statement FU_KATEGORIENTHEORIE_1;

	private static Statement FU_TOPOLOGIE1;
	private static Statement FU_TOPOLOGIE1_1;

	private static Statement FU_WAHRSCHEINLICHKEITSTHEORIE1;
	private static Statement FU_WAHRSCHEINLICHKEITSTHEORIE1_1;

	private static Statement FU_STATISTIK;
	private static Statement FU_STATISTIK_2;

	private static Statement FU_ANALYSIS1;
	private static Statement FU_ANALYSIS1_1;

	static {
		try {
			REFERENCE = reference(null, null, null, null, null, null, null);

			// WIKIPEDIA_DE = reference(null, "Wikipedia (Deutsch)", "wikipedia (de): ", "https://de.wikipedia.org", "https://de.wikipedia.org/wiki/", null,
			// Locale.GERMAN.getLanguage());
			// WIKIPEDIA_EN = reference(null, "Wikipedia (English)", "wikipedia (en): ", "https://en.wikipedia.org", "https://en.wikipedia.org/wiki/", null,
			// Locale.ENGLISH.getLanguage());
		} catch (Exception ex) {

			JOptionPane.showMessageDialog(null, "exception in initializing");
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	private References() {
		super("references", null);
	}
	/**
	 * 
	 * @param name
	 * @param shortName
	 * @param url
	 * @param urlPrefix
	 * @return
	 * @throws Exception
	 */
	public static Statement reference(Statement baseReference, String name, String shortName, String url, String urlPrefix, String urlSuffix, String language,
			String authors)
			throws Exception {
		Statement result = FACTORY.statement("reference", Statement.NAIVE,
				Arrays.asList(baseReference, Logic.variableIfNotNull(name), Logic.variableIfNotNull(shortName), Logic.variableIfNotNull(url),
						Logic.variableIfNotNull(urlPrefix), Logic.variableIfNotNull(urlSuffix), Logic.variableIfNotNull(language),
						Logic.variableIfNotNull(authors)));
		return result;
	}

	public static Statement reference(Statement baseReference, String name, String shortName, String url, String urlPrefix, String urlSuffix, String language)
			throws Exception {
		return reference(baseReference, name, shortName, url, urlPrefix, urlSuffix, language, null);
	}

	/**
	 * As method and not in the static initializer because of problems with the initializations of the classes
	 */
	private static Statement getWIKIPEDIA_DE() throws Exception {
		if (WIKIPEDIA_DE == null) {
			WIKIPEDIA_DE = reference(null, "Wikipedia (Deutsch)", "wikipedia (de): ", "https://de.wikipedia.org", "https://de.wikipedia.org/wiki/", null,
					Locale.GERMAN.getLanguage(), null);
		}

		return WIKIPEDIA_DE;

	}

	private static Statement getWIKIBOOKS_DE() throws Exception {
		if (WIKIBOOKS_DE == null) {
			WIKIBOOKS_DE = reference(null, "Wikibooks (Deutsch)", "wikibooks (de): ", "https://de.wikibooks.org", "https://de.wikibooks.org/wiki/", null,
					Locale.GERMAN.getLanguage(), null);
		}

		return WIKIPEDIA_DE;

	}

	private static Statement getWIKIPEDIA_EN() throws Exception {
		if (WIKIPEDIA_EN == null) {
			WIKIPEDIA_EN = reference(null, "Wikipedia (English)", "wikipedia (en): ", "https://en.wikipedia.org", "https://en.wikipedia.org/wiki/", null,
					Locale.ENGLISH.getLanguage(), null);
		}

		return WIKIPEDIA_EN;

	}

	private static Statement getFERNUNIVERSITAET() throws Exception {
		if (FERNUNIVERSITAET == null) {
			FERNUNIVERSITAET = reference(null, "FernUniversität Hagen", "FU ", null, null, null,
					Locale.GERMAN.getLanguage(), null);
		}

		return FERNUNIVERSITAET;

	}
	private static Statement getFU_NAIVE_MENGENLEHRE() throws Exception {
		if (FU_NAIVE_MENGENLEHRE == null) {
			FU_NAIVE_MENGENLEHRE = reference(getFERNUNIVERSITAET(), "Naive Mengenlehre 000006386 (08.88) ", "ML ", null, null, null,
					Locale.GERMAN.getLanguage(), null);
		}

		return FU_NAIVE_MENGENLEHRE;

	}

	private static Statement getFU_LINEARE_ALGEBRA() throws Exception {
		if (FU_LINEARE_ALGEBRA == null) {
			FU_LINEARE_ALGEBRA = reference(getFERNUNIVERSITAET(), "Lineare Algebra Mengenlehre 000141321 (10/90) ", "LA ", null, null, null,
					Locale.GERMAN.getLanguage(), null);
		}

		return FU_LINEARE_ALGEBRA;

	}

	private static Statement getFU_NAIVE_MENGENLEHRE_1() throws Exception {
		if (FU_NAIVE_MENGENLEHRE_1 == null) {
			FU_NAIVE_MENGENLEHRE_1 = reference(getFU_NAIVE_MENGENLEHRE(), "KE 1 ", "KE 1  ", null, null, null,
					Locale.GERMAN.getLanguage(), null);
		}

		return FU_NAIVE_MENGENLEHRE_1;

	}

	private static Statement getFU_NAIVE_MENGENLEHRE_2() throws Exception {
		if (FU_NAIVE_MENGENLEHRE_2 == null) {
			FU_NAIVE_MENGENLEHRE_2 = reference(getFU_NAIVE_MENGENLEHRE(), "KE 2 ", "KE 2 ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_NAIVE_MENGENLEHRE_2;

	}

	private static Statement getFU_LINEARE_ALGEBRA_2() throws Exception {
		if (FU_LINEARE_ALGEBRA_2 == null) {
			FU_LINEARE_ALGEBRA_2 = reference(getFU_LINEARE_ALGEBRA(), "KE 2 ", "KE 2  ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_LINEARE_ALGEBRA_2;

	}

	private static Statement getFU_LINEARE_ALGEBRA_3() throws Exception {
		if (FU_LINEARE_ALGEBRA_3 == null) {
			FU_LINEARE_ALGEBRA_3 = reference(getFU_LINEARE_ALGEBRA(), "KE 3 ", "KE 3  ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_LINEARE_ALGEBRA_3;

	}

	private static Statement getFU_KATEGORIENTHEORIE() throws Exception {
		if (FU_KATEGORIENTHEORIE == null) {
			FU_KATEGORIENTHEORIE = reference(getFERNUNIVERSITAET(), "Kategorientheorie ", "KAT ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_KATEGORIENTHEORIE;

	}

	private static Statement getFU_KATEGORIENTHEORIE_1() throws Exception {
		if (FU_KATEGORIENTHEORIE_1 == null) {
			FU_KATEGORIENTHEORIE_1 = reference(getFU_KATEGORIENTHEORIE(), "KE 1 ", "KE 1  ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_KATEGORIENTHEORIE_1;

	}

	private static Statement getFU_TOPOLOGIE1() throws Exception {
		if (FU_TOPOLOGIE1 == null) {
			FU_TOPOLOGIE1 = reference(getFERNUNIVERSITAET(), "Topologie 1 ", "TOP1 ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_TOPOLOGIE1;

	}

	private static Statement getFU_TOPOLOGIE1_1() throws Exception {
		if (FU_TOPOLOGIE1_1 == null) {
			FU_TOPOLOGIE1_1 = reference(getFU_TOPOLOGIE1(), "KE 1 ", "KE 1  ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_TOPOLOGIE1_1;

	}

	private static Statement getFU_WAHRSCHEINLICHKEITSTHEORIE1() throws Exception {
		if (FU_WAHRSCHEINLICHKEITSTHEORIE1 == null) {
			FU_WAHRSCHEINLICHKEITSTHEORIE1 = reference(getFERNUNIVERSITAET(), "Wahrscheinlichkeitstheorie 1 000010022(10/91)", "WT1 ", null, null, null,
					Locale.GERMAN.getLanguage(), "O. Moeschlin, W. Eberl, E. Krug, H. Meister");
		}

		return FU_WAHRSCHEINLICHKEITSTHEORIE1;

	}

	private static Statement getFU_WAHRSCHEINLICHKEITSTHEORIE1_1() throws Exception {
		if (FU_WAHRSCHEINLICHKEITSTHEORIE1_1 == null) {
			FU_WAHRSCHEINLICHKEITSTHEORIE1_1 = reference(getFU_WAHRSCHEINLICHKEITSTHEORIE1(), "KE 1 ", "KE 1  ", null, null, null, Locale.GERMAN.getLanguage(),
					null);
		}

		return FU_WAHRSCHEINLICHKEITSTHEORIE1_1;

	}

	private static Statement getFU_STATISTIK() throws Exception {
		if (FU_STATISTIK == null) {
			FU_STATISTIK = reference(getFERNUNIVERSITAET(), "Statistik 000196118(10/89)", "ST ", null, null, null, Locale.GERMAN.getLanguage(),
					"Jochen Schwarze unter Mitarbeit von Lidmila Fusoková und Harald Kunitz");
		}

		return FU_STATISTIK;
	}

	private static Statement getFU_STATISTIK_2() throws Exception {
		if (FU_STATISTIK_2 == null) {
			FU_STATISTIK_2 = reference(getFU_STATISTIK(), "KE 2 ", "KE 2  ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_STATISTIK_2;

	}

	private static Statement getFU_ANALYSIS1() throws Exception {
		if (FU_ANALYSIS1 == null) {
			FU_ANALYSIS1 = reference(getFERNUNIVERSITAET(), "Analysis 1 ", "AN1 ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_ANALYSIS1;

	}

	private static Statement getFU_ANALYSIS1_1() throws Exception {
		if (FU_ANALYSIS1_1 == null) {
			FU_ANALYSIS1_1 = reference(getFU_ANALYSIS1(), "KE 1 ", "KE 1  ", null, null, null, Locale.GERMAN.getLanguage(), null);
		}

		return FU_ANALYSIS1_1;

	}

	public static Statement wikiDe(String name) throws Exception {
		return reference(getWIKIPEDIA_DE(), name, name, null, null, name, null);
	}

	public static Statement wikiEn(String name) throws Exception {
		return reference(getWIKIPEDIA_EN(), name, name, null, null, name, null);
	}

	public static Statement wikibooksDe(String name) throws Exception {
		return reference(getWIKIBOOKS_DE(), name, name, null, null, name, null);
	}

	public static Statement ml1(String name) throws Exception {
		return reference(getFU_NAIVE_MENGENLEHRE_1(), name, name, null, null, null, null);
	}

	public static Statement ml2(String name) throws Exception {
		return reference(getFU_NAIVE_MENGENLEHRE_2(), name, name, null, null, null, null);
	}

	public static Statement wt1(String name) throws Exception {
		return reference(getFU_WAHRSCHEINLICHKEITSTHEORIE1(), name, name, null, null, null, null);
	}

	public static Statement la2(String name) throws Exception {
		return reference(getFU_LINEARE_ALGEBRA_2(), name, name, null, null, null, null);
	}

	public static Statement la3(String name) throws Exception {
		return reference(getFU_LINEARE_ALGEBRA_3(), name, name, null, null, null, null);
	}

	public static Statement kat1(String name) throws Exception {
		return reference(getFU_KATEGORIENTHEORIE_1(), name, name, null, null, null, null);
	}

	public static Statement top1_1(String name) throws Exception {
		return reference(getFU_TOPOLOGIE1_1(), name, name, null, null, null, null);
	}

	public static Statement stat2(String name) throws Exception {
		return reference(getFU_STATISTIK_2(), name, name, null, null, null, null);
	}

	public static Statement an1_1(String name) throws Exception {
		return reference(getFU_ANALYSIS1_1(), name, name, null, null, null, null);
	}

	public static Statement url(String url) throws Exception {
		return reference(null, null, null, url, null, null, null);
	}

    //private Ref   FernUniversität Hagen
	//private Ref   Naive Mengenlehre 000006386 (08.88)   ML
	//private Ref   KE 1  (Satznr)

}
