package net.sf.gluebooster.demos.pojo.math.library;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Numbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsFactory;
import net.sf.gluebooster.demos.pojo.math.studies.RuleSelect;
import net.sf.gluebooster.java.booster.essentials.meta.objects.TextDescription;

/**
 * Utilities for classes containing statements.
 * 
 * @author cbauer
 *
 */
public interface VariableExamples {

	public static Object NULL = RuleSelect.NULL;
	public static Object USE_VARIABLES = RuleSelect.USE_VARIABLES;
	public static Object FIRST_VARIABLE = RuleSelect.FIRST_VARIABLE;
	public static Object SECOND_VARIABLE = RuleSelect.SECOND_VARIABLE;
	public static Object THIRD_VARIABLE = RuleSelect.THIRD_VARIABLE;
	public static Object FOURTH_VARIABLE = RuleSelect.FOURTH_VARIABLE;
	public static Object FIFTH_VARIABLE = RuleSelect.FIFTH_VARIABLE;
	public static Object NAME = RuleSelect.NAME;
	public static Object NAME_OF_FIRST_VARIABLE = RuleSelect.NAME_OF_FIRST_VARIABLE;
	public static Object FIRST_VARIABLE_OF_FIRST_VARIABLE = RuleSelect.FIRST_VARIABLE_OF_FIRST_VARIABLE;
	public static Object SELF = RuleSelect.SELF;
	public static Object AFTER_FIRST_VARIABLE = RuleSelect.AFTER_FIRST_VARIABLE;
	public static Object ALL_VARIABLES = RuleSelect.ALL_VARIABLES;

	public static Statement CONDITION_1 = Basics.comment("A1");
	public static Statement CONDITION_2 = Basics.comment("A2");
	public static Statement CONDITION_3 = Basics.comment("A3");
	public static Statement CONDITION_4 = Basics.comment("A4");

	public static final Statement NOTHING = Logic.var("");
	public static final Statement EMPTY = Logic.var(" ");
	public static final Statement DOTS = Basics.comment("..");
	public static Statement more = Basics.comment("...");

	public static final Statement PLUS = Logic.var("+");
	public static final Statement MULT = Logic.var("∙");

	public static final Statement ZERO = Numbers.number(0);
	public static final Statement ONE = Numbers.number(1);
	public static final Statement TWO = Numbers.number(2);
	public static final Statement THREE = Numbers.number(3);
	public static final Statement FOUR = Numbers.number(4);
	public static final Statement FIVE = Numbers.number(5);
	public static final Statement SIX = Numbers.number(6);
	public static final Statement TEN = Numbers.number(10);
	public static final Statement INFINITE = Numbers.number("∞");

	public static final Statement MINUS_ONE = Numbers.number(-1);

	public static final Statement A = Logic.var("A");
	public static final Statement Abold = Logic.var("A").setDisplayVariant(TextDescription.BOLD);
	public static final Statement Aapos = Logic.var("A'");
	public static final Statement B = Logic.var("B");
	public static final Statement Bapos = Logic.var("B'");
	public static final Statement C = Logic.var("C");
	public static final Statement Capos = Logic.var("C'");
	public static final Statement D = Logic.var("D");
	public static final Statement F = Logic.var("F");
	public static final Statement G = Logic.var("G");
	public static final Statement I = Logic.var("I");
	public static final Statement J = Logic.var("J");
	public static final Statement K = Logic.var("K");
	public static final Statement P = Logic.var("P");
	public static final Statement R = Logic.var("R");
	public static final Statement S = Logic.var("S");
	public static final Statement T = Logic.var("T");
	public static final Statement U = Logic.var("U");

	public static final Statement pi = Logic.var("π");

	public static final Statement τ = Logic.var("τ");
	public static final Statement tau = τ;
	public static final Statement τ1 = Logic.var("τ", ONE);
	public static final Statement τ2 = Logic.var("τ", TWO);


	public static final Statement X = Logic.var("X");
	public static final Statement Y = Logic.var("Y");

	public static final Statement a = Logic.var("a");
	public static final Statement b = Logic.var("b");
	public static final Statement c = Logic.var("c");
	public static final Statement d = Logic.var("d");
	public static final Statement e = Logic.var("e");
	public static final Statement f = Logic.var("f");
	public static final Statement g = Logic.var("g");
	public static final Statement h = Logic.var("h");
	public static final Statement i = Logic.var("i");
	public static final Statement j = Logic.var("j");
	public static final Statement k = Logic.var("k");
	public static final Statement m = Logic.var("m");
	public static final Statement n = Logic.var("n");
	public static final Statement x = Logic.var("x");
	public static final Statement y = Logic.var("y");

	public static final Statement A_1 = Logic.var("A", ONE);
	public static final Statement A_2 = Logic.var("A", TWO);
	public static final Statement A_3 = Logic.var("A", THREE);
	public static final Statement A_i = Logic.var("A", i);
	public static final Statement A_n = Logic.var("A", n);
	public static final Statement A_tau = Logic.var("A", tau);

	public static final Statement B_1 = Logic.var("B", ONE);
	public static final Statement B_2 = Logic.var("B", TWO);
	public static final Statement B_i = Logic.var("B", i);
	public static final Statement G_f = Logic.var("G", f);
	public static final Statement G_g = Logic.var("G", g);
	public static final Statement G_R = Logic.var("G", R);
	public static final Statement G_S = Logic.var("G", S);
	public static final Statement X_1 = Logic.var("X", ONE);
	public static final Statement X_2 = Logic.var("X", TWO);
	public static final Statement X_i = Logic.var("X", i);
	public static final Statement X_j = Logic.var("X", j);
	public static final Statement X_n = Logic.var("X", n);
	public static final Statement Y_1 = Logic.var("Y", ONE);
	public static final Statement Y_2 = Logic.var("Y", TWO);

	public static final Statement a_1 = Logic.var("a", ONE);
	public static final Statement a_2 = Logic.var("a", TWO);
	public static final Statement a_i = Logic.var("a", i);
	public static final Statement b_1 = Logic.var("b", ONE);
	public static final Statement b_2 = Logic.var("b", TWO);
	public static final Statement c_1 = Logic.var("c", ONE);
	public static final Statement c_2 = Logic.var("c", TWO);
	public static final Statement f_1 = Logic.var("f", ONE);
	public static final Statement f_2 = Logic.var("f", TWO);
	public static final Statement f_3 = Logic.var("f", THREE);
	public static final Statement f_i = Logic.var("f", i);
	public static final Statement f_j = Logic.var("f", j);
	public static final Statement f_n = Logic.var("f", n);

	public static final Statement f_of_x = MappingsFactory.functionValueAt(f, x);
	public static final Statement g_of_x = MappingsFactory.functionValueAt(g, x);


	public static final Statement i_1 = Logic.var("i", ONE);
	public static final Statement i_n = Logic.var("i", n);
	public static final Statement iPlus1 = Logic.var("i+1");

	public static final Statement nPlus1 = Logic.var("n+1");

	public static final Statement x_1 = Logic.var("x", ONE);
	public static final Statement x_2 = Logic.var("x", TWO);
	public static final Statement x_i = Logic.var("x", i);
	public static final Statement x_n = Logic.var("x", n);
	public static final Statement x_n_plus_1 = Logic.var("x", nPlus1);


	// public static final Statement aElementA = ClassesSets.elementOf(a, A);
	// public static final Statement bElementA = ClassesSets.elementOf(b, A);
	// public static final Statement cElementA = ClassesSets.elementOf(c, A);

	// public static final Statement bElementB = ClassesSets.elementOf(b, B);

	public static final Statement a_a = Tuples.tuple(a, a);
	public static final Statement a_b = Tuples.tuple(a, b);
	public static final Statement a_c = Tuples.tuple(a, c);
	public static final Statement a_d = Tuples.tuple(a, d);
	public static final Statement b_a = Tuples.tuple(b, a);
	public static final Statement b_d = Tuples.tuple(b, d);
	public static final Statement b_c = Tuples.tuple(b, c);
	public static final Statement c_a = Tuples.tuple(c, a);
	public static final Statement c_b = Tuples.tuple(c, b);

	public static final Statement d_b = Tuples.tuple(d, b);
	public static final Statement d_c = Tuples.tuple(d, c);
	public static final Statement x_y = Tuples.tuple(x, y);

	public static final Statement A_B = Tuples.tuple(A, B);
	public static final Statement A_X = Tuples.tuple(A, X);
	public static final Statement X_A = Tuples.tuple(X, A);
	public static final Statement X_B = Tuples.tuple(X, B);

	public static final Statement Ai = Logic.var("A", i);
	public static final Statement Rj = Logic.var("R", j);

	public static final Statement abc = Basics.commaSeparated(a, b, c);

}
