package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class Algebra extends AlgebraFactory {


	public static Statement HETEROGENOUS_ALGEBRA;

	public static Statement ALGEBRA;

	private Algebra() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "algebra (1)", null, "Algebra (1)", null);

			HETEROGENOUS_ALGEBRA = heterogenousAlgebra(null, null, null);
			HETEROGENOUS_ALGEBRA.setReferences(References.wikiDe("Heterogene_Algebra"));
			// HETEROGENOUS_ALGEBRA.setBe(Arrays.asList(Mapp.clasz(A), ClassesSets.clasz(B)));
			// HETEROGENOUS_ALGEBRA.setMain();
			Statement classFamily = RelationBinary.indexedFamily(Ai, i, I, null);
			Statement operationFamily = RelationBinary.indexedFamily(f_j, j, J, null);
			Statement heterogenousAlgebra = heterogenousAlgebra(A, classFamily, operationFamily);
			heterogenousAlgebra.setDisplayLevel(EXTENDED);
			definition(HETEROGENOUS_ALGEBRA, "heterogenous Algebra", null, "heterogene Algebra", "Eine heterogene Algebra ",
					heterogenousAlgebra,
					" ist eine Familie von Klassen (in der Regel Mengen) ", classFamily,
					" zusammen mit einer Familie heterogener Operationen ", operationFamily,
					" auf diesen Klassen. Sind die Operationen partiell spricht man von einer partiellen heterogenen Algebra.");
			MathMLGenerator.displayRule(HETEROGENOUS_ALGEBRA,
					WriteExtended.defaultExtended(MathMLGenerator.WRITE_NAME, MathMLGenerator.WRITE_NAME_DEFINED_AS_FIRST_SECOND));

			ALGEBRA = algebra(null, null, null);
			ALGEBRA.setReferences(References.wikiDe("Algebraische_Struktur"), References.wikiDe("Algebraic_structure"));
			ALGEBRA.be(ClassesSets.clasz(B));
			// HETEROGENOUS_ALGEBRA.setMain();
			Statement algebra = algebra(A, B, operationFamily);
			algebra.setDisplayLevel(EXTENDED);
			Statement algebra2 = algebra(A, B, RelationBinary.indexedFamilyFinite(f_1, DOTS, f_n));
			algebra2.setDisplayLevel(EXTENDED);
			definition(ALGEBRA, "algebraic structure", null, "Algebra", "Eine Algebra ", algebra, " ist eine Klasse (in der Regel Menge) ", B,
					" zusammen mit einer Familie von Verknüpfungen ", operationFamily,
					" auf dieser Klasse. Andere Bezeichnungen sind 'algebraische Struktur', 'universelle Algebra', 'allgemeine Algebra'. Sind die Operationen partiell spricht man von einer partiellen Algebra. Bei einer endlichen Anzahl an Funktionen schreibt man auch ",
					algebra2, " Es handelt sich also um eine Struktur, bei der nur Operationen, aber keine Relationen definiert werden.");
			MathMLGenerator.displayRule(ALGEBRA,
					MathMLGenerator.SHORT_NAME_DEFAULT_TUPLE_EXTENDED_DEFINED /*
																				 * WriteExtended.shortDefault(MathMLGenerator.WRITE_NAME,
																				 * MathMLGenerator.WRITE_OPERATION_BRACKETS_AND_COMMA,
																				 * MathMLGenerator.WRITE_NAME_DEFINED_AS_FIRST_SECOND)
																				 */);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1, Arrays.asList(HETEROGENOUS_ALGEBRA, ALGEBRA), (List) Arrays.asList());
	}

}
