package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.General;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class AlgebraFactory extends Statements {

	protected static final AlgebraFactory SINGLETON = new AlgebraFactory();

	protected AlgebraFactory() {
		super("algebra", General.SINGLETON);
	}


	public static Statement heterogenousAlgebra(Statement name, Statement familyOfClasses, Statement familyOfHeterogenousOperations) {
		return SINGLETON.normal(name, "heterogenousAlgebra", familyOfClasses, familyOfHeterogenousOperations);
	}

	public static Statement algebra(Statement name, Statement clasz, Statement familyOfHeterogenousOperations) {
		return SINGLETON.normal(name, "algebra", clasz, familyOfHeterogenousOperations);
	}


}
