package net.sf.gluebooster.demos.pojo.math.library.algebra;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.categoryTheory.CategoryTheoryFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsSamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public interface AlgebraSamplesWithOneFunction extends MappingsSamples {


	Statement algebraWithMultiplication = AlgebraFactory.algebra(null, A, RelationBinary.indexedFamilyFinite(shortMultiplication));

	Statement pseudoMagmaA = MagmaFactory.pseudoMagma(A, A, multDot.copy().setDisplayLevel(Statements.SHORT));
	Statement pseudoMagmaAextended = pseudoMagmaA.copy().setDisplayLevel(Statements.EXTENDED);
	Statement pseudoMagmaAshort = pseudoMagmaA.copy().setDisplayLevel(Statements.SHORT);
	Statement pseudoMagmaAextendedType = pseudoMagmaA.copy().setDisplayLevel(Statements.VERY_EXTENDED);

	Statement pseudoMagmaC = MagmaFactory.pseudoMagma(C, C, multDot.copy().setDisplayLevel(Statements.SHORT));

	Statement magmaA = MagmaFactory.magma(pseudoMagmaA);


	Statement partialSemigroupA = SemiGroupFactory.partialSemigroup(pseudoMagmaA);
	Statement partialSemigroupAextended = partialSemigroupA.copy().setDisplayLevel(Statements.EXTENDED);
	Statement partialSemigroupAextendedType = partialSemigroupA.copy().setDisplayLevel(Statements.VERY_EXTENDED);
	Statement partialSemigroupAshort = partialSemigroupA.copy().setDisplayLevel(Statements.SHORT);

	Statement semigroupA = SemiGroupFactory.semigroup(pseudoMagmaA);
	Statement semigroupAextended = semigroupA.copy().setDisplayLevel(Statements.EXTENDED);
	Statement semigroupAextendedType = semigroupA.copy().setDisplayLevel(Statements.VERY_EXTENDED);
	Statement semigroupAshort = semigroupA.copy().setDisplayLevel(Statements.SHORT);

	Statement categoryA = CategoryTheoryFactory.category(pseudoMagmaA);
	Statement categoryAshort = categoryA.copy().setDisplayLevel(Statements.SHORT);
	Statement categoryAextended = categoryA.copy().setDisplayLevel(Statements.EXTENDED);
	Statement categoryAextendedType = categoryA.copy().setDisplayLevel(Statements.VERY_EXTENDED);

	Statement categoryC = CategoryTheoryFactory.category(pseudoMagmaC);
	Statement categoryCshort = categoryC.copy().setDisplayLevel(Statements.SHORT);
	Statement categoryCextendedType = categoryC.copy().setDisplayLevel(Statements.VERY_EXTENDED);

	Statement monoidAe = MonoidFactory.monoid(pseudoMagmaA, e);
	Statement monoidAeShort = monoidAe.copy().setDisplayLevel(Statements.SHORT);
	Statement monoidAeExtended = monoidAe.copy().setDisplayLevel(Statements.EXTENDED);
	Statement monoidAeExtendedType = monoidAe.copy().setDisplayLevel(Statements.VERY_EXTENDED);
}
