package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Integers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Numbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.RationalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Associative;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Commutative;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of group theory
 * 
 * @author cbauer
 *
 */
public class Group extends GroupFactory implements AlgebraSamplesWithOneFunction {


	private static final Statement GROUP;

	private static final Statement INVERSE_IS_UNIQUE;

	// private static final Statement ABELIAN_GROUP;

	private Group() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "group", null, "Gruppe", null);
			titleText(SINGLETON.unit(1), "group", null, "Gruppe", null);


			GROUP = group(null);
			GROUP.setReferences(References.wikiEn("Group_(mathematics)"), References.wikiDe("Gruppe_(Mathematik)"), an1_1("1.2.1"));
			GROUP.be(Monoid.monoid(A, null));
			GROUP.setMain(Bool.definedAsEqualTo(group(A), Logic.forAll(aElemA, Inverse.invertible(a))));
			definition(GROUP, "group", null, "Gruppe", "Man hat somit Assoziativität, ein neutrales Element und inverse Elemente.");
			GROUP.setExamples(//
					Bool.BOOL_XOR, Integers.INTEGERS_PLUS, Tuples.tuple(RationalNumbers.SET_OF_RATIONAL_NUMBERS, Numbers.PLUS),
					Tuples.tuple(RationalNumbers.SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO, Numbers.MULT));
			// Basics.notSeparated(NaturalNumbers.MAGMA_N_MULT, ", ", NaturalNumbers.MAGMA_N0_MULT,
			// " sind abelsche Monoide mit der 1 als neutralem Element."),
			// Basics.notSeparated(NaturalNumbers.MAGMA_N0_PLUS, " ist abelsches Monoid mit der 0 als neutralem Element."));

			INVERSE_IS_UNIQUE = SINGLETON.normal("INVERSE_IS_UNIQUE");
			INVERSE_IS_UNIQUE.be(group(A));
			lemma(INVERSE_IS_UNIQUE, null, null, "Inverses ist eindeutig",
					"Es gibt keine zwei inverse Elemente zu einem gegebenen Element. Das inverse Element ist eindeutig bestimmt. ");
			INVERSE_IS_UNIQUE.setProofs(Bool.impliesMultiline(//
					Basics.comment("Seien a, b inverse Elemente zu x. Sei n das neutrale Element der Gruppe."), //
					Logic.equals(n, ax_, xa_, bx_, xb_), //
					Logic.equals(xa_, xb_), //
					Logic.equals(a_xa_, a_xb_), //
					Logic.equals(ax_a_, ax_b_), //
					Logic.equals(na_, nb_), //
					Logic.equals(a, b) //
			//
			));

			// ABELIAN_GROUP = abelian(null);
			// ABELIAN_GROUP.be(group(A));
			// ABELIAN_GROUP.setMain(Bool.definedAsEqualTo(abelian(A), Commutative.commutativePartialBinaryOperation(multDot)));
			// definition(ABELIAN_GROUP, "abelian group", null, "abelsche Gruppe", "Man spricht von einer kommutativen oder abelschen Gruppe.");


		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1, Arrays.asList(GROUP, INVERSE_IS_UNIQUE/* , ABELIAN_GROUP */), //
				(List) Arrays.asList());
	}

}
