package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.General;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class GroupFactory extends Statements {

	protected static final GroupFactory SINGLETON = new GroupFactory();


	protected GroupFactory() {
		super("group", General.SINGLETON);

	}


	public static Statement group(Statement pseudoMagma) {
		Statement result = SINGLETON.normal("group", pseudoMagma);
		return result;
	}

	public static Statement abelian(Statement group) {
		Statement result = SINGLETON.normal("abelian", group);
		return result;
	}

}
