package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsSamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class Identity extends IdentityFactory implements AlgebraSamplesWithOneFunction, SetTheorySamples {


	public static Statement LEFT_IDENTITY;

	public static Statement RIGHT_IDENTITY;

	public static Statement IDENTITY;

	public static Statement PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE;

	public static Statement MAGMA_IDENTITY_UNIQUE;

	public static Statement UNITAL;

	private Identity() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "Identity", null, "Neutrales Element", null);



			LEFT_IDENTITY = leftIdentity(null, null);
			LEFT_IDENTITY.setReferences(References.wikiDe("Neutrales_Element"), References.wikiEn("Identity_element"));
			LEFT_IDENTITY.be(pseudoMagmaAextendedType, ClassesSets.elementOf(e, A));
			LEFT_IDENTITY.setMain(Bool.definedAsEqualTo(leftIdentity(e, pseudoMagmaA),
					Logic.forAll(aElemA, Bool.implies(Mappings.mappingDefinedAt(ea), Logic.equals(ea, a)))));
			definition(LEFT_IDENTITY, "left identity", null, "linksneutrales Element", null);
			LEFT_IDENTITY.setExamples(//
					Basics.comment("Die 1 bei der Multiplikation (natürlicher, reeller, ...) Zahlen."), //
					Basics.comment("Die 0 bei der Addition (natürlicher inklusive 0, ganzer, reeller, ...) Zahlen.")//
			);

			RIGHT_IDENTITY = rightIdentity(null, null);
			RIGHT_IDENTITY.setReferences(References.wikiDe("Neutrales_Element"), References.wikiEn("Identity_element"));
			RIGHT_IDENTITY.be(pseudoMagmaAextendedType, ClassesSets.elementOf(e, A));
			RIGHT_IDENTITY
					.setMain(Bool.definedAsEqualTo(rightIdentity(e, pseudoMagmaA),
							Logic.forAll(aElemA, Bool.implies(Mappings.mappingDefinedAt(ae), Logic.equals(ae, a)))));
			definition(RIGHT_IDENTITY, "right identity", null, "rechtsneutrales Element", null);
			RIGHT_IDENTITY.setExamples(//
					Basics.comment("Die 1 bei der Multiplikation (natürlicher, reeller, ...) Zahlen."), //
					Basics.comment("Die 0 bei der Addition (natürlicher inklusive 0, ganzer, reeller, ...) Zahlen.")//
			);

			IDENTITY = identity(null, null);
			IDENTITY.setReferences(References.wikiDe("Neutrales_Element"), References.wikiEn("Identity_element"));
			IDENTITY.be(pseudoMagmaAextendedType, ClassesSets.elementOf(e, A));
			IDENTITY.setMain(Bool.definedAsEqualTo(identity(e, pseudoMagmaA), Bool.and(leftIdentity(e, pseudoMagmaA), rightIdentity(e, pseudoMagmaA))));
			definition(IDENTITY, "identity", null, "neutrales Element",
					"Ein neutrales Element wird (in der Kategorientheorie) auch als Einheit bezeichnet. Bei passenden Kontexten (z.B. Multiplikation oder Addition) nennt man das neutrale Element auch gerne 1 (Einselement) oder 0 (Nullelement).");
			IDENTITY.setExamples(//
					Basics.comment("Die 1 bei der Multiplikation (natürlicher, reeller, ...) Zahlen."), //
					Basics.comment("Die 0 bei der Addition (natürlicher inklusive 0, ganzer, reeller, ...) Zahlen."), //
					Basics.blankSeparated("Das FALSUM", Bool.FALSUM, " bei der XOR-Funktion der Booleschen Menge", Bool.BOOLEAN_SET), //
					Basics.blankSeparated("Das VERUM", Bool.VERUM, " bei der AND-Funktion der Booleschen Menge", Bool.BOOLEAN_SET)
			);

			PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE = SINGLETON.normal("PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE");
			PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE.setReferences(References.kat1("1.2.5"));
			PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE.be(pseudoMagmaAextendedType, leftIdentity(aElemA, pseudoMagmaA), rightIdentity(bElemA, pseudoMagmaA));
			PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE.setMain(Bool.implies(Mappings.mappingDefinedAt(ab), Logic.equals(a, b)));
			lemma(PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE, null, null, "neutrales Element fast eindeutig in Pseudomagma",
					"Insbesondere gilt: Ist die Multiplikation zweier neutraler Elemente definiert, so sind sie gleich.");
			PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE
					.setProofs(Logic.equalsMultiline(a, Basics.proofline(ab, rightIdentity(b, A)), Basics.proofline(b, leftIdentity(a, A))));

			MAGMA_IDENTITY_UNIQUE = SINGLETON.normal("MAGMA_IDENTITY_UNIQUE");
			MAGMA_IDENTITY_UNIQUE.be(magmaA);
			MAGMA_IDENTITY_UNIQUE.setMain(Bool.implies(Bool.and(identity(aElemA, pseudoMagmaA), identity(bElemA, pseudoMagmaA)), Logic.equals(a, b)));
			lemma(MAGMA_IDENTITY_UNIQUE, null, null, "neutrales Element eindeutig in Magma", "In einem Magma kann es nur ein neutrales Element geben.");
			MAGMA_IDENTITY_UNIQUE.setProofs(Bool.impliesMultiline(//
					Bool.and(identity(aElemA, pseudoMagmaA), identity(bElemA, pseudoMagmaA)), Basics.proofline(Mappings.mappingDefinedAt(ab), magmaA),
					Basics.proofline(Logic.equals(a, b), PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE)));

			UNITAL = unital(null, null);
			UNITAL.setReferences(wikiEn("Magma_(algebra)#Classification_by_properties"));
			UNITAL.be(pseudoMagmaAextendedType);
			UNITAL.setMain(Bool.definedAsEqualTo(unital(A, e), Logic.exists(eElemA, Identity.identity(e, magmaA))));
			definition(UNITAL, "unital", null, "unitär", "Ein Pseudomagma mit einem neutralen Element heißt unitär. Analoges gilt für Spezialisierungen.");

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(LEFT_IDENTITY, RIGHT_IDENTITY, IDENTITY, PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE, MAGMA_IDENTITY_UNIQUE, UNITAL),
				(List) Arrays.asList());
	}

}
