package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsSamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class IdentityFactory extends Statements implements MappingsSamples {

	protected static final IdentityFactory SINGLETON = new IdentityFactory();


	protected IdentityFactory() {
		super("identity", RelationBinary.SINGLETON);

	}


	public static Statement leftIdentity(Statement identity, Statement pseudoMagma) {
		return SINGLETON.normal("leftIdentity", identity, pseudoMagma);
	}

	public static Statement rightIdentity(Statement identity, Statement pseudoMagma) {
		return SINGLETON.normal("rightIdentity", identity, pseudoMagma);
	}

	public static Statement identity(Statement identity, Statement pseudoMagma) {
		return SINGLETON.normal("identity", identity, pseudoMagma);
	}

	public static Statement unital(Statement magma, Statement identity) {
		return SINGLETON.normal("unital", magma, identity);
	}

}
