package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Numbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.SetTheorySamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsSamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class Inverse extends InverseFactory implements AlgebraSamplesWithOneFunction, SetTheorySamples {


	public static Statement LEFT_INVERSE;
	public static Statement LEFT_INVERTIBLE;
	public static Statement RIGHT_INVERSE;
	public static Statement RIGHT_INVERTIBLE;
	public static Statement INVERSE;
	public static Statement INVERTIBLE;


	private Inverse() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "inverse element", null, "Inverses Element", null);
			titleText(SINGLETON.unit(1), "inverse element", null, "Inverses Element", null);



			LEFT_INVERSE = leftInverse(null);
			LEFT_INVERSE.setReferences(References.wikiDe("Inverses_Element"), References.wikiEn("Inverse_element"));
			LEFT_INVERSE.be(pseudoMagmaAextendedType, Identity.unital(A, e), Identity.identity(ClassesSets.elementOf(e, A), A), aElemA);
			LEFT_INVERSE.setMain(Bool.definedAsEqualTo(leftInverse(a), Logic.exists(bElemA, Logic.equals(ab_, e))));
			definition(LEFT_INVERSE, "left inverse", null, "linksinverses", "a ist das Linksinverse von b, b ist linksinvertierbar.");

			LEFT_INVERTIBLE = leftInvertible(null);
			definition(LEFT_INVERTIBLE, "left invertible", null, "linksinvertierbar", null);

			RIGHT_INVERSE = rightInverse(null);
			RIGHT_INVERSE.setReferences(References.wikiDe("Inverses_Element"), References.wikiEn("Inverse_element"));
			RIGHT_INVERSE.be(pseudoMagmaAextendedType, Identity.unital(A, e), Identity.identity(ClassesSets.elementOf(e, A), A), bElemA);
			RIGHT_INVERSE.setMain(Bool.definedAsEqualTo(rightInverse(b), Logic.exists(aElemA, Logic.equals(ab_, e))));
			definition(RIGHT_INVERSE, "right inverse", null, "rechtsinverses", "b ist das Rechtsinverse von a, a ist rechtsinvertierbar.");

			RIGHT_INVERTIBLE = rightInvertible(null);
			definition(RIGHT_INVERTIBLE, "right invertible", null, "rightinvertierbar", null);

			INVERSE = inverse(null);
			INVERSE.setReferences(References.wikiDe("Inverses_Element"), References.wikiEn("Inverse_element"));
			INVERSE.setMain(Bool.definedAsEqualTo(inverse(b), Logic.exists(aElemA, Logic.equals(ab_, e, ba_))));
			definition(INVERSE, "inverse", null, "inverses",
					"b ist das Inverse von a und umgekehrt; a und b sind invertierbar. Je nach Kontext wird das Inverse von a gerne als -a oder ",
					Numbers.exp_1(a), " geschrieben.");

			INVERTIBLE = invertible(null);
			definition(INVERTIBLE, "invertible", null, "invertierbar", null);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(LEFT_INVERSE, RIGHT_INVERSE, INVERSE), Arrays.asList(LEFT_INVERTIBLE, RIGHT_INVERTIBLE, INVERTIBLE));
	}

}
