package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsSamples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class InverseFactory extends Statements implements MappingsSamples {

	protected static final InverseFactory SINGLETON = new InverseFactory();


	protected InverseFactory() {
		super("inverse element", null);

	}


	public static Statement leftInverse(Statement leftInverse) {
		return SINGLETON.normal("leftInverse", leftInverse);
	}

	public static Statement leftInvertible(Statement leftInvertibleElement) {
		return SINGLETON.normal("leftInvertible", leftInvertibleElement);
	}

	public static Statement rightInverse(Statement rightInverse) {
		return SINGLETON.normal("rightInverse", rightInverse);
	}

	public static Statement rightInvertible(Statement rightInvertibleElement) {
		return SINGLETON.normal("rightInvertible", rightInvertibleElement);
	}

	public static Statement inverse(Statement inverse) {
		return SINGLETON.normal("inverse", inverse);
	}

	public static Statement invertible(Statement invertibleElement) {
		return SINGLETON.normal("invertible", invertibleElement);
	}

}
