package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class Magma extends MagmaFactory implements AlgebraSamplesWithOneFunction {

	public static Statement PSEUDO_MAGMA;

	public static Statement MAGMA;

	private static final Statement COMMUTATIVE_PSEUDO_MAGMA;


	private Magma() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "(Pseudo)Magma (1)", null, "(Pseudo)Magma (1)", null);


			PSEUDO_MAGMA = pseudoMagma(null, null, null);
			PSEUDO_MAGMA.setReferences(References.kat1("1.2.4"), References.wikiDe("Pseudo-Magma"), References.wikiEn("Partial_groupoid"));
			PSEUDO_MAGMA.be(ClassesSets.clasz(A), multiplication);
			PSEUDO_MAGMA.setUnimportant(Logic.definedAs(pseudoMagmaA, algebraWithMultiplication));
			definition(PSEUDO_MAGMA, null, null, "Pseudo-Magma",
					"Ein Pseudomagma ist eine partielle Algebra (A,f).  Wird für die partielle Abbildung keine spezielle Funktion verwendet, so schreibt man die Operation meist als Multiplikation ∙  oder ohne Operationszeichen. Man spricht dann auch von einem Pseudomagma A, ohne die Operation explizit zu erwähnen. In der Regel wird ein Pseudo-Magma nur über Mengen (statt Klassen) definiert. In der Kategorientheorie werden jedoch Klassen verwendet, daher hier die allgemeiner Definition. In der Kategorientheorie verwendet man auch die Bezeichnung 'Klasse mit partieller Multiplikation' für ein Pseudo-Magma. Eine andere Bezeichnung ist partielles Gruppoid oder partielles Magma.");
			MathMLGenerator.displayRule(PSEUDO_MAGMA, MathMLGenerator.SHORT_NAME_DEFAULT_TUPLE_EXTENDED_DEFINED);
			// WriteExtended.shortDefault(MathMLGenerator.WRITE_NAME, MathMLGenerator.WRITE_OPERATION_BRACKETS_AND_COMMA, ));


			MAGMA = magma(null);
			MAGMA.setReferences(References.wikiDe("Magma_(Mathematik)"));
			MAGMA.be(pseudoMagmaAextendedType);
			// MAGMA.setMain(Arrays.asList(Boolean.definedAsEqualTo(magma(pseudoMagmaA), Mappings.mapping(multiplication))));
			definition(MAGMA, null, null, "Magma", "Ein Magma ist ein Pseudo-Magma mit einer totalen Funktion, nicht nur einer partiellen.");
			MathMLGenerator.displayRule(MAGMA, WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED, FIRST_VARIABLE_OF_FIRST_VARIABLE,
					new Object[] { Basics.DEF_NAMES, SELF }));
			MAGMA.setExamples(//
					Basics.blankSeparated(NaturalNumbers.MAGMA_N_PLUS, " die natürlichen Zahlen mit der Addition."), //
					Basics.blankSeparated(NaturalNumbers.MAGMA_N_MULT, " die natürlichen Zahlen mit der Multiplikation."), //
					Basics.blankSeparated(NaturalNumbers.MAGMA_N0_PLUS, " die natürlichen Zahlen (inkl. Null) mit der Addition."), //
					Basics.blankSeparated(NaturalNumbers.MAGMA_N0_MULT, " die natürlichen Zahlen (inkl. Null) mit der Multiplikation."), //
					Basics.blankSeparated(Bool.BOOL_XOR, " die Boolesche Menge mit XOR als Funktion."), //
					Basics.blankSeparated(Bool.BOOL_AND, " die Boolesche Menge mit AND als Funktion.") //
			);

			COMMUTATIVE_PSEUDO_MAGMA = commutative(null);
			COMMUTATIVE_PSEUDO_MAGMA.setReferences(References.wikiDe("Pseudo-Magma#Rechengesetze"), References.la3("1.5.5"));
			COMMUTATIVE_PSEUDO_MAGMA.be(pseudoMagmaAextendedType);
			// MAGMA.setMain(Arrays.asList(Boolean.definedAsEqualTo(magma(pseudoMagmaA), Mappings.mapping(multiplication))));
			definition(COMMUTATIVE_PSEUDO_MAGMA, null, null, "kommutativ",
					"Eine Pseudo-Magma (und davon abgeleitete Strukturen wie Magma, Halbgruppe, Gruppe, ...) heißt kommutativ (abelsch), wenn die Operation kommutativ ist.");
			COMMUTATIVE_PSEUDO_MAGMA.setExamples(//
					Basics.blankSeparated(NaturalNumbers.MAGMA_N_PLUS, ",", NaturalNumbers.MAGMA_N0_PLUS,
							" die natürlichen Zahlen (inkl. Null) mit der Addition."), //
					Basics.blankSeparated(NaturalNumbers.MAGMA_N_MULT, ",", NaturalNumbers.MAGMA_N0_MULT,
							" die natürlichen Zahlen (inkl. Null) mit der Multiplikation."), //
					Basics.blankSeparated(Bool.BOOL_AND, ",", Bool.BOOL_XOR, " die Boolesche Menge mit der UND- oder XOR-Operation") //
			);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(PSEUDO_MAGMA, MAGMA, COMMUTATIVE_PSEUDO_MAGMA),
				Arrays.asList(Bool.BOOL_AND, Bool.BOOL_XOR));
	}

}
