package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.General;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class MagmaFactory extends Statements {

	protected static final MagmaFactory SINGLETON = new MagmaFactory();

	protected MagmaFactory() {
		super("magma", General.SINGLETON);

	}


	public static Statement pseudoMagma(Statement nameOfInstance, Statement clasz, Statement partialBinaryOperation) {
		if (nameOfInstance == null) {
			nameOfInstance = clasz;
		}
		return SINGLETON.normal(nameOfInstance, "pseudoMagma", clasz, partialBinaryOperation);
	}


	public static Statement magma(Statement pseudoMagma) {
		return SINGLETON.normal("magma", pseudoMagma);
	}

	public static Statement magma(Statement nameOfInstance, Statement clasz, Statement partialBinaryOperation) {
		return magma(pseudoMagma(nameOfInstance, clasz, partialBinaryOperation));
	}


	public static Statement commutative(Statement pseudoMagma) {
		return SINGLETON.normal("commutative", pseudoMagma);
	}

}
