package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements about monoids.
 * 
 * @author cbauer
 *
 */
public class Monoid extends MonoidFactory implements AlgebraSamplesWithOneFunction {

	private static final Statement MONOID;

	private static final Statement MONOID_IS_CATEGORY;
	// Monoid is category


	private Monoid() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "monoid", null, "Monoid", null);



			MONOID = monoid(null, null);
			MONOID.setReferences(References.wikiEn("monoid"), References.wikiDe("Monoid"));
			MONOID.be(ClassesSets.set(A), semigroupAextendedType);
			MONOID.setMain(Bool.definedAsEqualTo(monoidAeExtendedType, Identity.unital(A, null)));
			// MONOID.be(ClassesSets.set(A), semigroupAextendedType);
			// MONOID.setMain(Bool.definedAsEqualTo(monoidAeExtendedType, Logic.exists(eElemA, Identity.identity(e, pseudoMagmaA))));
			definition(MONOID, "monoid", null, "Monoid",
					"Ein Monoid ist eine unitäre Halbgruppe, also eine Menge mit einer assoziativen totalen Operation und einem neutralen Element. Das neutrale Element ist eindeutig, wie bereits beim Magma bewiesen.  ");
			MathMLGenerator.displayRule(MONOID, MathMLGenerator.WRITE_DELEGATE_TO_FIRST_VARIABLE);
			MONOID.setExamples(//
					Basics.notSeparated(NaturalNumbers.MAGMA_N_MULT, ", ", NaturalNumbers.MAGMA_N0_MULT,
							" sind abelsche Monoide mit der 1 als neutralem Element."),
					Basics.notSeparated(NaturalNumbers.MAGMA_N0_PLUS, " ist abelsches Monoid mit der 0 als neutralem Element."));

			MONOID_IS_CATEGORY = SINGLETON.normal("MONOID_IS_CATEGORY");
			definition(MONOID_IS_CATEGORY, null, null, "Jedes Monoid ist eine Kategorie",
					"Ein Monoid ist eine Kategorie, die starke Assoziativität ergibt sich aus der Assoziativität der Halbgruppe; die für die Kategorie benötigten neutralen Elemente sind das neutrale Element des Monoids.");

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1, (List) Arrays.asList(MONOID, MONOID_IS_CATEGORY), (List) Arrays.asList());
	}

}
