package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.General;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class MonoidFactory extends Statements {

	protected static final MonoidFactory SINGLETON = new MonoidFactory();


	protected MonoidFactory() {
		super("Monoid", General.SINGLETON);

	}


	public static Statement monoid(Statement pseudoMagma, Statement identity) {
		return SINGLETON.normal("monoid", pseudoMagma, identity);
	}

	public static Statement monoid(Statement set, Statement binaryOperation, Statement identity) {
		return monoid(SemiGroup.semigroup(set, binaryOperation), identity);
	}

}
