package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Associative;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class SemiGroup extends SemiGroupFactory implements AlgebraSamplesWithOneFunction {


	private static final Statement PARTIAL_SEMIGROUP;

	private static final Statement SEMIGROUP;


	private SemiGroup() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "semigroup", null, "Halbgruppe", null);


			PARTIAL_SEMIGROUP = partialSemigroup(null);
			PARTIAL_SEMIGROUP.setReferences(References.wikiEn("Partial_groupoid"));
			PARTIAL_SEMIGROUP.be(pseudoMagmaAextendedType);
			PARTIAL_SEMIGROUP
					.setMain(Arrays.asList(Bool.definedAsEqualTo(partialSemigroupAextendedType,
							Associative.associativePartialBinaryOperation(pseudoMagmaA.getVariables().get(1))
					//
			)));
			definition(PARTIAL_SEMIGROUP, "partial semigroup", null, "partielle Halbgruppe", "Eine Klasse mit einer assoziativen partiellen Operation.");
			MathMLGenerator.displayRule(PARTIAL_SEMIGROUP, MathMLGenerator.WRITE_DELEGATE_TO_FIRST_VARIABLE);

			SEMIGROUP = semigroup(null);
			SEMIGROUP.setReferences(References.wikiDe("Halbgruppe"), References.wikiEn("Semigroup"));
			SEMIGROUP.be(partialSemigroupAextendedType);
			// MAGMA.setMain(Arrays.asList(Boolean.definedAsEqualTo(magma(pseudoMagmaA), Mappings.mapping(multiplication))));
			definition(SEMIGROUP, "semigroup", null, "Halbgruppe",
					"Eine Halbgruppe ist eine partielle Halbgruppe mit einer totalen Funktion, nicht nur einer partiellen.");
			MathMLGenerator.displayRule(SEMIGROUP, MathMLGenerator.WRITE_DELEGATE_TO_FIRST_VARIABLE);


		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1, (List) Arrays.asList(PARTIAL_SEMIGROUP, SEMIGROUP), (List) Arrays.asList());
	}

}
