package net.sf.gluebooster.demos.pojo.math.library.algebra;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.General;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class SemiGroupFactory extends Statements {

	protected static final SemiGroupFactory SINGLETON = new SemiGroupFactory();


	protected SemiGroupFactory() {
		super("SemiGroup", General.SINGLETON);

	}


	public static Statement partialSemigroup(Statement pseudoMagma) {
		Statement result = SINGLETON.normal("partialSemigroup", pseudoMagma);
		// result.setNameOfInstance(pseudoMagma.getNameOfInstance());
		return result;
	}

	public static Statement semigroup(Statement pseudoMagma) {
		return SINGLETON.normal("semigroup", pseudoMagma);
	}

	public static Statement semigroup(Statement clasz, Statement binaryOperation) {
		return semigroup(Magma.pseudoMagma(null, clasz, binaryOperation));
	}

}
