package net.sf.gluebooster.demos.pojo.math.library.algebra.linear;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Integers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.RationalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.RealNumbers;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of set theory concerning classes.
 * 
 * @see https://glossar.hs-augsburg.de/Klasse_(Mengenlehre)
 * 
 * @author cbauer
 *
 */
public class VectorSpace extends Statements {

	private static final VectorSpace FACTORY = new VectorSpace();


	private VectorSpace() {
		super("vectorSpace", LinearAlgebra.SINGLETON);
	}

	static {
		try {
			titleText(FACTORY.unit(1), "Vector spaces (1)", null, "Vektorräume (1)", null);



		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


	public static StudyUnit createStudyUnit1() {
		return new StudyUnit(FACTORY, 1,
				(List) Arrays.asList(),
				(List) Arrays.asList());
	}



}
