package net.sf.gluebooster.demos.pojo.math.library.categoryTheory;

import java.util.Arrays;
import java.util.List;

import com.sun.org.apache.xalan.internal.xsltc.DOM;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.algebra.AlgebraSamplesWithOneFunction;
import net.sf.gluebooster.demos.pojo.math.library.algebra.Identity;
import net.sf.gluebooster.demos.pojo.math.library.algebra.Magma;
import net.sf.gluebooster.demos.pojo.math.library.algebra.SemiGroup;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Associative;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.MappingsFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.TextBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class CategoryTheory extends CategoryTheoryFactory implements AlgebraSamplesWithOneFunction {


	private static final Statement CATEGORY;

	private static final Statement SMALL_CATEGORY;

	private static final Statement OBJECTCLASS;

	private static final Statement DISCRETE_CATEGORY;

	private static final Statement DOMAIN;

	private static final Statement DOMAIN_UNIQUE;

	private static final Statement CODOMAIN;

	private static final Statement CODOMAIN_UNIQUE;

	private static final Statement MORPHISM;

	private static final Statement MAPPING_AND_DOMAINS;

	private static final Statement DOMAINS_OF_PRODUCTS;

	private static final Statement DOMAINS_OF_OBJECT;

	private static final Statement OBJECTS_AND_DOMAINS;

	private static final Statement MOR;

	private static final Statement MOR_UNION;

	private static final Statement LOCALLY_SMALL_CATEGORY;

	private static final Statement FINITE_CATEGORY;

	private CategoryTheory() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "category theory (1)", null, "Kategorientheorie (1)", null);


			Statement multStringlyAssociative = Associative.stronglyAssociativePartialBinaryOperation(multDot);

			



			Statement aX = mult(a, X);
			Statement aY = mult(a, Y);
			Statement Xa = mult(X, a);
			Statement Ya = mult(Y, a);

			Statement abDefined = Mappings.mappingDefinedAt(ab);
			Statement aXdefined = Mappings.mappingDefinedAt(aX);
			Statement aYdefined = Mappings.mappingDefinedAt(aY);
			Statement XaDefined = Mappings.mappingDefinedAt(Xa);
			Statement YaDefined = Mappings.mappingDefinedAt(Ya);
			
			Statement domain_a = domain(a);
			Statement domain_ab = domain(ab);
			Statement domain_b = domain(b);
			Statement domain_X = domain(X);

			Statement codomain_a = codomain(a);
			Statement codomain_ab = codomain(ab);
			Statement codomain_b = codomain(b);
			Statement codomain_X = codomain(X);

			Statement obj_A = objectclass(categoryAshort);
			Statement obj_C = objectclass(categoryCshort);

			Statement objectX_C = ClassesSets.elementOf(X, objectclass(categoryC));
			Statement objectY_C = ClassesSets.elementOf(Y, objectclass(categoryC));

			Statement a_domainA = mult(a, domain_a);
			Statement b_domainB = mult(b, domain_b);
			Statement codomainA_a = mult(codomain_a, a);
			Statement codomainB_b = mult(codomain_b, b);
			
			Statement aIsAdomainA = Logic.equals(a, a_domainA);
			Statement bIsCodomainB = Logic.equals(b, codomainB_b);


			CATEGORY = category(null);
			CATEGORY.setReferences(kat1("1.2.6"), wikiDe("Kategorientheorie"), wikiEn("Category_(mathematics)"));
			CATEGORY.be(partialSemigroupAextendedType);
			CATEGORY.setMain(Arrays.asList(Bool.definedAsEqualToMultiline(categoryAextendedType,
					Bool.andMultiline(//
							multStringlyAssociative,
							Logic.forAll(aElemA, Logic.exists(Identity.identity(X, pseudoMagmaA), aXdefined)), Logic.forAll(aElemA,
									Logic.exists(Identity.identity(Y, pseudoMagmaA), YaDefined))
					//
					))));
			definition(CATEGORY, "category", null, "Kategorie", "Die Elemente von ", K,
					" heißen Morphismen, die neutralen Elemente nennt man auch Objekte. Es gibt noch andere, äquivalente Defintionen einer Kategorie, in der die Objekte getrennt von den Morphismen definiert werden.");
			MathMLGenerator.displayRule(CATEGORY, MathMLGenerator.WRITE_DELEGATE_TO_FIRST_VARIABLE);

			SMALL_CATEGORY = SINGLETON.normal("SMALL_CATEGORY");
			SMALL_CATEGORY.setReferences(kat1("1.2.13"), wikiDe("Kategorientheorie"));
			SMALL_CATEGORY.be(categoryAextendedType);
			definition(SMALL_CATEGORY, null, null, "kleine Kategorie",
					"Die Kategorie A heißt klein, wenn die zugrundeliegende Klasse A eine Menge ist. (Es gibt die Kategorie Cat/Kat der kleinen Kategorien)");
			
			OBJECTCLASS = objectclass(null);
			OBJECTCLASS.setReferences(kat1("1.2.10"));
			OBJECTCLASS.be(categoryAextendedType);
			OBJECTCLASS.setMain(Logic.definedAs(obj_A,
					ClassesSets.classByPredicate(null, XelemA, Identity.identity(X, pseudoMagmaA))));
			definition(OBJECTCLASS, null, null, "Objektklasse", "Die Klasse aller Objekte (neutralen Elemente) von A.");
			MathMLGenerator.displayRule(OBJECTCLASS, new WriteMulti("Obj ", FIRST_VARIABLE));
			
			DISCRETE_CATEGORY = SINGLETON.normal("DISCRETE_CATEGORY");
			DISCRETE_CATEGORY.setReferences(kat1("1.2.13"));
			DISCRETE_CATEGORY.be(categoryAextendedType);
			definition(DISCRETE_CATEGORY, null, null, "diskrete Kategorie", "Die Kategorie A heißt diskret, wenn  ", Logic.equals(A, obj_A));

			DOMAIN = domain(null);
			MathMLGenerator.displayRule(DOMAIN, new WriteOperation("Ber(", null, ")"));

			DOMAIN_UNIQUE = SINGLETON.normal("DOMAIN_UNIQUE");
			DOMAIN_UNIQUE.setReferences(kat1("1.2.8"));
			DOMAIN_UNIQUE.be(categoryAextendedType);
			DOMAIN_UNIQUE.setMain(Logic.forAll(aElemA, Logic.existsExactlyOne(Identity.identity(X, pseudoMagmaA), aXdefined)));
			lemma(DOMAIN_UNIQUE, null, null, "Bereich eindeutig",
					"Da zu jedem a ein solches eindeutiges Objekt X existiert, definiert man den Bereich (Domain) wie folgt: ", Logic.definedAs(domain_a, X));
			DOMAIN_UNIQUE.setProofs(
					Basics.multiline(
							Basics.proofline(Logic.forAll(aElemA, Logic.exists(Identity.identity(X, pseudoMagmaA), aXdefined)), categoryAextendedType),
							Bool.impliesMultiline(
									Basics.be(Bool.and(Identity.identity(X, pseudoMagmaA), Identity.identity(Y, pseudoMagmaA), aXdefined, aYdefined)), //
									Bool.and(Logic.equals(a, aX), Logic.equals(a, aY)), //
									Logic.equals(aY, mult(Logic.bracket(aX), Y)), //
									Mappings.mappingDefinedAt(Mappings.mult(multDot, Logic.bracket(aX), Y)), //
									Basics.proofline(Mappings.mappingDefinedAt(Mappings.mult(multDot, a, Logic.bracket(Mappings.mult(multDot, X, Y)))),
											multStringlyAssociative), //
									Basics.proofline(Mappings.mappingDefinedAt(Mappings.mult(multDot, X, Y)), multStringlyAssociative), //
									Basics.proofline(Logic.equals(X, Y), Identity.PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE)
							//
							)
					//
					));

			CODOMAIN = codomain(null);
			MathMLGenerator.displayRule(CODOMAIN, new WriteOperation("Cob(", null, ")"));

			CODOMAIN_UNIQUE = SINGLETON.normal("CODOMAIN_UNIQUE");
			CODOMAIN_UNIQUE.setReferences(kat1("1.2.8"));
			CODOMAIN_UNIQUE.be(categoryAextendedType);
			CODOMAIN_UNIQUE.setMain(Logic.forAll(aElemA, Logic.existsExactlyOne(Identity.identity(X, pseudoMagmaA), XaDefined)));
			lemma(CODOMAIN_UNIQUE, null, null, "Cobereich eindeutig",
					"Da zu jedem a ein solches eindeutiges Objekt X existiert, definiert man den Cobereich (Codomain) wie folgt: ",
					Logic.definedAs(codomain(a), X));
			CODOMAIN_UNIQUE
					.setProofs(
							Basics.multiline(
									Basics.proofline(Logic.forAll(aElemA, Logic.exists(Identity.identity(X, pseudoMagmaA), XaDefined)),
											categoryAextendedType),
									Bool.impliesMultiline(
											Basics.be(
													Bool.and(Identity.identity(X, pseudoMagmaA), Identity.identity(Y, pseudoMagmaA), XaDefined, YaDefined)),
											Bool.and(Logic.equals(a, Xa), Logic.equals(a, Ya)), //
											Logic.equals(Ya, mult(Y, Logic.bracket(Xa))), //
											Mappings.mappingDefinedAt(Mappings.mult(multDot, Y, Logic.bracket(Xa))), //
											Basics.proofline(Mappings.mappingDefinedAt(Mappings.mult(multDot, Logic.bracket(Mappings.mult(multDot, Y, X)), a)),
													multStringlyAssociative), //
											Basics.proofline(Mappings.mappingDefinedAt(Mappings.mult(multDot, Y, X)), multStringlyAssociative), //
											Basics.proofline(Logic.equals(X, Y), Identity.PSEUDO_MAGMA_IDENTITY_ALMOST_UNIQUE)
									//
									)
							//
							));

			MORPHISM = morphism(null, null, null);
			titleText(MORPHISM, null, null, "Schreibweise Morphismus", "Für einen Morphismus f mit Bereich X und Cobereich Y schreibt man kurz ",
					morphism(f, X, Y));
			MathMLGenerator.displayRule(MORPHISM,
					WriteExtended.shortDefault(new WriteMulti(NAME), new WriteMulti(NAME, ":", FIRST_VARIABLE, "—>", SECOND_VARIABLE)));

			MAPPING_AND_DOMAINS = SINGLETON.normal("MAPPING_AND_DOMAINS");
			MAPPING_AND_DOMAINS.setReferences(kat1("1.2.11"));
			MAPPING_AND_DOMAINS.be(categoryAextendedType, aElemA, bElemA);
			Statement left = abDefined;
			Statement right = Logic.equals(domain_a, codomain_b);
			MAPPING_AND_DOMAINS.setMain(Bool.iff(left, right));
			lemma(MAPPING_AND_DOMAINS, null, null, "Bereiche und Definiertheit", null);
			MAPPING_AND_DOMAINS.setProofs(Basics.multiline(//
					Bool.and(aIsAdomainA, bIsCodomainB),
					Bool.iffByIf(//
							Bool.implies(left, right), //
							Bool.impliesMultiline(//
									left, //
									Mappings.mappingDefinedAt(Mappings.mult(multDot, Logic.bracket(Mappings.mult(multDot, a, domain_a)), b)), //
									Mappings.mappingDefinedAt(Mappings.mult(multDot, a, Logic.bracket(Mappings.mult(multDot, domain_a, b)))), //
									Logic.equals(domain_a, codomain_b)//
							), //
					Bool.implies(right, left),
					Bool.impliesMultiline(//
							right, //
							Bool.and(Mappings.mappingDefinedAt(Mappings.mult(multDot, a, domain_a)),
											Mappings.mappingDefinedAt(Logic.equals(Mappings.mult(multDot, codomain_b, b), mult(domain_a, b)))), //
							Mappings.mappingDefinedAt(Logic.equals(Mappings.mult(multDot, Logic.bracket(Mappings.mult(multDot, a, domain_a)), b), ab_)) //

					)//
					)));

			DOMAINS_OF_PRODUCTS = SINGLETON.normal("DOMAINS_OF_PRODUCTS");
			DOMAINS_OF_PRODUCTS.setReferences(kat1("1.2.11"));
			DOMAINS_OF_PRODUCTS.be(categoryAextendedType, aElemA, bElemA);
			DOMAINS_OF_PRODUCTS.setMain(Bool.implies(abDefined, Bool.and(Logic.equals(domain_ab, domain_b), Logic.equals(codomain_ab, codomain_a))));
			lemma(DOMAINS_OF_PRODUCTS, null, null, "Bereiche von Produkten", null);
			DOMAINS_OF_PRODUCTS.setProofs(Basics.multiline(//
					Basics.be(abDefined),
					Bool.implies(Logic.equals(ab_, mult(Logic.bracket(codomainA_a), b), mult(codomain_a, Logic.bracket(ab_))),
							Logic.equals(codomain_a, codomain_ab)),
					Bool.implies(Logic.equals(ab_, mult(a, Logic.bracket(mult(b, domain_b))), mult(Logic.bracket(ab_), domain_b)),
							Logic.equals(domain_b, domain_ab))
					));

			DOMAINS_OF_OBJECT = SINGLETON.normal("DOMAINS_OF_OBJECT");
			DOMAINS_OF_OBJECT.setReferences(kat1("1.2.11"));
			DOMAINS_OF_OBJECT.be(categoryAextendedType, XelemA);
			left = ClassesSets.elementOf(X, obj_A);
			right = Logic.equals(domain_X, X, codomain_X);
			DOMAINS_OF_OBJECT.setMain(Bool.iff(left, right));
			lemma(DOMAINS_OF_OBJECT, null, null, "Bereiche von Objekten", null);
			DOMAINS_OF_OBJECT.setProofs(Bool.iffByIf(//
					Bool.implies(left, right), //
					Basics.multiline(//
							Basics.proofline(Logic.equals(X, mult(X, domain_X), domain_X),
									Basics.comment("da beides Objekte=Einheiten=neutrale Elemente sind")), //
							Basics.proofline(Logic.equals(X, mult(codomain_X, X), codomain_X),
									Basics.comment("da beides Objekte=Einheiten=neutrale Elemente sind")) //
					), //
					Bool.implies(right, left), //
					Basics.proofline(Basics.TRIVIAL, Basics.comment("da Bereich und Cobereich per definitionem Objekte sind"))));

			OBJECTS_AND_DOMAINS = SINGLETON.normal("OBJECTS_AND_DOMAINS");
			OBJECTS_AND_DOMAINS.setReferences(kat1("1.2.11"));
			OBJECTS_AND_DOMAINS.be(categoryAextendedType);
			Statement domainClass = ClassesSets.classByPredicate(domain_a, aElemA);
			Statement codomainClass = ClassesSets.classByPredicate(codomain_a, aElemA);
			OBJECTS_AND_DOMAINS.setMain(Logic.equals(obj_A, domainClass, codomainClass));
			lemma(OBJECTS_AND_DOMAINS, null, null, "Objektklasse und Bereiche", null);
			OBJECTS_AND_DOMAINS.setProofs(Subset.equalsBySubclasses(//
					// proofLeftSubsetRight,
					Bool.impliesMultiline(//
							ClassesSets.elementOf(X, obj_A), //
							Logic.equals(X, domain_X, codomain_X), //
							Bool.and(ClassesSets.elementOf(X, domainClass), ClassesSets.elementOf(X, codomainClass))//
					),
					// proofRightSubsetLeft
					Basics.comment("per definitionem, da Bereich und Cobereiche Objekte sind")));

			MOR = morClass(null, null, null);
			MOR.setReferences(kat1("1.2.12"), wikiDe("Hom-Funktor"), wikiEn("Category_theory"));
			MOR.be(categoryCextendedType, objectX_C, objectY_C);
			MOR.setMain(Logic.definedAs(morClass(C, X, Y), ClassesSets.classByPredicate(aElemC, morphism(a, X, Y))));
			definition(MOR, null, null, "Hom-Klasse",
					"Die Klasse der Morphismen zwischen zwei Objekten. Die Bezeichnung Hom stammt daher, dass Morphismen bei vielen Beispielen Homomorphismen der jeweiligen Strukturen sind. Alternative Schreibweisen sind ",
					Basics.mantissaIndexExponent(Basics.comment("Hom"), C, Basics.EMPTY), "(X,Y) oder ",
					Basics.mantissaIndexExponent(Basics.comment("Mor"), C, Basics.EMPTY),
					"(X,Y) ");
			MathMLGenerator.displayRule(MOR, new WriteMulti(FIRST_VARIABLE, "(", SECOND_VARIABLE, ",", THIRD_VARIABLE, ")"));
			
			
			MOR_UNION = SINGLETON.normal("MOR_UNION");
			MOR_UNION.setReferences(kat1("1.2.12"));
			MOR_UNION.be(categoryCextendedType);
			MOR_UNION.setMain(Logic.equals(C, Union.arbitraryDisjointUnion(Basics.commaSeparated(X, Y), obj_C, morClass(C, X, Y))));
			lemma(MOR_UNION, null, null, "Vereinigung der Morphismenklassen", null);
			MOR_UNION.setProofs(Basics.multiline(//
					Basics.proofline(Subset.subclass(morClass(C, X, Y), categoryCshort), Basics.TRIVIAL), //
					Bool.implies(aElemC, Logic.exists(ClassesSets.elementOf(Basics.commaSeparated(X, Y), obj_C), ClassesSets.elementOf(a, morClass(C, X, Y)))), //
					Bool.impliesMulti(ClassesSets.elementOf(a, Intersection.intersection(morClass(C, X_1, Y_1), morClass(C, X_2, Y_2))),
							Bool.and(morphism(a, X_1, Y_1), morphism(a, X_2, Y_2)), Bool.and(Logic.equals(X_1, X_2), Logic.equals(Y_1, Y_2)))
			//
			));

			LOCALLY_SMALL_CATEGORY = SINGLETON.normal("LOCALLY_SMALL_CATEGORY");
			LOCALLY_SMALL_CATEGORY.setReferences(kat1("1.2.13"));
			LOCALLY_SMALL_CATEGORY.be(categoryCextendedType);
			definition(LOCALLY_SMALL_CATEGORY, null, null, "lokal kleine Kategorie", "Die Kategorie C heißt lokal klein, wenn ",
					Logic.forAll(ClassesSets.elementOf(Basics.commaSeparated(X, Y), obj_C), morClass(C, X, Y)), " eine Menge ist.");

			titleText(SINGLETON.unit(2), "category theory (2)", null, "Kategorientheorie (2)", null);

			FINITE_CATEGORY = SINGLETON.normal("FINITE_CATEGORY");
			FINITE_CATEGORY.setReferences(kat1("1.2.13"));
			FINITE_CATEGORY.be(categoryAextendedType);
			definition(FINITE_CATEGORY, null, null, "endliche Kategorie",
					"Die Kategorie A heißt endlich, wenn die zugrundeliegende Klasse A eine endliche Menge ist. ");

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				(List) Arrays.asList(CATEGORY, SMALL_CATEGORY, OBJECTCLASS, DISCRETE_CATEGORY, DOMAIN_UNIQUE, CODOMAIN_UNIQUE, MORPHISM, MAPPING_AND_DOMAINS,
						DOMAINS_OF_PRODUCTS,
						DOMAINS_OF_OBJECT, OBJECTS_AND_DOMAINS, MOR, MOR_UNION, LOCALLY_SMALL_CATEGORY),
				Arrays.asList(DOMAIN, CODOMAIN));
	}

	public static StudyUnit createStudyUnit2() {

		return new StudyUnit(SINGLETON, 2, Arrays.asList(FINITE_CATEGORY), (List) Arrays.asList());
	}

	private static Statement mult(Statement a, Statement b) {
		return MappingsFactory.mult(multDot, a, b);
	}
}
