package net.sf.gluebooster.demos.pojo.math.library.categoryTheory;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.General;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class CategoryTheoryFactory extends Statements {

	protected static final CategoryTheoryFactory SINGLETON = new CategoryTheoryFactory();


	protected CategoryTheoryFactory() {
		super("category theory", General.SINGLETON);

	}

	public static Statement category(Statement pseudoMagma) {
		return SINGLETON.normal("category", pseudoMagma);
	}

	public static Statement domain(Statement morphism) {
		return SINGLETON.normal("domain", morphism);
	}

	public static Statement codomain(Statement morphism) {
		return SINGLETON.normal("codomain", morphism);
	}

	public static Statement morphism(Statement name, Statement domain, Statement codomain) throws Exception {
		Statement result = SINGLETON.normal("morphism", domain, codomain);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement objectclass(Statement category) {
		return SINGLETON.normal("objectclass", category);
	}

	/**
	 * Morphisms with given domains
	 * 
	 * @param category
	 * @return
	 */
	public static Statement morClass(Statement category, Statement domain, Statement codomain) {
		return SINGLETON.normal("morClass", category, domain, codomain);
	}

}
