package net.sf.gluebooster.demos.pojo.math.library.logic;

import java.util.Arrays;

import net.sf.gluebooster.demos.pojo.math.MathStudiesProofs;
import net.sf.gluebooster.demos.pojo.math.PrologProofGenerator;
import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationSpecial;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.RuleSelect;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.meta.objects.GraphElementDescription;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;
import net.sourceforge.jeuclid.elements.presentation.table.Mtable;
import net.sourceforge.jeuclid.elements.presentation.table.Mtd;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;

/**
 * Boolean domain with two elements.
 *
 * @see https://en.wikipedia.org/wiki/Boolean_algebra
 * @see http://www.zweigmedia.com/RealWorld/logic/logic5.html
 * @author cbauer
 *
 */
public class BoolFactory extends Statements {

	protected static final BoolFactory SINGLETON = new BoolFactory();



	protected BoolFactory() {
		super("boolean", null);
	}

	// later make something not naive

	public static Statement not(Statement formula) {
		return SINGLETON.normal("not", Arrays.asList(formula, null));// the null is for the result
	}

	public static Statement notWithBrackets(Statement formula) {
		return not(Logic.bracket(formula));
	}

	public static Statement and(Statement formulaA, Statement formulaB) {
		return SINGLETON.binary("and", formulaA, formulaB);
	}

	public static Statement and(Statement... formulas) {
		return SINGLETON.normal("and_multiple", Arrays.asList(formulas));
	}

	public static Statement andMultiline(Statement... andParts) {
		return SINGLETON.naive("andMultiline", andParts);
	}

	public static Statement andWithBrackets(Statement formulaA, Statement formulaB) {
		return and(Logic.bracket(formulaA), Logic.bracket(formulaB));
	}

	public static Statement or(Statement formulaA, Statement formulaB) {
		return SINGLETON.binary("or", formulaA, formulaB);
	}

	public static Statement orWithBrackets(Statement formulaA, Statement formulaB) {
		return or(Logic.bracket(formulaA), Logic.bracket(formulaB));
	}

	public static Statement implies(Statement formulaA, Statement formulaB) {
		return SINGLETON.binary("implication", formulaA, formulaB);
	}

	public static Statement impliesMultiline(Statement... implicationChain) {
		return SINGLETON.naive("impliesMultiline", implicationChain);
	}

	public static Statement impliesMulti(Statement... implicationChain) {
		return SINGLETON.naive("impliesMulti", implicationChain);
	}

	public static Statement iffMultiline(Statement... biconditionalChain) {
		return biconditionalMultiline(biconditionalChain);
	}

	public static Statement impliesWithBrackets(Statement formulaA, Statement formulaB) {
		return implies(Logic.bracket(formulaA), Logic.bracket(formulaB));
	}

	public static Statement impliedBy(Statement formulaA, Statement formulaB) {
		return SINGLETON.naiveBinary("implied by", formulaA, formulaB);
	}

	public static Statement biconditional(Statement formulaA, Statement formulaB) {
		return SINGLETON.binary("biconditional", formulaA, formulaB);
	}

	public static Statement biconditionalMultiline(Statement... biconditionalChain) {
		return SINGLETON.naive("biconditionalMultiline", biconditionalChain);
	}


	public static Statement iff(Statement formulaA, Statement formulaB) {
		return BoolFactory.biconditional(formulaA, formulaB);
	}

	/**
	 * Create a proof of a biconditional by splitting it into two conditionals
	 * 
	 * @param implies
	 *            the first conditional to be proved A => B
	 * @param proof1
	 *            the first proof
	 * @param implied
	 *            the second conditional to be proved A <= B
	 * @param proof2
	 *            the second proof
	 * @return
	 */
	public static Statement iffByIf(Statement implies, Statement proof1, Statement implied, Statement proof2) {
		return SINGLETON.normal("iffByIf", implies, proof1, implied, proof2);
	}

	public static Statement xor(Statement formulaA, Statement formulaB) {
		return SINGLETON.binary("xor", formulaA, formulaB);
	}

	public static Statement nand(Statement formulaA, Statement formulaB) {
		return SINGLETON.binary("nand", formulaA, formulaB);
	}

	public static Statement nandWithBrackets(Statement formulaA, Statement formulaB) {
		return nand(Logic.bracket(formulaA), Logic.bracket(formulaB));
	}

	public static Statement nor(Statement formulaA, Statement formulaB) {
		return SINGLETON.binary("nor", formulaA, formulaB);
	}

	/**
	 * formula A is defined by formula B.
	 * 
	 * @param formulaA
	 * @param formulaB
	 * @return
	 */
	public static Statement definedAsEqualTo(Statement formulaA, Statement formulaB) {
		return SINGLETON.naiveBinary("definedAsEqualTo", formulaA, formulaB);
	}

	public static Statement definedAsEqualToMultiline(Statement... chain) {
		return SINGLETON.naive("definedAsEqualToMultiline", chain);
	}



}
