package net.sf.gluebooster.demos.pojo.math.library.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.MathML;
import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.meta.objects.GraphElementDescription;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;
import net.sourceforge.jeuclid.elements.presentation.table.Mtable;
import net.sourceforge.jeuclid.elements.presentation.table.Mtd;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class Logic extends LogicFactory {


	private static final String EXISTS = "∃";
	private static final String ALL = "∀";
	

	// Part 1

	/**
	 * Variable with string as name;
	 */
	public static Statement VARIABLE;

	/**
	 * Variable with statement as name
	 */
	public static Statement VAR;

	public static Statement TERM;

	/**
	 * States that some object are equal
	 */
	public static Statement EQUALS;

	public static Statement EQUALS_MULTILINE;

	/**
	 * States that some object are not equal
	 */
	public static Statement NOT_EQUALS;

	/**
	 * States that something x is defined as some other term y. x:= y
	 */
	public static Statement DEFINED_AS;

	public static Statement DEFINED_AS_MULTIPLE;

	public static Statement PREDICATE;

	public static Statement PROOF_BY_CONTRADICTION;


	// Part 2

	


	/**
	 * States that some object are equal
	 */
	// public static Statement EQUALS;
	
	public static Statement ATOMIC_FORMULA;


	/**
	 * An x exists with formula(x)
	 */
	public static Statement EXISTENTIAL_QUANTIFIER;

	public static Statement EXISTENTIAL_QUANTIFIER_EXACTLY_ONE;

	/**
	 * for all x is formula(x) true
	 */
	public static Statement UNIVERSAL_QUANTIFIER;
	public static Statement UNIVERSAL_QUANTIFIER_MULTILINE;

	/**
	 * formula consist of atomic formulas together with junctors and quantors
	 */
	public static Statement FORMULA;
	
	public static Statement BRACKET;
	
	public static Statement OPERATOR_ORDERING;
	
	public static Statement SWAP_AND_EXISTS;

	public static Statement SWAP_OR_EXISTS;

	public static Statement SWAP_AND_FOR_ALL;

	public static Statement SWAP_OR_FOR_ALL;

	public static Statement SWAP_EXISTS_FOR_ALL;

	public static Statement SWAP_ALL_EXISTS;


	static {
		try {
			Statement A = Logic.var("A");
			Statement B = Logic.var("B");

			// Part 1
			titleText(SINGLETON.unit(1), "Logic (1)", null, "Logik (1)", null);

			VAR = var((Statement) null);
			VARIABLE = var((String) null);
			VARIABLE.setReferences(References.wikiDe("Variable (Mathematik)"), References.wikiDe("Variable (Logik)"),
					References.wikiEn("Variable (mathematics)"));
			definition(VARIABLE, "Variable", null, "Variable",
					Arrays.asList("Eine Variable dient als Platzhalter für eine Rechengröße oder ein komplizierteres mathematisches Objekt oder Ausdruck. Gerne verwendet wird ",
							Logic.var("x"), " oder ", Logic.var("y"), ". Eine typische Bezeichnung für eine Funktion ist ", Logic.var("f"),
							". Variablen können indiziert sein. Beispiele sind ", Logic.var("x", Logic.var("1")), " oder ", Logic.var("f", Logic.var("1")),
							"."));


			TERM = SINGLETON.naive("term");
			TERM.setReferences(References.wikiDe("Prädikatenlogik_erster_Stufe#Terme"), References.wikiEn("First-order_logic#Terms"));
			definition(TERM, "Term", null, "Term", Arrays.asList(
					"Eine Term ist entweder eine Konstante, eine Variable oder eine Funktion mit Termen als Argumenten. Beispiele sind die Konstante 1, die Variable x  oder die Funktionsaufrufe f(1), f(x), f(x,y), f(g(x))."));

			EQUALS = equals(null, null);
			definition(EQUALS, "Equality", null, "Gleichheit",
					"Sind zwei Objekte (Variablen, Terme, ...) A und B gleich, so schreibt man A=B; sind sie nicht gleich schreibt man ", Logic.notEquals(A, B),
					". Wird A per definitionem mit B gleichgesetzt, schreibt man ", definedAs(A, B),
					". Erfolgen mehrere Definitionen des gleichen Werts, so schreibt man diese hintereinander, z.B. ", multipleDefinitions(A, B, C), ".");
			MathMLGenerator.displayRule(EQUALS, MathMLGenerator.WRITE_OPERATION_EQUALS);

			EQUALS_MULTILINE = equalsMultiline();
			// TODO examples with natural numbers 4 = 3+1
			// TODO examples with natural numbers 4 = 3+1 = 1+3
			// TODO examples with natural numbers 4 = 3+1 = 1+3 with explanation (null, 4 is defined as successor of 3, addition is commutative)
			MathMLGenerator.displayRule(EQUALS_MULTILINE, MathMLGenerator.writeMultiline(Logic.equals(Basics.EMPTY, Basics.EMPTY)));

			NOT_EQUALS = notEquals(null, null);
			NOT_EQUALS.setDefinition();
			MathMLGenerator.displayRule(NOT_EQUALS, new WriteOperation("≠"));

			DEFINED_AS = definedAs(null, null);
			MathMLGenerator.displayRule(DEFINED_AS, WRITE_OPERATION_DEFINED_AS);

			DEFINED_AS_MULTIPLE = multipleDefinitions();
			MathMLGenerator.displayRule(DEFINED_AS_MULTIPLE, WRITE_OPERATION_DEFINED_AS);

			PREDICATE = predicate(null);
			PREDICATE.setReferences(References.wikiDe("Prädikat_(Logik)"), References.wikiEn("Predicate_(mathematical_logic)"));
			definition(PREDICATE, "Predicate", null, "Prädikat",
					"Ein Prädikat P ist ein Ausdruck, der zu einer wahren oder falschen Aussage wird, wenn alle Variablen durch konkrete Objekte ersetzt worden sind. Beispiele sind 'x ist gerade Zahl', 'x = y' oder allgemein ",
					predicate(P, x));
			MathMLGenerator.displayRule(PREDICATE, WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED, NAME, "(",
					new Object[] { Basics.COMMA_SEPARATED, ALL_VARIABLES }, ")"));


			// After Boolean Part 1
			Statement varX = var("x");
			Statement varA = var("A");
			Statement varB = var("B");


			// Part 2
			titleText(SINGLETON.unit(2), "Logic (1)", null, "Logik (2)", null);


		
			ATOMIC_FORMULA = SINGLETON.naive("atomic formula");
			ATOMIC_FORMULA.setReferences(References.wikiDe("Prädikatenlogik"), References.wikiEn("First-order_logic#Evaluation_of_truth_values"));
			definition(ATOMIC_FORMULA, "Atomic formula", null, "Primformel",
					"Als Primformel bzw. atomarer Ausdruck werden das Verum, das Falsum oder Prädikate (mit Termen als Argumenten) bezeichnet. Beispiele sind x=y, x > y,  f(x) > f(y), 'x ist gerade Zahl'. ");



			EXISTENTIAL_QUANTIFIER = exists(varX, varA);
			EXISTENTIAL_QUANTIFIER.setNameOfInstance(exists(null, null));
			EXISTENTIAL_QUANTIFIER.setReferences(References.wikiDe("Quantor"), References.wikiDe("Prädikatenlogik"),
					References.wikiEn("First-order_logic#Evaluation_of_truth_values"));
			definition(EXISTENTIAL_QUANTIFIER, "Existential quantifier", null, "Existenzquantor",
					"Der Existenzquantor (∃) ist wahr, genau dann wenn für mindestens ein Object die nachfolgende Formel gilt. Beispiel für eine wahre Aussage ist:  ∃x∈N: x ist gerade Zahl.  Eine falsche Aussage ist ",
					EXISTS, "x", ClassesSets.ELEMENT, "N: x < 0. Existiert genau ein Wert x für den die Formel gilt schreibt man ", EXISTS,
					"! Sprechweise für  ", EXISTS, "x: P(x) ist: Es existiert (mindestens) ein x mit P(x).");
			MathMLGenerator.displayRule(EXISTENTIAL_QUANTIFIER, new WriteOperation(EXISTS, ": ", null));

			EXISTENTIAL_QUANTIFIER_EXACTLY_ONE = existsExactlyOne(varX, varA);
			EXISTENTIAL_QUANTIFIER_EXACTLY_ONE.setNameOfInstance(existsExactlyOne(null, null));
			EXISTENTIAL_QUANTIFIER_EXACTLY_ONE.setDefinition();
			MathMLGenerator.displayRule(EXISTENTIAL_QUANTIFIER_EXACTLY_ONE, new WriteOperation("∃!", ": ", null));

			UNIVERSAL_QUANTIFIER = forAll(varX, varA);
			UNIVERSAL_QUANTIFIER.setNameOfInstance(forAll(null, null));
			UNIVERSAL_QUANTIFIER.setReferences(References.wikiDe("Quantor"), References.wikiDe("Prädikatenlogik"),
					References.wikiEn("First-order_logic#Evaluation_of_truth_values"));
			definition(UNIVERSAL_QUANTIFIER, "Universal quantifier", null, "Allquantor",
					"Der Allquantor (∀) ist wahr, genau dann wenn für alle aufgeführten Objekte die nachfolgende Formel gilt. Beispiel für eine wahre Aussage ist:  ∀ x∈N : x > 0. Eine falsche Aussage ist hingegen ",
					ALL, " x, ", ClassesSets.ELEMENT, "R : x > 0. Sprechweise für  ", ALL, "x: P(x) ist: Für alle x gilt P(x).");
			MathMLGenerator.displayRule(UNIVERSAL_QUANTIFIER, new WriteOperation(ALL, ": ", null));

			UNIVERSAL_QUANTIFIER_MULTILINE = forAllMultiline(null, null);
			MathMLGenerator.displayRule(UNIVERSAL_QUANTIFIER_MULTILINE,
					WriteAfterStatementTransformation.ruleTransformation(Basics.MULTILINE, //
							new Object[] { Basics.BLANK_SEPARATED, ALL, FIRST_VARIABLE, ":" }, //
							SECOND_VARIABLE //
					));

			FORMULA = SINGLETON.naive("formula");
			FORMULA.setReferences(References.wikiDe("Prädikatenlogik"), References.wikiEn("First-order_logic#Evaluation_of_truth_values"),
					References.wikiEn("List_of_logic_symbols"));
			definition(FORMULA, "Formula", null, "Formel", "Formeln (Ausdrücke) setzen sich aus Primformeln, Junktoren (", Bool.not(A), ", ",
					Bool.and(A, B), ", ", Bool.or(A, B), ", ", Bool.implies(A, B), ", ", Bool.biconditional(A, B), ") und Quantoren(",
					Logic.EXISTENTIAL_QUANTIFIER, ", ", Logic.UNIVERSAL_QUANTIFIER,
					") zusammen. Je nach mathematischem Feld gibt es teilweise unterschiedliche Varianten der Symbole.  ");

			BRACKET = bracket(null);

			OPERATOR_ORDERING = SINGLETON.naive("operatorOrdering");
			OPERATOR_ORDERING.setReferences(References.wikiDe("Operatorrangfolge"), References.wikiEn("Order_of_operations"));
			titleText(OPERATOR_ORDERING, "operator ordering", null, "Operatorrangfolge", Bool.not(EMPTY), " hat den höchsten Rang. Es folgen gleichrangig ",
					Bool.and(EMPTY, EMPTY), " und ", Bool.or(EMPTY, EMPTY), ". Danach kommen die Quantoren ", Logic.exists(EMPTY, EMPTY), " und ",
					Logic.forAll(EMPTY, EMPTY), ". Anschließend kommt ", Bool.implies(EMPTY, EMPTY), ". Zum Schluß kommt ", Bool.iff(EMPTY, EMPTY),
					". Beispielsweise kann man ", Bool.and(Logic.bracket(Bool.not(A)), Logic.bracket(Bool.not(B))), " abkürzen zu ",
					Bool.and(Bool.not(A), Bool.not(B)), ".");

			PROOF_BY_CONTRADICTION = proofByContradiction(null);
			titleText(PROOF_BY_CONTRADICTION, "proof by contradiction", null, "Beweis durch Widerspruch", null);
			MathMLGenerator
					.displayRule(PROOF_BY_CONTRADICTION,
							WriteAfterStatementTransformation.ruleTransformation(Basics.MULTILINE, //
									new Object[] { Basics.BLANK_SEPARATED, new Object[] { Basics.DEF_NAMES, Logic.PROOF_BY_CONTRADICTION }, ":",
											Basics.ASSUMPTION }, //
									FIRST_VARIABLE //
							));
			
			
			SWAP_AND_EXISTS = SINGLETON.naive("SWAP_AND_EXISTS");
			SWAP_AND_EXISTS.be(Basics.blankSeparated(A, Basics.comment(", "), B_i, Basics.comment( " beliebige Aussagen") ));
			SWAP_AND_EXISTS.main(Bool.iff(Bool.and(A, exists(i, B_i) ), exists(i, Bool.and(A, B_i)) ));
			lemma(SWAP_AND_EXISTS, null, null, "Vertauschung UND und " + EXISTS);

			SWAP_OR_EXISTS = SINGLETON.naive("SWAP_OR_EXISTS");
			SWAP_OR_EXISTS.be(Basics.blankSeparated(A, Basics.comment(", "), B_i, Basics.comment(" beliebige Aussagen")));
			SWAP_OR_EXISTS.main(Bool.iff(Bool.or(A, exists(i, B_i)), exists(i, Bool.or(A, B_i))));
			lemma(SWAP_OR_EXISTS, null, null, "Vertauschung ODER und " + EXISTS);

			SWAP_AND_FOR_ALL = SINGLETON.naive("SWAP_AND_FOR_ALL");
			SWAP_AND_FOR_ALL.be(Basics.blankSeparated(A, Basics.comment(", "), B_i, Basics.comment(" beliebige Aussagen")));
			SWAP_AND_FOR_ALL.main(Bool.iff(Bool.and(A, forAll(i, B_i)), forAll(i, Bool.and(A, B_i))));
			lemma(SWAP_AND_FOR_ALL, null, null, "Vertauschung UND und " + ALL);

			SWAP_OR_FOR_ALL = SINGLETON.naive("SWAP_OR_FOR_ALL");
			SWAP_OR_FOR_ALL.be(Basics.blankSeparated(A, Basics.comment(", "), B_i, Basics.comment(" beliebige Aussagen")));
			SWAP_OR_FOR_ALL.main(Bool.iff(Bool.or(A, forAll(i, B_i)), forAll(i, Bool.or(A, B_i))));
			lemma(SWAP_OR_FOR_ALL, null, null, "Vertauschung ODER und " + ALL);

			SWAP_EXISTS_FOR_ALL = SINGLETON.naive("SWAP_EXISTS_FOR_ALL");
			SWAP_EXISTS_FOR_ALL.be(Basics.comment("P Prädikat"));
			Statement Px = Basics.comment("P(x)");
			SWAP_EXISTS_FOR_ALL.main(Bool.iff(exists(x, Px), Bool.not(forAll(x, Bool.not(Px)))));
			lemma(SWAP_EXISTS_FOR_ALL, null, null, "Vertauschung Existenz- mit Allquantor ");

			SWAP_ALL_EXISTS = SINGLETON.naive("SWAP_ALL_EXISTS");
			SWAP_ALL_EXISTS.be(Basics.comment("P Prädikat"));
			SWAP_ALL_EXISTS.main(Bool.iff(forAll(x, Px), Bool.not(exists(x, Bool.not(Px)))));
			lemma(SWAP_ALL_EXISTS, null, null, "Vertauschung All- mit Existenzquantor ");

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
		
	}

	private Logic() {
	}

	

	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1, Arrays.asList(VARIABLE, TERM, EQUALS, PREDICATE),
				Arrays.asList(BRACKET, NOT_EQUALS, DEFINED_AS, DEFINED_AS_MULTIPLE));
	}
	
	public static StudyUnit createStudyUnit2() {

		return new StudyUnit(SINGLETON, 2,
				Arrays.asList(ATOMIC_FORMULA, FORMULA,
						EXISTENTIAL_QUANTIFIER,
						UNIVERSAL_QUANTIFIER, OPERATOR_ORDERING, SWAP_AND_EXISTS, SWAP_OR_EXISTS, SWAP_AND_FOR_ALL, SWAP_OR_FOR_ALL, SWAP_EXISTS_FOR_ALL,
						SWAP_ALL_EXISTS),
				Arrays.asList(PROOF_BY_CONTRADICTION, EQUALS_MULTILINE, EXISTENTIAL_QUANTIFIER_EXACTLY_ONE, UNIVERSAL_QUANTIFIER_MULTILINE));
	}

//Klammerung

}
