package net.sf.gluebooster.demos.pojo.math.library.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.MathML;
import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.meta.objects.GraphElementDescription;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;
import net.sourceforge.jeuclid.elements.presentation.table.Mtable;
import net.sourceforge.jeuclid.elements.presentation.table.Mtd;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class LogicFactory extends Statements {

	protected static final LogicFactory SINGLETON = new LogicFactory();

	public static final WriteOperation WRITE_OPERATION_DEFINED_AS = new WriteOperation(":=");




	protected LogicFactory() {
		super("logic", null);
	}

	
	/**
	 * The name is added as fourth element of the identifier
	 * 
	 * @param variableName
	 * @param indices
	 *            optional indices
	 * @return
	 * @throws Exception
	 */ // maybe another constructor with a Statement as name is necessary
	public static Statement var(String variableName, Statement... indices) {
		return naiveWithIdentifyingName(SINGLETON, "variable", variableName, indices);
		// try {
		// Statement result = SINGLETON.naive("variable", Arrays.asList(indices));
		// result.setDisplayIdentifyingNameInPrecondition(true);
		// if (variableName != null) {
		// result.getIdentifier().add(variableName);
		// }
		// return result;
		// } catch (Exception ex) {
		// throw ThrowableBoostUtils.toRuntimeException(ex);
		// }
	}

	public static Statement var(Statement variableName, Statement... indices) {
		try {
			Statement result = SINGLETON.naive("variableWithStatement", Arrays.asList(indices));
			return result;
		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	public static Statement variableIfNotNull(String variableName, Statement... indices) throws Exception {
		if (variableName == null) {
			return null;
		} else {
			return var(variableName, indices);
		}
	}


	public static Statement equals(Statement... equalParts) {
		return equals(Arrays.asList(equalParts), null);
	}

	public static Statement equalsMultiline(Statement... parts) {
		return SINGLETON.naive("equalsMultiline", parts);
	}

	public static Statement equals(List<Statement> equalParts) {
		return equals(equalParts, null);
	}

	public static Statement equals(List<Statement> equalParts, List<Statement> explanations) {
		Statement result = SINGLETON.naive("equals", equalParts);
		result.setVariableInfos(explanations);
		return result;
	}

	/**
	 * Starting with the equal (no first operand)
	 * 
	 * @param other
	 * @return
	 */
	public static Statement isEqualTo(Statement other) {
		return equals(EMPTY, other);
	}

	public static Statement notEquals(Statement s1, Statement s2) {
		Statement result = SINGLETON.naive("notEquals", Arrays.asList(s1, s2));
		return result;
	}

	public static Statement definedAs(Statement newVar, Statement definition) {
		Statement result = SINGLETON.naive("definedAs", Arrays.asList(newVar, definition));
		return result;
	}

	public static Statement multipleDefinitions(Statement... definitions) {
		Statement result = SINGLETON.naive("multipleDefinitions", definitions);
		return result;
	}

	public static Statement predicate(Statement name, List<Statement> variables) {
		Statement result = SINGLETON.naive("predicate", variables);
		result.setNameOfInstance(name);
		return result;
	}

	public static Statement predicate(Statement name, Statement... variables) {
		return predicate(name, Arrays.asList(variables));
	}

	// General

	// Part 2


	public static Statement exists(Statement variable, Statement formula) {
		return SINGLETON.naiveBinary("existential quantifier", variable, formula);
	}

	public static Statement existsExactlyOne(Statement variable, Statement formula) {
		return SINGLETON.naiveBinary("exists exactly one", variable, formula);
	}

	public static Statement forAll(Statement variable, Statement formula) {
		return SINGLETON.naiveBinary("universal quantifier", variable, formula);
	}

	public static Statement forAllMultiline(Statement variable, Statement formula) {
		return SINGLETON.naiveBinary("universal quantifier multiline", variable, formula);
	}

	public static Statement forAllExists(Statement variable1, Statement variable2, Statement formula) {
		return forAll(variable1, exists(variable2, formula));
	}

	public static Statement bracket(Statement inner) {
		return SINGLETON.naive("bracket", inner);
	}

	/**
	 * 
	 * @param proof
	 *            The first text of the proof must be the assumption. The last text of the proof must be the contradiction (FALSUM).
	 * @return
	 * @throws Exception
	 */
	public static Statement proofByContradiction(Statement proof) throws Exception {
		return SINGLETON.normal("proofByContradiction", proof);
	}


}
