package net.sf.gluebooster.demos.pojo.math.library.numberTheory;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class InductionExamples extends Statements {

	private static final InductionExamples SINGLETON = new InductionExamples();

	private InductionExamples() {
		super("induction examples", null);
	}

	public static Statement EXAMPLE_1;
	public static Statement EXAMPLE_2;


	static {
		try {
			titleText(SINGLETON.unit(1), null, null, "Induktionsbeispiele (1)", null);

			EXAMPLE_1 = SINGLETON.normal("EXAMPLE_1");
			example(EXAMPLE_1, null, null, "n*(n+1) ist durch 2 teilbar", null);
			EXAMPLE_1.setProofs(//
					Basics.comment("Ein einfacher Beweis ist: Entweder n oder n+1 ist gerade und daher auch das Produkt."), //
					NaturalNumbers.proofPerInduction(//
							Basics.comment("n=1"), //
							Logic.equals(Basics.comment("n*(n+1)"), Basics.comment("1*2"), TWO), //
							Basics.comment("n->n+1"),
							Logic.equalsMultiline(//
									Basics.comment("(n+1)*((n+1)+1)"), //
									Basics.comment("(n+1)*(n+2)"), //
									Basics.proofline(Basics.comment("(n+1)n + (n+1)2"),
									Basics.comment(
													"Der linke Ausdruck ist nach Induktionsvoraussetzung durch 2 teilbar, der rechte ist ebenfalls durch 2 teilbar, damit ist auch die Summe durch 2 teilbar.")))
					));

			EXAMPLE_2 = SINGLETON.normal("EXAMPLE_2");
			example(EXAMPLE_2, null, null, "Summenbeispiel", null);
			EXAMPLE_2.setMain(
					Logic.equals(Numbers.sum(i, ONE, n, Numbers.fraction(ONE, Basics.comment("(3i-2)(3i+1)"))), Numbers.fraction(n, Basics.comment("3n+1"))));
			EXAMPLE_2.setProofs(//
					Basics.comment("(3n+1)(n+1) = 3n²+n+3n+1= 3n²+ 4n + 1 "),
					NaturalNumbers.proofPerInduction(//
							Basics.comment("n=1"), //
							Logic.equalsMultiline(//
									Numbers.sum(i, ONE, ONE, Numbers.fraction(ONE, Basics.comment("(3i-2)(3i+1)"))), //
									Numbers.fraction(ONE, Basics.comment("(3*1-2)(3*1+1)")), //
									Numbers.fraction(ONE, Basics.comment("1*(4)")), //
									Numbers.fraction(ONE, FOUR), //
									Numbers.fraction(ONE, Basics.comment("3*1+1")) //
							), //
							Basics.comment("n->n+1"),
							Logic.equalsMultiline(//
									Numbers.sum(i, ONE, nPlus1, Numbers.fraction(ONE, Basics.comment("(3i-2)(3i+1)"))), //
									Numbers.plus(Numbers.sum(i, ONE, n, Numbers.fraction(ONE, Basics.comment("(3i-2)(3i+1)"))),
											Numbers.fraction(ONE, Basics.comment("(3(n+1)-2)(3(n+1)+1)"))), //
									Numbers.plus(Numbers.fraction(n, Basics.comment("3n+1")), Numbers.fraction(ONE, Basics.comment("(3n+1)(3(n+1)+1)"))), //
									Numbers.mult(Numbers.fraction(ONE, Basics.comment("3n+1")),
											Logic.bracket(Numbers.plus(n, Numbers.fraction(ONE, Basics.comment("(3(n+1)+1)"))))), //
									Numbers.mult(Numbers.fraction(ONE, Basics.comment("3n+1")),
											Numbers.fraction(Basics.comment("n(3(n+1)+1)+1"), Basics.comment("(3(n+1)+1)"))), //
									Numbers.mult(Numbers.fraction(ONE, Basics.comment("3n+1")),
											Numbers.fraction(Basics.comment("n(3n+4)+1"), Basics.comment("(3(n+1)+1)"))), //
									Numbers.mult(Numbers.fraction(ONE, Basics.comment("3n+1")),
											Numbers.fraction(Basics.comment("3n²+4n+1"), Basics.comment("(3(n+1)+1)"))), //
									Numbers.mult(Numbers.fraction(ONE, Basics.comment("3n+1")),
											Numbers.fraction(Basics.comment("(3n+1)(n+1)"), Basics.comment("(3(n+1)+1)"))), //
									Numbers.fraction(Basics.comment("n+1"), Basics.comment("(3(n+1)+1)"))) //
					));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

	public static StudyUnit createStudyUnit1() {

		return new StudyUnit((Statements) SINGLETON, 1, Arrays.asList(EXAMPLE_1, EXAMPLE_2), (List) Arrays.asList());
	}

}
