package net.sf.gluebooster.demos.pojo.math.library.numberTheory;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.TuplesFactory;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class Integers extends Statements {

	private static final Integers FACTORY = new Integers();

	private Integers() {
		super("integers", null);
	}

	public static Statement SET_OF_INTEGERS_INFORMAL;
	public static Statement SET_OF_INTEGERS;
	public static Statement INTEGERS_PLUS;


	static {
		try {
			SET_OF_INTEGERS_INFORMAL = ClassesSets.clasz(FACTORY.naive("SET_OF_INTEGERS"));
			SET_OF_INTEGERS_INFORMAL.setReferences(References.wikiEn("Integer"), References.wikiDe("Ganze_Zahl"));
			titleText(SET_OF_INTEGERS_INFORMAL, "Set of integers \u2124", null, "Menge der ganzen Zahlen \u2124", null);

			SET_OF_INTEGERS = SET_OF_INTEGERS_INFORMAL;
			MathMLGenerator.displayRule(SET_OF_INTEGERS, WriteOperation.prefix("\u2124"));

			INTEGERS_PLUS = TuplesFactory.pair(SET_OF_INTEGERS, Numbers.PLUS);
		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

}
