package net.sf.gluebooster.demos.pojo.math.library.numberTheory;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.algebra.MagmaFactory;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.TuplesFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.RuleSelect;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements about natural numbers
 * 
 * @author cbauer
 *
 */
public class NaturalNumbers extends NaturalNumbersFactory {


	private NaturalNumbers() {
	}
	
	public static Statement SET_OF_NATURAL_NUMBERS_INFORMAL;
	public static Statement SET_OF_NATURAL_NUMBERS;
	public static Statement SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL;
	public static Statement SET_OF_NATURAL_NUMBERS_UP_TO_INFORMAL;
	public static Statement INDEX_FROM_TO_INFORMAL;
	public static Statement INDUCTION_PRINCIPLE;
	public static Statement MATH_INDUCTION;
	public static Statement PROOF_PER_INDUCTION;
	public static Statement INDUCTIVE_DEFINITION;

	public static Statement MAGMA_N_PLUS;
	public static Statement MAGMA_N0_PLUS;
	public static Statement MAGMA_N_MULT;
	public static Statement MAGMA_N0_MULT;


	/**
	 * Start with n=1  (x1):= x1
	 * Continue (x n+1) = something from x1...xn and xn+1
	 */
	// public static Statement INDUCTIVE_DEFINITION_NAIVE;

	/**
	 *  Sum(x1) = x1; Sum(x1...xn+1) = sum(x1...xn) + x n+1
	 */
	// public static Statement FINITE_SUM_REALNUMBERS_(NAIVE);

	/**
	 *  Prod(x1) = x1; Prod(x1...xn+1) = Prod(x1...xn) + x n+1
	 */
	// public static Statement FINITE_PRODUKT;
	


	//examples missing
	
	//used by function to create
	// public static Statement INDUCTIVE_DEFINITION;

	// private static final Statement n = Numbers.number("n");
	// private static final Statement m = Numbers.number("m");
	// private static final Statement more = Basics.comment("...");
	static {
		try {



			titleText(SINGLETON.unit(1), "Natural numbers (1)", null, "Natürliche Zahlen (1)", null);

			SET_OF_NATURAL_NUMBERS_INFORMAL = ClassesSets.clasz(SINGLETON.naive("SET_OF_NATURAL_NUMBERS"));
			SET_OF_NATURAL_NUMBERS_INFORMAL.setReferences(References.wikiEn("Natural_number"), References.wikiDe("Natürliche_Zahl"));
			SET_OF_NATURAL_NUMBERS_INFORMAL.setInformalMain(
					Logic.definedAs(SET_OF_NATURAL_NUMBERS_INFORMAL, ClassesSets.explicitSet(null, Numbers.ONE, Numbers.TWO, Numbers.THREE, more)));
			titleText(SET_OF_NATURAL_NUMBERS_INFORMAL, "Set of natural numbers \u2115", null, "Menge der natürlichen Zahlen \u2115", null);
			MathMLGenerator.displayRule(SET_OF_NATURAL_NUMBERS_INFORMAL, WriteOperation.prefix("\u2115"));

			SET_OF_NATURAL_NUMBERS = SET_OF_NATURAL_NUMBERS_INFORMAL;

			Statement nElementN = ClassesSets.elementOf(n, SET_OF_NATURAL_NUMBERS_INFORMAL);

			SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL = ClassesSets.clasz(SINGLETON.naive("SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL"));
			SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL.setReferences(References.wikiEn("Natural_number"), References.wikiDe("Natürliche_Zahl"));
			SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL.setInformalMain(Logic.definedAs(SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL,
					ClassesSets.explicitSet(null, Numbers.ZERO, Numbers.ONE, Numbers.TWO, Numbers.THREE, more)));
			titleText(SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL, null, null,
					"Menge der natürlichen Zahlen inklusive Null ", null);
			MathMLGenerator.displayRule(SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL, WriteAfterStatementTransformation
					.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, NaturalNumbers.SET_OF_NATURAL_NUMBERS_INFORMAL, Numbers.ZERO, ""));

			SET_OF_NATURAL_NUMBERS_UP_TO_INFORMAL = upTo(null);
			SET_OF_NATURAL_NUMBERS_UP_TO_INFORMAL.be(nElementN);
			SET_OF_NATURAL_NUMBERS_UP_TO_INFORMAL.setInformalMain(Logic.definedAs(upTo(n), ClassesSets.explicitSet(null, Numbers.ONE, Numbers.TWO, more, n)));
			titleText(SET_OF_NATURAL_NUMBERS_UP_TO_INFORMAL, null, null, "Menge der natürlichen Zahlen bis n ", null);
			MathMLGenerator.displayRule(SET_OF_NATURAL_NUMBERS_UP_TO_INFORMAL, WriteAfterStatementTransformation
					.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, NaturalNumbers.SET_OF_NATURAL_NUMBERS_INFORMAL, FIRST_VARIABLE, ""));

			INDEX_FROM_TO_INFORMAL = indexFromTo(null, null, null);
			INDEX_FROM_TO_INFORMAL.be(nElementN, ClassesSets.elementOf(m, SET_OF_NATURAL_NUMBERS_INFORMAL));
			titleText(INDEX_FROM_TO_INFORMAL, null, null, " i=n..m", "Die Bezeichnung ", indexFromTo(i, n, m), " bedeutet ",
					ClassesSets.elementOf(i, ClassesSets.explicitSet(null, n, more, m)), "Ist n > m ist es die leere Menge. ");
			MathMLGenerator.displayRule(INDEX_FROM_TO_INFORMAL,
					new WriteMulti(RuleSelect.FIRST_VARIABLE, "=", RuleSelect.SECOND_VARIABLE, "..", RuleSelect.THIRD_VARIABLE));

			
			INDUCTION_PRINCIPLE = SINGLETON.normal("INDUCTION_PRINCIPLE");
			INDUCTION_PRINCIPLE.be(Subset.subset(A, SET_OF_NATURAL_NUMBERS));
			INDUCTION_PRINCIPLE.setMain(Bool.impliesMultiline(Bool.andMultiline(ClassesSets.elementOf(ONE, A),
					Bool.implies(ClassesSets.elementOf(i, A), ClassesSets.elementOf(iPlus1, A))), Logic.equals(A, SET_OF_NATURAL_NUMBERS)));
			theorem(INDUCTION_PRINCIPLE, "induction principle", null, "Induktionsprinzip", "Beweis folgt später.");

			MATH_INDUCTION = SINGLETON.normal("MATH_INDUCTION");
			theorem(MATH_INDUCTION, "mathematical induction", null, "Vollständige Induktion",
					"Sei A(i) eine Aussage (abhängig von i). Dann gilt: Gilt der Induktionsanfang A(1) und der Induktionsschritt ",
					Logic.forAll(nElementN, Bool.implies(Basics.comment("A(n)"), Basics.comment("A(n+1)"))), " so gilt A(n) für alle ", nElementN,
					". Dieses Prinzip wird häufig in Beweisen verwendet, bei denen etwas für alle natürlichen Zahlen bewiesen werden muss. Es gibt verschiedene Varianten dieses Prinzips. So kann z.B. durch leichte Abwandlungen der Anfangspunkt auf jede beliebe ganze Zahl gesetzt werden.");
			MATH_INDUCTION.setProofs(
					Basics.notSeparated(Basics.comment("Sei B die Menge "), ClassesSets.classByPredicate(null, nElementN, Basics.comment("A(n) gilt")),
							Basics.comment(" so gilt laut Induktionsanfang "), ClassesSets.elementOf(ONE, B),
							Basics.comment(
									". Die zweite Voraussetzung des Induktionsprinzips ist laut Induktionsschritt erfüllt. Nach dem Induktionsprinzip ist "),
							Logic.equals(B, SET_OF_NATURAL_NUMBERS), Basics.comment(". Also gilt die Aussage für alle natürlichen Zahlen.")));
			
			PROOF_PER_INDUCTION = proofPerInduction(null, null, null, null);
			MathMLGenerator.displayRule(PROOF_PER_INDUCTION,
					WriteAfterStatementTransformation.ruleTransformation(Basics.MULTILINE, "Beweis per Induktion", FIRST_VARIABLE, SECOND_VARIABLE,
							THIRD_VARIABLE, FOURTH_VARIABLE));

			INDUCTIVE_DEFINITION = SINGLETON.naive("INDUCTIVE_DEFINITION");
			definition(INDUCTIVE_DEFINITION, null, null, "Induktive Definition", "Induktiv können auch Terme definiert werden.");
			INDUCTIVE_DEFINITION.setExamples(//
					Basics.multiline(Basics.comment("Summe: "), //
							Logic.definedAs(Numbers.sum(i, ONE, ONE, x_i), x_1), //
							Logic.definedAs(Numbers.sum(i, ONE, nPlus1, x_i), Basics.notSeparated(Logic.bracket(Numbers.sum(i, ONE, n, x_i)), "+", x_n_plus_1))//
					), //
					Basics.multiline(Basics.comment("Produkt: "), //
							Logic.definedAs(Numbers.product(i, ONE, ONE, x_i), x_1), //
							Logic.definedAs(Numbers.product(i, ONE, nPlus1, x_i),
									Basics.notSeparated(Logic.bracket(Numbers.product(i, ONE, n, x_i)), "∙", x_n_plus_1))//
					)

			//
			);

			MAGMA_N_PLUS = TuplesFactory.pair(SET_OF_NATURAL_NUMBERS, PLUS); // MagmaFactory.magma(null, SET_OF_NATURAL_NUMBERS,
																				// PLUS).setDisplayLevel(EXTENDED);
			MAGMA_N_MULT = TuplesFactory.pair(SET_OF_NATURAL_NUMBERS, MULT);// MagmaFactory.magma(null, SET_OF_NATURAL_NUMBERS, MULT);

			MAGMA_N0_PLUS = TuplesFactory.pair(SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL, PLUS);// MagmaFactory.magma(null,
																										// SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL,
																										// PLUS);
			MAGMA_N0_MULT = TuplesFactory.pair(SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL, MULT);// MagmaFactory.magma(null,
																										// SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL,
																										// MULT);

			endOfInitialization();
		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}

	/**
	 * Additional initialization that should (because of circles in the static class loading) be done at the end of the initialization.
	 * 
	 * @throws Exception
	 */
	private static void endOfInitialization() throws Exception {
	}

	public static Statement upTo(Statement lastNumber) throws Exception {
		Statement result = SINGLETON.naive("up to", lastNumber);
		return result;
	}

	public static Statement indexFromTo(Statement index, Statement firstNumber, Statement lastNumber) throws Exception {
		Statement result = SINGLETON.naive("indexFromTo", index, firstNumber, lastNumber);
		return result;
	}

	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(SET_OF_NATURAL_NUMBERS_INFORMAL, SET_OF_NATURAL_NUMBERS_INCLUDING_ZERO_INFORMAL, SET_OF_NATURAL_NUMBERS_UP_TO_INFORMAL,
						INDEX_FROM_TO_INFORMAL, INDUCTION_PRINCIPLE, MATH_INDUCTION, INDUCTIVE_DEFINITION),
				Arrays.asList(MAGMA_N_PLUS, MAGMA_N0_PLUS, MAGMA_N_MULT, MAGMA_N0_MULT, Numbers.SUM_INFORMAL, Numbers.PRODUCT_INFORMAL, PROOF_PER_INDUCTION));
	}

}
