package net.sf.gluebooster.demos.pojo.math.library.numberTheory;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.meta.objects.GraphElementDescription;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;
import net.sourceforge.jeuclid.elements.presentation.general.Mfrac;
import net.sourceforge.jeuclid.elements.presentation.table.Mtable;
import net.sourceforge.jeuclid.elements.presentation.table.Mtd;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;
import net.sourceforge.jeuclid.elements.presentation.token.Mi;

public class Numbers extends NumbersFactory {

	private Numbers() {
	}

	public static Statement NUMBER_INFORMAL;

	public static Statement SUM_INFORMAL;
	public static Statement PLUS_INFORMAL;
	public static Statement MULT_INFORMAL;
	public static Statement PRODUCT_INFORMAL;
	public static Statement FRACTION;


	static {
		try {
			NUMBER_INFORMAL = number((String) null);

			SUM_INFORMAL = sum(null, null, null, null);
			MathMLGenerator.displayRule(SUM_INFORMAL, writeIndexedFromTo("∑"));

			PRODUCT_INFORMAL = product(null, null, null, null);
			MathMLGenerator.displayRule(PRODUCT_INFORMAL, writeIndexedFromTo("∏"));

			FRACTION = fraction(null, null);
			MathMLGenerator.displayRule(FRACTION,
					new WriteOperation(GraphElementDescription.createNestedParentElementsWithIndex(0, Mfrac.ELEMENT),
							GraphElementDescription.createNestedParentElementsWithIndex(0, Mi.ELEMENT), null));

			PLUS_INFORMAL = plus();
			MathMLGenerator.displayRule(PLUS_INFORMAL, new WriteOperation("+"));

			MULT_INFORMAL = mult();
			MathMLGenerator.displayRule(MULT_INFORMAL, new WriteOperation("∙"));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


	public static StudyUnit createStudyUnit() {

		return new StudyUnit(SINGLETON, 1, (List) Arrays.asList(), Arrays.asList(NUMBER_INFORMAL, FRACTION, PLUS_INFORMAL, MULT_INFORMAL));
	}

}
