package net.sf.gluebooster.demos.pojo.math.library.numberTheory;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.algebra.Algebra;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class NumbersFactory extends Statements {

	protected static final NumbersFactory SINGLETON = new NumbersFactory();


	protected NumbersFactory() {
		super("numbers", null);

	}

	public static Statement number(String value) {
		return naiveWithIdentifyingName(SINGLETON, "number", value);
	}

	public static Statement number(Number value) {
		return number(value.toString());
	}

	public static Statement sum(Statement index, Statement from, Statement to, Statement element) {
		return SINGLETON.naive("sum", index, from, to, element);
	}

	public static Statement product(Statement index, Statement from, Statement to, Statement element) {
		return SINGLETON.naive("product", index, from, to, element);
	}

	public static Statement minus(Statement element) {
		return Basics.notSeparated("-", element);
	}

	public static Statement exp_1(Statement element) {
		return Basics.mantissaExponent(element, MINUS_ONE);
	}

	public static Statement fraction(Statement numerator, Statement denominator) {
		return SINGLETON.normal("fraction", numerator, denominator);
	}

	public static Statement plus(Statement... summands) {
		return SINGLETON.normal("plus", summands);
	}

	public static Statement mult(Statement... summands) {
		return SINGLETON.normal("mult", summands);
	}

}
