package net.sf.gluebooster.demos.pojo.math.library.numberTheory;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Difference;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class RationalNumbers extends Statements {

	private static final RationalNumbers SINGLETON = new RationalNumbers();

	private RationalNumbers() {
		super("rationalNumbers", null);
	}

	public static Statement SET_OF_RATIONAL_NUMBERS_INFORMAL;
	public static Statement SET_OF_RATIONAL_NUMBERS;

	public static Statement SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO;

	static {
		try {
			SET_OF_RATIONAL_NUMBERS_INFORMAL = ClassesSets.clasz(SINGLETON.naive("SET_OF_RATIONAL_NUMBERS"));
			SET_OF_RATIONAL_NUMBERS_INFORMAL.setReferences(References.wikiEn("Rational_number"), References.wikiDe("Rationale_Zahl"));
			titleText(SET_OF_RATIONAL_NUMBERS_INFORMAL, "Set of rational numbers \u211A", null, "Menge der rationalen Zahlen \u211A", null);
			MathMLGenerator.displayRule(SET_OF_RATIONAL_NUMBERS_INFORMAL, WriteOperation.prefix("\u211A"));
			SET_OF_RATIONAL_NUMBERS = SET_OF_RATIONAL_NUMBERS_INFORMAL;

			SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO = SINGLETON.normal("SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO");
			SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO
					.setMain(Logic.definedAs(SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO,
							Difference.difference(SET_OF_RATIONAL_NUMBERS_INFORMAL, ClassesSets.explicitSetWithoutName(ZERO))));
			MathMLGenerator.displayRule(SET_OF_RATIONAL_NUMBERS_WITHOUT_ZERO, writeExponent(SET_OF_RATIONAL_NUMBERS_INFORMAL, Basics.comment("*")));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

}
