package net.sf.gluebooster.demos.pojo.math.library.numberTheory;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

public class RealNumbers extends Statements implements NumberSamples {

	private static final RealNumbers SINGLETON = new RealNumbers();

	private RealNumbers() {
		super("realNumbers", null);
	}

	public static Statement SET_OF_REAL_NUMBERS_INFORMAL;
	public static Statement SET_OF_REAL_NUMBERS;

	public static Statement NON_NEGATIVE_REAL_NUMBERS;

	public static Statement NON_POSITIVE_REAL_NUMBERS;

	static {
		try {
			SET_OF_REAL_NUMBERS_INFORMAL = SINGLETON.naive("SET_OF_REAL_NUMBERS");
			SET_OF_REAL_NUMBERS_INFORMAL.setUnimportant(ClassesSets.clasz(SET_OF_REAL_NUMBERS_INFORMAL));
			SET_OF_REAL_NUMBERS_INFORMAL.setReferences(References.wikiEn("Real_number"), References.wikiDe("Reelle_Zahl"));
			titleText(SET_OF_REAL_NUMBERS_INFORMAL, "Set of real numbers \u211D", null, "Menge der reellen Zahlen \u211D", null);
			MathMLGenerator.displayRule(SET_OF_REAL_NUMBERS_INFORMAL, new WriteMulti(" \u211D"));

			SET_OF_REAL_NUMBERS = SET_OF_REAL_NUMBERS_INFORMAL;

			NON_NEGATIVE_REAL_NUMBERS = SINGLETON.naive("NON_NEGATIVE_REAL_NUMBERS");
			NON_NEGATIVE_REAL_NUMBERS.setMain(Logic.definedAs(NON_NEGATIVE_REAL_NUMBERS, ClassesSets.classByPredicate(xReal, Basics.comment("x ≥ 0"))));
			definition(NON_NEGATIVE_REAL_NUMBERS, null, null, "Menge der nicht-negativen reellen Zahlen \u211D+", null);

			NON_POSITIVE_REAL_NUMBERS = SINGLETON.naive("NON_POSITIVE_REAL_NUMBERS");
			NON_POSITIVE_REAL_NUMBERS.setMain(Logic.definedAs(NON_POSITIVE_REAL_NUMBERS, ClassesSets.classByPredicate(xReal, Basics.comment("x ≤ 0"))));
			definition(NON_POSITIVE_REAL_NUMBERS, null, null, "Menge der nicht-positiven reellen Zahlen \u211D-", null);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}

}
