package net.sf.gluebooster.demos.pojo.math.library.probabilityTheory;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.algebra.Algebra;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.ClassesSets;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Subset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.Tuples;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of category theory
 * 
 * @author cbauer
 *
 */
public class DescriptiveStatistics extends DescriptiveStatisticsFactory {


	public static Statement POPULATION;
	public static Statement ABSOLUTE_FREQUENCY;
	public static Statement SUM_OF_ABSOLUTE_FREQUENCY;
	public static Statement RELATIVE_FREQUENCY;
	public static Statement FREQUENCY_DISTRIBUTION;

	private DescriptiveStatistics() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "descriptive statstics (1)", null, "Deskriptive Statistik (1)",
					"Ziel ist die Darstellung und Ordnung empirischer Daten.");

			POPULATION = SINGLETON.naive("POPULATION");
			POPULATION.setReferences(wikiEn("Statistical_population"), wikiDe("Grundgesamtheit"));
			definition(POPULATION, "population", null, "Grundgesamtheit",
					"Als Grundgesamtheit bezeichnet man die zu untersuchende Menge. Man spricht auch von Population, Kollektiv, Gesamterhebungsumfang oder statistischer Masse.");
			POPULATION.setExamples(Basics
					.comment(
							"Würfelwurfbeispiel:  Das betrachtete Universum U ist {1,2,3,4,5,6}. Die Elementarereignisse sind die einzelnen Zahlen. Ein Würfel wird 10 mal geworfen. Die Ergebnisse seien 4,3,6,2,6,2,1,2,2,1. Diese zehn Ergebnisse bilden die Grundgesamtheit.")
			//
			);

			ABSOLUTE_FREQUENCY = absoluteFrequency(null, null);
			ABSOLUTE_FREQUENCY.setReferences(wikiEn("Frequency_(statistics)"), wikiDe("Absolute_Häufigkeit"));
			definition(ABSOLUTE_FREQUENCY, "absolute frequency", null, "absolute Häufigkeit",
					"Die absolute Häufigkeit ist die Anzahl des Auftretens einer Merkmalsausprägung/eines (Elementar-)ereignisses. Sei x das Ereignis, n die Gesamtzahl an Beobachtungen/Elementen, so schreibt man ",
					absoluteFrequency(x, n),
					". Ist die Gesamtzahl klar oder unwichtig, kann sie als Index auch weggelassen werden. Manchmal verwendet man auch ein großgeschriebenes H und verwendet das kleine h für die relative Häufigkeit.");
			MathMLGenerator.displayRule(ABSOLUTE_FREQUENCY, WriteAfterStatementTransformation.ruleTransformation(Basics.NOT_SEPARATED,
					new Object[] { Basics.MANTISSA_INDEX_EXPONENT, "h", SECOND_VARIABLE, Basics.EMPTY }, new Object[] { Logic.BRACKET, FIRST_VARIABLE }));
			ABSOLUTE_FREQUENCY.setExamples(Basics.notSeparated("Würfelwurfbeispiel: Als Elementarereignis werden die Zahlen genommen. Es gilt n=10, "),
					Basics.commaSeparated(Logic.equals(absoluteFrequency(ONE, TEN), TWO), Logic.equals(absoluteFrequency(TWO, TEN), FOUR),
							Logic.equals(absoluteFrequency(THREE, TEN), ONE), Logic.equals(absoluteFrequency(FOUR, TEN), ONE),
							Logic.equals(absoluteFrequency(FIVE, TEN), ZERO), Logic.equals(absoluteFrequency(SIX, TEN), TWO)));

			SUM_OF_ABSOLUTE_FREQUENCY = SINGLETON.normal("SUM_OF_ABSOLUTE_FREQUENCY");
			// SUM_OF_ABSOLUTE_FREQUENCY.setReferences(References.ml1("1.5.6"));
			// SUM_OF_ABSOLUTE_FREQUENCY.setMain(Logic.equals(n, ).subclass(arbitraryIntersection(I), B));
			lemma(SUM_OF_ABSOLUTE_FREQUENCY, null, null, "Summe der absoluten Häufigkeiten ist Größe der statistischen Masse", null);

			RELATIVE_FREQUENCY = relativeFrequency(null);
			RELATIVE_FREQUENCY.setReferences(wikiEn("Frequency_(statistics)"), wikiDe("Absolute_Häufigkeit"));
			// RELATIVE_FREQUENCY.setMain(Logic.definedAs(relativeFrequency(x), absoluteFrequency(x, n)));
			definition(RELATIVE_FREQUENCY, "relative frequency", null, "relative Häufigkeit", null);
			MathMLGenerator.displayRule(RELATIVE_FREQUENCY, new WriteOperation("f(", null, ")"));
			RELATIVE_FREQUENCY.setExamples(Basics.notSeparated("Würfelwurfbeispiel: "), Basics.commaSeparated(
					Logic.equals(relativeFrequency(ONE), Basics.comment("2/10=0.2 ")), Logic.equals(relativeFrequency(TWO), Basics.comment("4/10=0.4 ")),
					Logic.equals(relativeFrequency(THREE), Basics.comment("1/10=0.1 ")), Logic.equals(relativeFrequency(FOUR), Basics.comment("1/10=0.1 ")),
					Logic.equals(relativeFrequency(FIVE), Basics.comment("0/10=0 ")), Logic.equals(relativeFrequency(SIX), Basics.comment("2/10=0.2 "))));

			FREQUENCY_DISTRIBUTION = SINGLETON.naive("FREQUENCY_DISTRIBUTION");
			FREQUENCY_DISTRIBUTION.setReferences(wikiEn("Frequency_distribution"), wikiDe("Häufigkeitsverteilung"), stat2("2.1.1"));
			definition(FREQUENCY_DISTRIBUTION, "frequency distribution", null, "Häufigkeitsverteilung",
					"Darstellung der Häufigkeiten der Merkmale. Mathematisch eine Funktion. Dargestellt meist als Tabelle (Häufigkeitstabelle) oder in Grafik (Stabdiagramm, Flächendiagramm/Histogramm, Kreisdiagramm).");

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}
	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1, Arrays.asList(POPULATION, ABSOLUTE_FREQUENCY, SUM_OF_ABSOLUTE_FREQUENCY, RELATIVE_FREQUENCY, FREQUENCY_DISTRIBUTION),
				(List) Arrays.asList());
	}

}
