package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Integers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.RationalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.RealNumbers;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of set theory concerning classes.
 * 
 * @see https://glossar.hs-augsburg.de/Klasse_(Mengenlehre)
 * 
 * @author cbauer
 *
 */
public class ClassesSets extends ClassesSetsFactory implements SetTheorySamples {

	public static final String ELEMENT = "∈";

	/**
	 * A collection of objects that can be unambiguously defined by a predicate. Naive definition.
	 */
	public static Statement CLASS;

	/**
	 * A collection of objects that can be unambiguously defined by a predicate.
	 */
	public static Statement CLASS_BY_PREDICATE;
	
	public static Statement ELEMENT_OF;

	public static Statement NOT_ELEMENT_OF;
	
	public static Statement UNIVERSE;

	public static Statement EQUAL_CLASSES;

	// public static Statement COMPLEMENT;

	public static Statement PROPER_CLASS;

	public static Statement ALL_CLASS;

	public static Statement RUSSEL_S_CLASS;

	/**
	 * explicit enumeration (maybe with gaps) like {1,2,3} or {1,2,3,...} or {1,2,3,...,10}
	 */
	public static Statement EXPLICIT_SET;

	/**
	 * A set is a class, but has more restrictions.
	 */
	public static Statement SET;

	public static Statement CLASS_OF_ALL_SETS;

	public static Statement SET_OF_SETS;

	private ClassesSets() {
	}

	static {
		try {
			titleText(SINGLETON.unit(0), "Classes/Sets (0)", null, "Klassen/Mengen (0)", null);
			titleText(SINGLETON.unit(1), "Classes/Sets (1)", null, "Klassen/Mengen (1)", null);

			Statement variable = Logic.var("var");

			CLASS = clasz(null);
			CLASS.setReferences(References.wikiEn("Class (set theory)"), References.wikiEn("Class logic"), References.wikiEn("Set-builder_notation"),
					References.wikiDe("Klasse (Mengenlehre)"),
					References.wikiDe("Klassenlogik"));
			titleText(CLASS, "Class", null, "Klasse",
					"Der Begriff 'Klasse' ist eine Verallgemeinerungen des Begriffs 'Menge'. Sei P ein Prädikat. Die dazugehörige Klasse ist die Gesamtheit aller Objekte x, für die das Prädikat wahr wird. Die Notation lautet K = {x | P(x)}. Hat man ein zweites Prädikat Q, bei dem das x betont ist, schreibt man K={Q(x)|P(x} := { x | Q(x) und P(x)}  ; Kann man die Elemente aufzählen, so schreibt man auch K={a, b, c, ...} := {x | x=a oder x=b oder x=c oder ...}");
			MathMLGenerator.displayRule(CLASS, MathMLGenerator.WRITE_NAME_OF_INSTANCE);

			CLASS_BY_PREDICATE = classByPredicate(null, variable, P);
			CLASS_BY_PREDICATE.setBe(Arrays.asList(Logic.predicate(P)));
			MathMLGenerator.displayRule(CLASS_BY_PREDICATE, new WriteOperation("{", " | ", "}"));


			ELEMENT_OF = elementOf(x, A);
			ELEMENT_OF.setReferences(References.wikiEn("Element (mathematics)"), References.wikiDe("Element (Mathematik)"));
			ELEMENT_OF.setBe(Arrays.asList(clasz(A)));
			// TODO Schreibweisen text contains element gespiegelt, is not element
			titleText(ELEMENT_OF, "Element", null, "Element", "Gehört ein Objekt x zu A, so schreibt man ", ClassesSets.elementOf(x, A),
					". Sprechweisen: 'x ist Element von A', 'x ist aus A'. ", "Gehört x nicht zu A, schreibt man ", ClassesSets.notElementOf(x, A),
					". Sprechweisen: 'x ist nicht Element von A', 'x ist nicht aus A'; ");
			MathMLGenerator.displayRule(ELEMENT_OF, new WriteOperation(ELEMENT));

			NOT_ELEMENT_OF = notElementOf(x, A);
			NOT_ELEMENT_OF.setBe(Arrays.asList(clasz(A)));
			// define as not elementOf
			MathMLGenerator.displayRule(NOT_ELEMENT_OF, new WriteOperation("∉"));

			EQUAL_CLASSES = equalClasses(A, B);
			EQUAL_CLASSES.setReferences(References.wikiEn("Axiom_of_extensionality"), References.wikiDe("Extensionalitätsprinzip"),
					References.wikiDe("Extensionalitätsaxiom"), References.ml1("1.1.1") );// missing ML KE 1 1.1.1
			EQUAL_CLASSES.setBe(Arrays.asList(clasz(A), clasz(B)));
			EQUAL_CLASSES.setMain(
					Arrays.asList(Bool.definedAsEqualTo(equalClasses(A, B), Logic.forAll(x, Bool.iff(elementOf(x, A), elementOf(x, B))))));
			titleText(EQUAL_CLASSES, "axiom of extensionality", null, "Extensionalitätsaxiom",
					"Nach dem Extensionalitätsaxiom sind zwei Klassen gleich, wenn sie die gleichen Elemente enthalten");
			MathMLGenerator.displayRule(EQUAL_CLASSES, MathMLGenerator.WRITE_OPERATION_EQUALS);
			EQUAL_CLASSES.setExamples(//
					Logic.notEquals(explicitSetWithoutName(ZERO, ONE, TWO, THREE), explicitSetWithoutName(ZERO, ONE, TWO)),
					Logic.equals(explicitSetWithoutName(ZERO, ONE, TWO), explicitSetWithoutName(ZERO, ZERO, ZERO, ONE, TWO, ONE, TWO))
			//
			);

			
			UNIVERSE = SINGLETON.naive("UNIVERSE");
			UNIVERSE.setReferences(References.wikiDe("Grundmenge"), References.wikiEn("Universe_(mathematics)"));
			titleText(UNIVERSE, "universe", null, "Universum",
					"Ein Universum (Grundmenge) ist eine Klasse, die alle Objekte enthält, die im aktuellen Kontext benötigt werden. Es kann eine echte Klasse oder auch 'nur' eine Menge sein.");


			// Need Universe and a subset of Universe
			// COMPLEMENT = complement(A);// TODO maybe use universe
			// COMPLEMENT.setReferences(References.wikiEn("Complement_(set_theory)"), References.wikiDe("Komplement_(Mengenlehre)"));
			// COMPLEMENT.setBe(Arrays.asList(clasz(A)));
			// COMPLEMENT.setMain(Arrays.asList(Boolean.definedBy(complement(A), classByPredicate(null, x, isNotElementOf(x, A)))));
			// titleText(COMPLEMENT, "Complement (absolute complement)", null, "Komplement (absolutes Komplement)", null);

			ALL_CLASS = SINGLETON.naive("allClass");
			ALL_CLASS.setReferences(References.wikiDe("Allklasse"));
			titleText(ALL_CLASS, null, null, "Allklasse", "Die Klasse, die alle Objekte enthält.",
					classByPredicate(null, A, Logic.equals(A, A)));

			RUSSEL_S_CLASS = SINGLETON.naive("russelsClass");
			RUSSEL_S_CLASS.setReferences(References.wikiEn("Russell's_paradox"), References.wikiDe("Russellsche_Antinomie"));
			titleText(RUSSEL_S_CLASS, "Russels's class", null, "Russellsche Klasse", "Die Klasse aller Klassen, die sich nicht selbst als Element enthalten. ",
					classByPredicate(null, clasz(A), notElementOf(A, A)));

			SET = set(null);
			SET.be(ClassesSets.clasz(A));
			// SET.setMain(Boolean.implies(set(A), Classes.clasz(A)));
			SET.setReferences(References.wikiEn("Set (mathematics)"), References.wikiDe("Menge (Mathematik)"));
			titleText(SET, "Set", null, "Menge",
					"Eine Menge A ist eine Klasse A für die zusätzliche Einschränkungen gelten. Das genau Konzept variiert je nach der verwendeten Mengenlehre. Mengen können Elemente von Klassen oder anderen Mengen sein.");
			MathMLGenerator.displayRule(SET, MathMLGenerator.WRITE_NAME_OF_INSTANCE);
			SET.setExamples(//
					Basics.comment(
							"Die Menge Ω der möglichen Ausgänge eines Zufallsexperiments (Ausgangsraum, Merkmalraum, Stichprobenraum) in der Statistik/Wahrscheinlichkeitstheorie. Ihre Elemente bezeichnet man als Elementarereignisse. "), //
					Basics.comment(
							"Eine Menge kann andere Mengen als Elemente besitzen. Solche Mengen nennt man auch (Mengen-)Systeme. (Manchmal wird vorausgesetzt, dass die leere Menge in dem System enthalten sein muss.)"),
					RealNumbers.NON_POSITIVE_REAL_NUMBERS, RealNumbers.NON_NEGATIVE_REAL_NUMBERS

			//
			);

			EXPLICIT_SET = explicitSet(null);
			MathMLGenerator.displayRule(EXPLICIT_SET, new WriteOperation("{", ", ", "}"));

			CLASS_OF_ALL_SETS = SINGLETON.naive("CLASS_OF_ALL_SETS");
			CLASS_OF_ALL_SETS.setReferences(References.wikiDe("Allklasse"));
			CLASS_OF_ALL_SETS.setMain(Logic.definedAs(CLASS_OF_ALL_SETS, classByPredicate(CLASS_OF_ALL_SETS, A, setAextended)));
			titleText(CLASS_OF_ALL_SETS, null, null, "Klasse aller Mengen", null);
			MathMLGenerator.displayRule(CLASS_OF_ALL_SETS, WriteOperation.prefix("ℳℯ"));

			PROPER_CLASS = properClass(null);
			PROPER_CLASS.setReferences(References.wikiEn("Class (set theory)"), References.wikiDe("Klasse (Mengenlehre)"));
			titleText(PROPER_CLASS, "Proper Class", null, "Echte Klasse",
					"Echte Klassen sind Klassen, die keine Mengen sind.");
			PROPER_CLASS.setExamples(//
					ALL_CLASS, CLASS_OF_ALL_SETS.cloneWithDisplayIdentifyingName(), //
					Basics.comment("Die Klasse aller einelementigen Mengen")
			//
			);

			SET_OF_SETS = setOfSets(null);
			definition(SET_OF_SETS, null, null, "Menge von Mengen", "Mengen können andere Mengen als Elemente enthalten.");

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


	/**
	 * Add all infos that can be done in the static initializer because of recursions in the class invokation.
	 */
	public static void initialize() {
		SET.setExamplesOnlyName(Bool.BOOLEAN_SET, NaturalNumbers.SET_OF_NATURAL_NUMBERS_INFORMAL, Integers.SET_OF_INTEGERS_INFORMAL,
				RationalNumbers.SET_OF_RATIONAL_NUMBERS_INFORMAL, RealNumbers.SET_OF_REAL_NUMBERS_INFORMAL);

	}

	public static StudyUnit createStudyUnit0() {
		initialize();
		return new StudyUnit(SINGLETON, 0, Arrays.asList(CLASS, ELEMENT_OF, UNIVERSE), Arrays.asList(EXPLICIT_SET));
	}

	public static StudyUnit createStudyUnit1() {
		initialize();
		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(EQUAL_CLASSES, ALL_CLASS, RUSSEL_S_CLASS, SET, CLASS_OF_ALL_SETS, PROPER_CLASS),
				(List) Arrays.asList(SET_OF_SETS, CLASS_BY_PREDICATE, NOT_ELEMENT_OF, RealNumbers.NON_NEGATIVE_REAL_NUMBERS,
						RealNumbers.NON_POSITIVE_REAL_NUMBERS, RealNumbers.SET_OF_REAL_NUMBERS));
	}




}
