package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.Integers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.NaturalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.RationalNumbers;
import net.sf.gluebooster.demos.pojo.math.library.numberTheory.RealNumbers;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ContainerBoostUtils;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of set theory concerning classes.
 * 
 * @see https://glossar.hs-augsburg.de/Klasse_(Mengenlehre)
 * 
 * @author cbauer
 *
 */
public class ClassesSetsFactory extends Statements {

	protected static final ClassesSetsFactory SINGLETON = new ClassesSetsFactory();


	protected ClassesSetsFactory() {
		super("classes_sets", SetTheory.SINGLETON);
	}


	public static Statement setOfSets(Statement set) {
		return SINGLETON.normal("setofsets", set);
	}

	public static Statement clasz(Statement classname) {
		Statement result = SINGLETON.naive("class");
		result.setNameOfInstance(classname);
		result.setDisplayIdentifyingNameInPrecondition(true);
		return result;
	}

	public static Statement properClass(Statement classname) {
		Statement result = SINGLETON.naive("properClass");
		result.setNameOfInstance(classname);
		result.setDisplayIdentifyingNameInPrecondition(true);
		return result;
	}

	public static Statement classByPredicate(Statement classname, Statement variable, Statement predicate) {
		Statement result = SINGLETON.naive("classByPredicate", Arrays.asList(variable, predicate));
		result.setNameOfInstance(classname);
		return result;

	}

	public static Statement classByPredicate(Statement variable, Statement predicate) {
		return classByPredicate(null, variable, predicate);

	}

	public static Statement elementOf(Statement object, Statement clasz) {
		return SINGLETON.normal("isElementOf", Arrays.asList(object, clasz));
	}

	public static Statement notElementOf(Statement object, Statement clasz) {
		return SINGLETON.normal("isNotElementOf", Arrays.asList(object, clasz));
	}

	public static Statement equalClasses(Statement class1, Statement class2) {
		return SINGLETON.normal("equalClasses", Arrays.asList(class1, class2));
	}



	public static Statement complement(Statement class1) {
		return SINGLETON.normal("complement", Arrays.asList(class1));
	}

	public static Statement set(Statement nameOfSet) {
		Statement result = SINGLETON.naive("set");
		result.setNameOfInstance(nameOfSet);
		result.setDisplayIdentifyingNameInPrecondition(true);
		return result;
	}

	/**
	 * A set by enumeration its members
	 * 
	 * @param nameOfSet
	 * @param elementsOrMore
	 *            Basics.MORE is allowed at any position.
	 * @return
	 */
	public static Statement explicitSet(Statement nameOfSet, List<Statement> elementsOrMore) {
		Statement result = SINGLETON.naive("explicitSet", elementsOrMore);
		result.setNameOfInstance(nameOfSet);
		return result;
	}

	public static Statement explicitSet(Statement nameOfSet, Statement... elementsOrMore) {
		return explicitSet(nameOfSet, Arrays.asList(elementsOrMore));
	}

	public static Statement explicitSetWithoutName(Statement... elementsOrMore) {
		return explicitSet(null, elementsOrMore);
	}





}
