package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.BasicsFactory;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProduct;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.InverseRelation;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinaryFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationFactory;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class EmptySet extends EmptySetFactory {

	public static Statement EMPTY_SET_IS_SUBCLASS;
	public static Statement SUBSET_OF_EMPTY_SET;
	public static Statement VACUOUS_TRUTH;
	public static Statement EXISTENTIAL_FALLACY;
	public static Statement NOT_EMPTY_SET;
	public static Statement INVERSE_OF_EMPTY_SET_IS_EMPTY_SET;
	public static Statement EMPTY_SET_IS_BINARY_RELATION;
	public static Statement EMPTY_SET_IS_LEFT_UNIQUE;
	public static Statement EMPTY_SET_IS_RIGHT_UNIQUE;
	public static Statement EMPTY_SET_IS_1_TO_1;

	private EmptySet() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "Empty Set", null, "Die leere Menge", null);


			titleText(SINGLETON.unit(1), "Empty Set (1)", null, "Die leere Menge (1)", null);


			EMPTY_SET.setReferences(References.wikiDe("Leere_Menge"), References.wikiEn("Empty_set"), References.wikiEn("Inhabited_set"),
					References.ml1("1.3.1"));
			EMPTY_SET.setMain(Logic.definedAs(EMPTY_SET, ClassesSets.classByPredicate(null, x, Logic.notEquals(x, x))));
			definition(EMPTY_SET, "Empty set", null, "Leere Menge",
					"Die Leere Menge ist die Menge, die kein Element enthält. Ist eine Menge ungleich der leeren Menge, spricht man von einer nichtleeren Menge. Da für jedes Objekt x gilt: x = x, gilt somit für alle x: ",
					ClassesSets.notElementOf(x, EMPTY_SET), ".");
			// EMPTY_SET.setMain(Boolean.definedBy(EMPTY_SET, Classes.classByPredicate(null, x, Logic.notEquals(x, EMPTY_SET))));{m:m≠m}
			WriteOperation writer = WriteOperation.prefix("\u2205");
			writer.setBreakpoint();
			MathMLGenerator.displayRule(EMPTY_SET, writer);

			NOT_EMPTY_SET = notEmptySet(null);
			titleText(NOT_EMPTY_SET, null, null, "nichtleer", null);


			VACUOUS_TRUTH = SINGLETON.naive("Vacuous truth");
			VACUOUS_TRUTH.setReferences(References.wikiEn("Vacuous truth"));
			Statement Px = Logic.predicate(P, x);
			lemma(VACUOUS_TRUTH, "Vacuous truth", null, "All-Aussagen über Elemente der leeren Menge", "Sei ", Px,
					" eine Aussage (über x). Jede Aussage der Form ", Logic.forAll(ClassesSets.elementOf(x, EMPTY_SET), Px), " ist WAHR. ");
			VACUOUS_TRUTH.setProofs(Bool.biconditionalMultiline(//
					Logic.forAll(ClassesSets.elementOf(x, EMPTY_SET), Px), //
					Logic.forAll(x, Bool.implies(ClassesSets.elementOf(x, EMPTY_SET), Px)), //
					Logic.forAll(x, Bool.implies(Bool.FALSUM, Px)), //
					Logic.forAll(x, Bool.VERUM), Bool.VERUM));
			MathMLGenerator.displayRule(VACUOUS_TRUTH, MathMLGenerator.WRITE_NAME_OF_DEFINITION);

			EXISTENTIAL_FALLACY = SINGLETON.naive("existential fallacy");
			EXISTENTIAL_FALLACY.setReferences(References.wikiEn("Existential_fallacy"));
			lemma(EXISTENTIAL_FALLACY, "Existential fallacy", null, "Existenz-Aussagen über Elemente der leeren Menge", "Sei ", Px,
					" eine Aussage (über x). Jede Aussage der Form ", Logic.exists(ClassesSets.elementOf(x, EMPTY_SET), Px), " ist FALSCH");
			EXISTENTIAL_FALLACY.setProofs(Logic.proofByContradiction(Bool.impliesMultiline(//
					Logic.exists(ClassesSets.elementOf(x, EMPTY_SET), Px), //
					Logic.exists(x, ClassesSets.elementOf(x, EMPTY_SET)), //
					Logic.exists(x, Logic.notEquals(x, x)), //
					Basics.CONTRADICTION)));

			EMPTY_SET_IS_SUBCLASS = SINGLETON.normal("empty set is subclass of all cleasses");
			EMPTY_SET_IS_SUBCLASS.setReferences(References.wikiDe("Leere_Menge"), References.wikiEn("Empty_set"), References.ml1("1.3.2"));
			lemma(EMPTY_SET_IS_SUBCLASS, null, null, "Die Leere Menge ist Teilklasse aller Klassen", null);
			EMPTY_SET_IS_SUBCLASS.be(ClassesSets.clasz(A));
			EMPTY_SET_IS_SUBCLASS.setMain(Subset.subclass(EMPTY_SET, A));
			EMPTY_SET_IS_SUBCLASS.setProofs(Bool.biconditionalMultiline(//
					Subset.subclass(EMPTY_SET, A), //
					Logic.forAll(ClassesSets.elementOf(x, EMPTY_SET), ClassesSets.elementOf(x, A)), Basics.proofline(Basics.TRIVIAL, VACUOUS_TRUTH)));


			SUBSET_OF_EMPTY_SET = SINGLETON.normal("subset of empty set");
			SUBSET_OF_EMPTY_SET.setReferences(References.wikiDe("Leere_Menge"), References.wikiEn("Empty_set"), References.ml1("1.3.4"));
			lemma(SUBSET_OF_EMPTY_SET, null, null, "Teilklasse der Leeren Menge ist Leere Menge", null);
			SUBSET_OF_EMPTY_SET.be(ClassesSets.clasz(A));
			SUBSET_OF_EMPTY_SET.setMain(Bool.implies(Subset.subclass(A, EMPTY_SET), Logic.equals(A, EMPTY_SET)));
			SUBSET_OF_EMPTY_SET.setProofs(
					Bool.impliesMultiline(Bool.and(Subset.subclass(A, EMPTY_SET), Basics.proofline(Subset.subclass(EMPTY_SET, A), EMPTY_SET_IS_SUBCLASS)),
							Basics.proofline(Logic.equals(A, EMPTY_SET),
									Subset.ANTISYMMETRIC)));


			INVERSE_OF_EMPTY_SET_IS_EMPTY_SET = SINGLETON.normal("INVERSE_OF_EMPTY_SET_IS_EMPTY_SET");
			INVERSE_OF_EMPTY_SET_IS_EMPTY_SET.setReferences(References.ml1("2.3.3"));
			INVERSE_OF_EMPTY_SET_IS_EMPTY_SET.main(Logic.equals(InverseRelation.inverse(EMPTY_SET), EMPTY_SET));
			lemma(INVERSE_OF_EMPTY_SET_IS_EMPTY_SET, null, null, "inverse Relation der leeren Menge ist wieder die leere Menge", null);
			INVERSE_OF_EMPTY_SET_IS_EMPTY_SET.setProofs(Basics.proofline(Logic.equals(//
					InverseRelation.inverse(EMPTY_SET), //
					ClassesSets.classByPredicate(b_a, ClassesSets.elementOf(a_b, EMPTY_SET)), //
					EMPTY_SET
			//
			), Basics.comment("denn die leere Menge enthält keine Elemente")));

			EMPTY_SET_IS_BINARY_RELATION = SINGLETON.normal("EMPTY_SET_IS_BINARY_RELATION");
			// EMPTY_SET_IS_BINARY_RELATION.setReferences(References.ml1("2.4.7"));
			// EMPTY_SET_IS_BINARY_RELATION.main(RelationFactory.binary(EMPTY_SET));
			lemma(EMPTY_SET_IS_BINARY_RELATION, null, null, "Die leere Menge ist zweistellige Relation", EMPTY_SET, " ist zweistellige Relation.");
			EMPTY_SET_IS_BINARY_RELATION.setProofs(Basics.multiline(//
					Basics.comment("Seien A und B zwei beliebige Mengen."), //
					Basics.proofline(Subset.subclass(EMPTY_SET, CartesianProduct.AcrossB), EMPTY_SET_IS_SUBCLASS)//
			));

			EMPTY_SET_IS_RIGHT_UNIQUE = SINGLETON.normal("EMPTY_SET_IS_RIGHT_UNIQUE");
			EMPTY_SET_IS_RIGHT_UNIQUE.setReferences(References.ml1("2.4.7"));
			EMPTY_SET_IS_RIGHT_UNIQUE.main(RelationBinaryFactory.rightUnique(EMPTY_SET));
			lemma(EMPTY_SET_IS_RIGHT_UNIQUE, null, null, "Die leere Menge ist rechtseindeutige zweistellige Relation", null);
			EMPTY_SET_IS_RIGHT_UNIQUE
					.setProofs(
							Bool.impliesMultiline(Basics.comment("Seien die Klassen A, B beliebig"), //
									Basics.proofline(//
											Logic.forAll(
													ClassesSets.elementOf(a, A),
													Logic.forAll(
															ClassesSets
																	.elementOf(Basics.commaSeparated(b_1, b_2),
																			B),
															Bool.implies(Logic.equals(
																	Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a, b_1), EMPTY_SET),
																			ClassesSets.elementOf(Tuples.tuple(a, b_2), EMPTY_SET)),
																	Bool.and(Bool.FALSUM, Bool.FALSUM), Bool.FALSUM), Logic.equals(b_1, b_2)))),
											BasicsFactory.comment("Da man aus einer falschen Aussage alles folgern kann"))));

			EMPTY_SET_IS_LEFT_UNIQUE = SINGLETON.normal("EMPTY_SET_IS_LEFT_UNIQUE");
			// EMPTY_SET_IS_LEFT_UNIQUE.setReferences(References.ml1("2.4.7"));
			EMPTY_SET_IS_LEFT_UNIQUE.main(RelationBinaryFactory.leftUnique(EMPTY_SET));
			lemma(EMPTY_SET_IS_LEFT_UNIQUE, null, null, "Die leere Menge ist linkseindeutige zweistellige Relation", null);
			EMPTY_SET_IS_LEFT_UNIQUE
					.setProofs(//
							Bool.impliesMultiline(Basics.comment("Seien die Klassen A, B beliebig"), //
									Basics.proofline(//
											Logic.forAll(
													ClassesSets
															.elementOf(b,
																	B),
													Logic.forAll(
															ClassesSets
																	.elementOf(Basics.commaSeparated(a_1, a_2),
																			A),
															Bool.implies(Logic.equals(
																	Bool.andWithBrackets(ClassesSets.elementOf(Tuples.tuple(a_1, b), EMPTY_SET),
																			ClassesSets.elementOf(Tuples.tuple(a_2, b), EMPTY_SET)),
																	Bool.and(Bool.FALSUM, Bool.FALSUM), Bool.FALSUM), Logic.equals(a_1, a_2)))),
											BasicsFactory.comment("Da man aus einer falschen Aussage alles folgern kann"))));

			EMPTY_SET_IS_1_TO_1 = SINGLETON.normal("EMPTY_SET_IS_1_TO_1");
			// EMPTY_SET_IS_1_TO_1.setReferences(References.ml1("2.4.7"));
			EMPTY_SET_IS_1_TO_1.main(RelationBinaryFactory.one2one(EMPTY_SET));
			lemma(EMPTY_SET_IS_1_TO_1, null, null, "Die leere Menge ist eineindeutige zweistellige Relation", null);
			EMPTY_SET_IS_1_TO_1.setProofs(Basics.comment("Trivial, da bereits bewiesen wurde, dass die Leere Menge linkseindeutig und rechtseindeutig ist."));

			endOfInitialization();
		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}

	/**
	 * Additional initialization that should (because of circles in the static class loading) be done at the end of the initialization.
	 * 
	 * @throws Exception
	 */
	private static void endOfInitialization() throws Exception {

	}



	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(EMPTY_SET, VACUOUS_TRUTH, EXISTENTIAL_FALLACY, EMPTY_SET_IS_SUBCLASS, SUBSET_OF_EMPTY_SET),
				Arrays.asList(NOT_EMPTY_SET));
	}

}
