package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class EmptySetFactory extends Statements {

	protected static final EmptySetFactory SINGLETON = new EmptySetFactory();

	public static Statement EMPTY_SET = SINGLETON.normal("EMPTY_SET");

	protected EmptySetFactory() {
		super("empty_set", SetTheory.SINGLETON);
	}


	public static Statement notEmptySet(Statement clasz) {
		return SINGLETON.normal("notEmptySet", clasz);
	}

	public static Statement isEmpty(Statement clasz) {
		return Logic.equals(clasz, EMPTY_SET);
	}

}
