package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.ConstantFunction;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.functions.Mappings;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProduct;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Composition;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class SetMappings extends SetMappingsFactory implements SetTheorySamples {

	private static final String ME = "ℳℯ";

	public static Statement MAPPINGS_FROM_TO;

	public static Statement SET_MAPPINGS;

	public static Statement MAPPINGS_TO_ONE_ELEMENT_SET;

	public static Statement MAPPINGS_FROM_EMPTY_SET;

	public static Statement MAPPINGS_FROM_TO_EMPTY;

	public static Statement COMPOSITION;

	public static Statement CATEGORY;



	private SetMappings() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), null, null, "Mengenabbildungen", null);
			titleText(SINGLETON.unit(1), null, null, "Mengenabbildungen", null);

			SET_MAPPINGS = SINGLETON.normal("SET_MAPPINGS");
			SET_MAPPINGS.setMain(Logic.definedAs(SET_MAPPINGS,
					ClassesSets.classByPredicate(Basics.blankSeparated("Abbildung", Mappings.mapping(f, A, null, B)), Basics.comment("A, B Mengen"))));
			definition(SET_MAPPINGS, null, null, "Klasse aller Mengenabbildungen", null);
			MathMLGenerator.displayRule(SET_MAPPINGS, WriteOperation.prefix(ME + "-Abb"));

			MAPPINGS_FROM_TO = mappings(null, null);
			MAPPINGS_FROM_TO.be(setA, setB);
			MAPPINGS_FROM_TO.setMain(
					Logic.definedAs(mappings(A, B), ClassesSets.classByPredicate(f, Basics.blankSeparated(Mappings.mapping(f, A, null, B), "Abbildung"))));
			definition(MAPPINGS_FROM_TO, null, null, "Mengenabbildungen zwischen zwei gegebenen Mengen", null);
			MathMLGenerator.displayRule(MAPPINGS_FROM_TO, new WriteOperation("Abb(", ",", ")"));

			MAPPINGS_TO_ONE_ELEMENT_SET = SINGLETON.normal("MAPPINGS_TO_ONE_ELEMENT_SET");
			MAPPINGS_TO_ONE_ELEMENT_SET.be(Basics.comment("c ein beliebiges Objekt"), setA);
			MAPPINGS_TO_ONE_ELEMENT_SET.setReferences(ml2("2.6.15"));
			Statement cSet = ClassesSets.explicitSetWithoutName(c);
			Statement constantMapping = ConstantFunction.constantMapping(A, cSet, c).setDisplayLevel(SHORT);
			MAPPINGS_TO_ONE_ELEMENT_SET
					.setMain(Logic.equals(mappings(A, cSet),
							ClassesSets.explicitSetWithoutName(constantMapping)));
			definition(MAPPINGS_TO_ONE_ELEMENT_SET, null, null, "Mengenabbildungen in einelementige Menge", null);
			MAPPINGS_TO_ONE_ELEMENT_SET.setProofs(Subset.equalsBySubclasses(//
					Bool.impliesMultiline(
							ClassesSets.elementOf(f, mappings(A, cSet)), //
							Mappings.mapping(f, A, cSet, x, f_of_x), //
							Logic.forAll(xElemA, ClassesSets.elementOf(f_of_x, cSet)), //		
							Logic.forAll(xElemA, Logic.equals(f_of_x, c)), //
							Logic.equals(f, constantMapping)
							//
					), //
					Basics.proofline(Basics.TRIVIAL, Basics.comment("laut Definition von k")) //
					));

			MAPPINGS_FROM_EMPTY_SET = SINGLETON.normal("MAPPINGS_FROM_EMPTY_SET");
			MAPPINGS_FROM_EMPTY_SET.be(setB);
			MAPPINGS_FROM_EMPTY_SET.setReferences(ml2("2.6.15"));
			Statement right = ClassesSets.explicitSetWithoutName(/* Mappings.mappingsTuple */Tuples.tuple(EmptySet.EMPTY_SET, EmptySet.EMPTY_SET, B));
			MAPPINGS_FROM_EMPTY_SET.setMain(Logic.equals(mappings(EmptySet.EMPTY_SET, B), right));
			definition(MAPPINGS_FROM_EMPTY_SET, null, null, "Mengenabbildungen von leerer Menge", null);
			MAPPINGS_FROM_EMPTY_SET.setProofs(Logic.equalsMultiline(//
					mappings(EmptySet.EMPTY_SET, B), //
					ClassesSets.classByPredicate(Tuples.tuple(EmptySet.EMPTY_SET, F, B),
							Bool.and(RelationBinary.function(F), Subset.subclass(F, CartesianProduct.binary(EmptySet.EMPTY_SET, B)))), //
					ClassesSets.classByPredicate(Tuples.tuple(EmptySet.EMPTY_SET, F, B),
							Bool.and(RelationBinary.function(F), Subset.subclass(F, EmptySet.EMPTY_SET))), //
					ClassesSets.classByPredicate(Tuples.tuple(EmptySet.EMPTY_SET, F, B),
							Bool.and(RelationBinary.function(F), Logic.equals(F, EmptySet.EMPTY_SET))), //
					ClassesSets.classByPredicate(Tuples.tuple(EmptySet.EMPTY_SET, F, B), Logic.equals(F, EmptySet.EMPTY_SET)), //
					right)//
			//
			);

			MAPPINGS_FROM_TO_EMPTY = SINGLETON.normal("MAPPINGS_FROM_TO_EMPTY");
			MAPPINGS_FROM_TO_EMPTY.be(setA, setB);
			MAPPINGS_FROM_TO_EMPTY.setReferences(ml2("2.6.15"));
			MAPPINGS_FROM_TO_EMPTY.setMain(Bool.iff(Logic.equals(mappings(A, B), EmptySet.EMPTY_SET), Bool.and(EmptySet.notEmptySet(A), EmptySet.isEmpty(B))));
			definition(MAPPINGS_FROM_TO_EMPTY, null, null, "Wann sind Mengenabbildungen leere Menge", null);
			MAPPINGS_FROM_TO_EMPTY.setProofs(//
					Basics.MISSING_PROOF
			//
			);

			COMPOSITION = SINGLETON.normal("COMPOSITION");
			definition(COMPOSITION, null, null, "Komposition als Operation auf Mengenabbildungen",
					"Die Komposition von Mengenabbildungen ist selbst eine partielle binäre Operation ",
					Mappings.partialBinaryOperation(Basics.comment("∘"), SET_MAPPINGS,
							Mappings.elementMappedTo(Tuples.tuple(f, g), Composition.composite(f, g))).setDisplayLevel(EXTENDED),
					" falls die Komposition von f und g möglich ist, ansonsten ist die Abbildung an dieser Stelle nicht definiert.");

			CATEGORY = SINGLETON.normal("CATEGORY");
			definition(CATEGORY, null, null, "Kategorie der Mengen(abbildungen)",
					"Die Klasse der Mengenabbildungen zusammen mit deren Komposition bildet die Kategorie der Mengen(abbildungen) bezeichnet als Set, Ens oder ",
					ME);
			MathMLGenerator.displayRule(CATEGORY, WriteOperation.prefix("Set"));
			CATEGORY.setProofs(Basics.MISSING_PROOF);

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


	
	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				(List) Arrays.asList(), (List) Arrays.asList());
	}

}
