package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Difference;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Intersection;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Union;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class SetOperations extends SetOperationsFactory {


	public static Statement UNION_INTERSECTION_DISTRIBUTIVE;
	public static Statement INTERSECTION_UNION_DISTRIBUTIVE;

	public static Statement FIRST_DIFFERENCE_THEN_INTERSECTION_IS_EMPTY;
	public static Statement FIRST_DIFFERENCE_THEN_UNION_IS_UNION;
	public static Statement DIFFERENCE_OF_INTERSECTION_IS_UNION;
	public static Statement DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE;
	public static Statement DIFFERENCE_OF_UNION_IS_INTERSECTION;
	public static Statement FIRST_UNION_THEN_DIFFERENCE_IS_UNION;
	public static Statement FIRST_UNION_THEN_DIFFERENCE_OF_SAME;
	public static Statement FIRST_INTERSECTION_THEN_DIFFERENCE_IS_INTERSECTION;
	public static Statement DIFFERENCE_OF_DIFFERENCE_IS_UNION;
	public static Statement DIFFERENCE_WITH_DIFFERENCE_OF_SAME_IS_INTERSECTION;
	public static Statement DIFFERENCE_FROM_DIFFERENCE;
	public static Statement INTERSECTION_EMPTY_IMPLIES_DIFFERENCE_IS_CLASS;
	public static Statement CLASSES_EQUAL_IFF_INTERSECTIONS_EQUAL;
	public static Statement INTERSECTION_AND_DIFFERENCE;
	public static Statement UNION_AND_DIFFERENCE;
	public static Statement DIFFERENCE_UNION_INTERSECTION_IS_FIRST;
	public static Statement SUBSET_EQUIVALENCES;
	public static Statement EQUIVALENCES;

	public static Statement UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE;
	public static Statement UNION_ARBITRARY_INTERSECTIONS;
	public static Statement INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE;
	public static Statement INTERSECTION_ARBITRARY_UNIONS;
	public static Statement DIFFERENCE_OF_INTERSECTIONS_IS_UNION;
	public static Statement DIFFERENCE_OF_UNIONS_IS_INTERSECTION;
	public static Statement UNION_IS_SYMMETRIC_DIFFERENCE_AND_INTERSECTION;
	public static Statement PARTITION_OF_SUBSET;


	private SetOperations() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), null, null, "Lemmata über Operationen auf Klassen ", null);


			titleText(SINGLETON.unit(1), null, null, "Lemmata über Operationen auf Klassen (1)", null);


			UNION_INTERSECTION_DISTRIBUTIVE = SINGLETON.normal("UNION_INTERSECTION_DISTRIBUTIVE");
			UNION_INTERSECTION_DISTRIBUTIVE.be(classA, classB, classC);
			UNION_INTERSECTION_DISTRIBUTIVE
					.setMain(Logic.equals(Union.union(A, Logic.bracket(BinterC)), Intersection.intersection(Logic.bracket(AunionB), Logic.bracket(AunionC))));
			lemma(UNION_INTERSECTION_DISTRIBUTIVE, null, null, "Distributivgesetz Vereinigung-Schnitt", null);
			UNION_INTERSECTION_DISTRIBUTIVE.setProofs(//
					Bool.iffMultiline(
							ClassesSets.elementOf(x, Union.union(A, Logic.bracket(BinterC))), //
							Bool.or(xElemA, ClassesSets.elementOf(x, BinterC)), //
							Bool.or(xElemA, Logic.bracket(Bool.and(xElemB, xElemC))), //
							Basics.proofline(Bool.andWithBrackets(Bool.or(xElemA, xElemB), Bool.or(xElemA, xElemC)), Bool.DISTRIBUTIVE_2), //
							Bool.and(ClassesSets.elementOf(x, AunionB), ClassesSets.elementOf(x, AunionC)), //
							ClassesSets.elementOf(x, Intersection.intersection(Logic.bracket(AunionB), Logic.bracket(AunionC)))));

			INTERSECTION_UNION_DISTRIBUTIVE = SINGLETON.normal("INTERSECTION_UNION_DISTRIBUTIVE");
			INTERSECTION_UNION_DISTRIBUTIVE.be(classA, classB, classC);
			INTERSECTION_UNION_DISTRIBUTIVE.setMain(Logic.equals(Intersection.intersection(A, Logic.bracket(Union.union(B, C))),
					Union.union(Logic.bracket(Intersection.intersection(A, B)), Logic.bracket(Intersection.intersection(A, C)))));
			lemma(INTERSECTION_UNION_DISTRIBUTIVE, null, null, "Distributivgesetz Schnitt-Vereinigung", null);
			INTERSECTION_UNION_DISTRIBUTIVE.setProofs(//
					Bool.iffMultiline(ClassesSets.elementOf(x, Intersection.intersection(A, Logic.bracket(BunionC))), //
							Bool.and(xElemA, ClassesSets.elementOf(x, BunionC)), //
							Bool.and(xElemA, Logic.bracket(Bool.or(xElemB, xElemC))), //
							Basics.proofline(Bool.orWithBrackets(Bool.and(xElemA, xElemB), Bool.and(xElemA, xElemC)), Bool.DISTRIBUTIVE_1), //
							Bool.or(ClassesSets.elementOf(x, AinterB), ClassesSets.elementOf(x, AinterC)), //
							ClassesSets.elementOf(x, Union.union(Logic.bracket(AinterB), Logic.bracket(AinterC)))));

			FIRST_DIFFERENCE_THEN_INTERSECTION_IS_EMPTY = SINGLETON.normal("FIRST_DIFFERENCE_THEN_INTERSECTION_IS_EMPTY");
			FIRST_DIFFERENCE_THEN_INTERSECTION_IS_EMPTY.be(classA, classB);
			Statement left = Intersection.intersection(Logic.bracket(AminusB), B);
			FIRST_DIFFERENCE_THEN_INTERSECTION_IS_EMPTY
					.setMain(Logic.equals(left, EmptySet.EMPTY_SET));
			lemma(FIRST_DIFFERENCE_THEN_INTERSECTION_IS_EMPTY, null, null, "Schnitt nach Differenz wird leer", null);
			FIRST_DIFFERENCE_THEN_INTERSECTION_IS_EMPTY.setProofs(Logic.equalsMultiline(//
					left, //
					ClassesSets.classByPredicate(null, x, ClassesSets.elementOf(x, left)), //
					ClassesSets.classByPredicate(null, x, Bool.and(ClassesSets.elementOf(x, AminusB), xElemB)), //
					ClassesSets.classByPredicate(null, x, Bool.and(Logic.bracket(Bool.and(xElemA, xNotElemB)), xElemB)), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Logic.bracket(Bool.and(xNotElemB, xElemB)))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Bool.FALSUM)), //
					ClassesSets.classByPredicate(null, x, Bool.FALSUM), //
					EmptySet.EMPTY_SET
			//
			));


			FIRST_DIFFERENCE_THEN_UNION_IS_UNION = SINGLETON.normal("FIRST_DIFFERENCE_THEN_UNION_IS_UNION");
			FIRST_DIFFERENCE_THEN_UNION_IS_UNION.be(classA, classB);
			left = Union.union(Logic.bracket(AminusB), B);
			FIRST_DIFFERENCE_THEN_UNION_IS_UNION.setMain(Logic.equals(left, AunionB));
			lemma(FIRST_DIFFERENCE_THEN_UNION_IS_UNION, null, null, "Vereinigung nach Differenz wird Vereinigung", null);
			FIRST_DIFFERENCE_THEN_UNION_IS_UNION.setProofs(Logic.equalsMultiline(//
					left, //
					ClassesSets.classByPredicate(null, x, ClassesSets.elementOf(x, left)), //
					ClassesSets.classByPredicate(null, x, Bool.or(ClassesSets.elementOf(x, AminusB), xElemB)), //
					ClassesSets.classByPredicate(null, x, Bool.or(Logic.bracket(Bool.and(xElemA, xNotElemB)), xElemB)), //
					ClassesSets.classByPredicate(null, x, Bool.andWithBrackets(xElemAorB, Bool.or(xNotElemB, xElemB))), //
					ClassesSets.classByPredicate(null, x, Bool.and(Logic.bracket(xElemAorB), Bool.VERUM)), //
					ClassesSets.classByPredicate(null, x, xElemAorB), //
					AunionB
			//
			));
			
						
			DIFFERENCE_OF_INTERSECTION_IS_UNION = SINGLETON.normal("DIFFERENCE_OF_INTERSECTION_IS_UNION");
			DIFFERENCE_OF_INTERSECTION_IS_UNION.be(classA, classB);
			left = Difference.difference(A, Logic.bracket(BinterC));
			Statement right = Union.union(AminusB, AminusC);
			DIFFERENCE_OF_INTERSECTION_IS_UNION.setMain(Logic.equals(left, right));
			lemma(DIFFERENCE_OF_INTERSECTION_IS_UNION, null, null, "Differenz von Schnitt ist Vereinigung der Differenzen", null);
			DIFFERENCE_OF_INTERSECTION_IS_UNION.setProofs(Logic.equalsMultiline(//
					right, //
					ClassesSets.classByPredicate(null, x, ClassesSets.elementOf(x, right)), //
					ClassesSets.classByPredicate(null, x, Bool.or(ClassesSets.elementOf(x, AminusB), ClassesSets.elementOf(x, AminusC))), //
					ClassesSets.classByPredicate(null, x, Bool.orWithBrackets(Bool.and(xElemA, xNotElemB), Bool.and(xElemA, xNotElemC))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Logic.bracket(Bool.or(xNotElemB, xNotElemC)))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Logic.bracket(Bool.or(Bool.not(xElemB), Bool.not(xElemC))))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Bool.not(Logic.bracket(Bool.and(xElemB, xElemC))))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Bool.not(Logic.bracket(ClassesSets.elementOf(x, BinterC))))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, ClassesSets.notElementOf(x, BinterC))), //
					ClassesSets.classByPredicate(null, x, ClassesSets.elementOf(x, left)), //
					left
			//
			));
			
			DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE = SINGLETON.normal("DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE");
			DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE.be(classA, classB);
			left = Difference.difference(A, Logic.bracket(AinterB));

			DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE.setMain(Logic.equals(left, AminusB));
			lemma(DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE, null, null, "Differenz von Schnitt mit sich selbst ist Differenz", null);
			DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE.setProofs(Logic.equalsMultiline(//
					left, //
					Basics.proofline(Union.union(AminusA, AminusB), DIFFERENCE_OF_INTERSECTION_IS_UNION), //
					Union.union(EmptySet.EMPTY_SET, AminusB), //
					AminusB
			//
			));

			DIFFERENCE_OF_UNION_IS_INTERSECTION = SINGLETON.normal("DIFFERENCE_OF_UNION");
			DIFFERENCE_OF_UNION_IS_INTERSECTION.be(classA, classB);
			left = Difference.difference(A, Logic.bracket(BunionC));
			right = Intersection.intersection(AminusB, AminusC);
			DIFFERENCE_OF_UNION_IS_INTERSECTION.setMain(Logic.equals(left, right));
			lemma(DIFFERENCE_OF_UNION_IS_INTERSECTION, null, null, "Differenz von Vereinigung ist Schnitt der Differenzen", null);
			DIFFERENCE_OF_UNION_IS_INTERSECTION.setProofs(Logic.equalsMultiline(//
					right, //
					ClassesSets.classByPredicate(null, x, ClassesSets.elementOf(x, right)), //
					ClassesSets.classByPredicate(null, x, Bool.and(ClassesSets.elementOf(x, AminusB), ClassesSets.elementOf(x, AminusC))), //
					ClassesSets.classByPredicate(null, x, Bool.andWithBrackets(Bool.and(xElemA, xNotElemB), Bool.and(xElemA, xNotElemC))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Logic.bracket(Bool.and(xNotElemB, xNotElemC)))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Logic.bracket(Bool.and(Bool.not(xElemB), Bool.not(xElemC))))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Bool.not(Logic.bracket(Bool.or(xElemB, xElemC))))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, Bool.not(Logic.bracket(ClassesSets.elementOf(x, BunionC))))), //
					ClassesSets.classByPredicate(null, x, Bool.and(xElemA, ClassesSets.notElementOf(x, BunionC))), //
					ClassesSets.classByPredicate(null, x, ClassesSets.elementOf(x, left)), //
					left
			//
			));

			FIRST_UNION_THEN_DIFFERENCE_IS_UNION = SINGLETON.normal("FIRST_UNION_THEN_DIFFERENCE_IS_UNION");
			FIRST_UNION_THEN_DIFFERENCE_IS_UNION.be(classA, classB, classC);
			left = Difference.difference(Logic.bracket(AunionB), C);
			right = Union.unionWithBrackets(AminusC, BminusC);
			FIRST_UNION_THEN_DIFFERENCE_IS_UNION.setMain(Logic.equals(left, right));
			lemma(FIRST_UNION_THEN_DIFFERENCE_IS_UNION, null, null, "Vereinigung mit anschließender Differenz ist Vereinigung der Differenzen", null);
			FIRST_UNION_THEN_DIFFERENCE_IS_UNION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, left), //
					Bool.and(ClassesSets.elementOf(x, AunionB), xNotElemC), //
					Bool.and(Logic.bracket(xElemAorB), xNotElemC), //
					Bool.orWithBrackets(Bool.and(xElemA, xNotElemC), Bool.and(xElemB, xNotElemC)), //
					Bool.orWithBrackets(ClassesSets.elementOf(x, AminusC), ClassesSets.elementOf(x, BminusC)), //
					ClassesSets.elementOf(x, right) //

			//
			));

			FIRST_UNION_THEN_DIFFERENCE_OF_SAME = SINGLETON.normal("FIRST_UNION_THEN_DIFFERENCE_OF_SAME");
			FIRST_UNION_THEN_DIFFERENCE_OF_SAME.be(classA, classB);
			left = Difference.difference(Logic.bracket(AunionB), B);
			FIRST_UNION_THEN_DIFFERENCE_OF_SAME.setMain(Logic.equals(left, AminusB));
			lemma(FIRST_UNION_THEN_DIFFERENCE_OF_SAME, null, null, "Vereinigung mit anschließender Differenz der gleichen Klasse ist Vereinigung der Differenz",
					null);
			FIRST_UNION_THEN_DIFFERENCE_OF_SAME.setProofs(Logic.equalsMultiline(//
					left, //
					Basics.proofline(Union.unionWithBrackets(AminusB, BminusB), FIRST_UNION_THEN_DIFFERENCE_IS_UNION), //
					Union.unionWithBrackets(AminusB, EmptySet.EMPTY_SET), //
					AminusB
			//
			));

			FIRST_INTERSECTION_THEN_DIFFERENCE_IS_INTERSECTION = SINGLETON.normal("FIRST_INTERSECTION_THEN_DIFFERENCE_IS_INTERSECTION");
			FIRST_INTERSECTION_THEN_DIFFERENCE_IS_INTERSECTION.be(classA, classB, classC);
			left = Difference.difference(Logic.bracket(AinterB), C);
			right = Intersection.intersectionWithBrackets(AminusC, BminusC);
			FIRST_INTERSECTION_THEN_DIFFERENCE_IS_INTERSECTION.setMain(Logic.equals(left, right));
			lemma(FIRST_INTERSECTION_THEN_DIFFERENCE_IS_INTERSECTION, null, null, "Schnitt mit anschließender Differenz ist Schnitt der Differenzen", null);
			FIRST_INTERSECTION_THEN_DIFFERENCE_IS_INTERSECTION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, left), //
					Bool.and(ClassesSets.elementOf(x, AinterB), xNotElemC), //
					Bool.and(Logic.bracket(xElemAandB), xNotElemC), //
					Bool.andWithBrackets(Bool.and(xElemA, xNotElemC), Bool.and(xElemB, xNotElemC)), //
					Bool.andWithBrackets(ClassesSets.elementOf(x, AminusC), ClassesSets.elementOf(x, BminusC)), //
					ClassesSets.elementOf(x, right) //

			//
			));

			DIFFERENCE_OF_DIFFERENCE_IS_UNION = SINGLETON.normal("DIFFERENCE_OF_DIFFERENCE_IS_UNION");
			DIFFERENCE_OF_DIFFERENCE_IS_UNION.be(classA, classB, classC);
			left = Difference.difference(A, Logic.bracket(BminusC));
			right = Union.unionWithBrackets(AminusB, AinterC);
			DIFFERENCE_OF_DIFFERENCE_IS_UNION.setMain(Logic.equals(left, right));
			lemma(DIFFERENCE_OF_DIFFERENCE_IS_UNION, null, null, "Differenz mit einer Differenz ist Vereinigung von Differenz und Schnitt", null);
			DIFFERENCE_OF_DIFFERENCE_IS_UNION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, left), //
					Bool.and(xElemA, Bool.not(ClassesSets.elementOf(x, BminusC))), //
					Bool.and(xElemA, Bool.notWithBrackets(Bool.and(xElemB, Bool.not(xElemC)))), //
					Bool.and(xElemA, Logic.bracket(Bool.or(xNotElemB, xElemC))), //
					Bool.orWithBrackets(Bool.and(xElemA, xNotElemB), Bool.and(xElemA, xElemC)), //
					Bool.orWithBrackets(ClassesSets.elementOf(x, AminusB), ClassesSets.elementOf(x, AinterC)), //
					ClassesSets.elementOf(x, right)
			//
			));

			DIFFERENCE_WITH_DIFFERENCE_OF_SAME_IS_INTERSECTION = SINGLETON.normal("DIFFERENCE_WITH_DIFFERENCE_OF_SAME_IS_INTERSECTION");
			DIFFERENCE_WITH_DIFFERENCE_OF_SAME_IS_INTERSECTION.be(classA, classB);
			left = Difference.difference(A, Logic.bracket(AminusB));
			DIFFERENCE_WITH_DIFFERENCE_OF_SAME_IS_INTERSECTION.setMain(Logic.equals(left, AinterB));
			lemma(DIFFERENCE_WITH_DIFFERENCE_OF_SAME_IS_INTERSECTION, null, null, "Differenz von Differenz von sich selbst ist Schnitt", null);
			DIFFERENCE_WITH_DIFFERENCE_OF_SAME_IS_INTERSECTION.setProofs(Logic.equalsMultiline(//
					left, //
					Union.unionWithBrackets(AminusA, AinterB), //
					Basics.proofline(Union.unionWithBrackets(EmptySet.EMPTY_SET, AinterB), DIFFERENCE_OF_DIFFERENCE_IS_UNION), //
					AinterB
			//
			));

			DIFFERENCE_FROM_DIFFERENCE = SINGLETON.normal("DIFFERENCE_FROM_DIFFERENCE");
			DIFFERENCE_FROM_DIFFERENCE.be(classA, classB, classC);
			left = Difference.difference(Logic.bracket(AminusB), C);
			right = Difference.difference(A, Logic.bracket(BunionC));
			DIFFERENCE_FROM_DIFFERENCE.setMain(Logic.equals(left, right));
			lemma(DIFFERENCE_FROM_DIFFERENCE, null, null, "Differenz von Differenz", null);
			DIFFERENCE_FROM_DIFFERENCE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, left), //
					Bool.and(ClassesSets.elementOf(x, AminusB), Bool.not(xElemC)), //
					Bool.and(xElemA, Bool.not(xElemB), Bool.not(xElemC)), //
					Bool.and(xElemA, Logic.bracket(Bool.and(Bool.not(xElemB), Bool.not(xElemC)))), //
					Bool.and(xElemA, Bool.notWithBrackets(Bool.or(xElemB, xElemC))), //
					Bool.and(xElemA, Bool.not(ClassesSets.elementOf(x, BunionC))), //
					ClassesSets.elementOf(x, right) //
			//
			));

			INTERSECTION_EMPTY_IMPLIES_DIFFERENCE_IS_CLASS = SINGLETON.normal("INTERSECTION_EMPTY_IMPLIES_DIFFERENCE_IS_CLASS");
			INTERSECTION_EMPTY_IMPLIES_DIFFERENCE_IS_CLASS.be(classA, classB);
			left = Logic.equals(AminusB, A);
			right = Logic.equals(AinterB, EmptySet.EMPTY_SET);
			INTERSECTION_EMPTY_IMPLIES_DIFFERENCE_IS_CLASS.setMain(Bool.iff(left, right));
			lemma(INTERSECTION_EMPTY_IMPLIES_DIFFERENCE_IS_CLASS, null, null, "Ist der Schnitt leer, so ist Differenz die erste Klasse", null);
			INTERSECTION_EMPTY_IMPLIES_DIFFERENCE_IS_CLASS
					.setProofs(
							Bool.iffByIf(//
									Bool.implies(left, right), //
									Basics.multiline(//
											Basics.be(left), //
											Bool.implies(left, Subset.subclass(A, AminusB)), //
											Logic.proofByContradiction(//
													Bool.impliesMultiline(//
															ClassesSets.elementOf(x, AinterB), //
															Bool.and(xElemA, xElemB), //
															Basics.proofline(Bool.and(ClassesSets.elementOf(x, AminusB), xElemB),
																	Subset.subclass(A, AminusB)), //
															Bool.and(xElemA, xNotElemB, xElemB), //
															Bool.and(xElemA, Bool.FALSUM), //
															Bool.FALSUM))), //
									Bool.implies(right, left), //
									Basics.multiline(//
											Basics.be(right), //
											Logic.equalsMultiline(//
													AminusB, //
													Basics.proofline(Difference.difference(A, Logic.bracket(AinterB)),
															DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE),
													Difference.difference(A, EmptySet.EMPTY_SET), A)) //
							//
							));

			CLASSES_EQUAL_IFF_INTERSECTIONS_EQUAL = SINGLETON.normal("CLASSES_EQUAL_IFF_INTERSECTIONS_EQUAL");
			CLASSES_EQUAL_IFF_INTERSECTIONS_EQUAL.be(classA, classB);
			left = Logic.equals(AminusB, BminusA);
			right = Logic.equals(A, B);
			CLASSES_EQUAL_IFF_INTERSECTIONS_EQUAL.setMain(Bool.iff(left, right));
			lemma(CLASSES_EQUAL_IFF_INTERSECTIONS_EQUAL, null, null, "Ist die Reihenfolge der Differenz egal, sind beide Klassen gleich", null);
			CLASSES_EQUAL_IFF_INTERSECTIONS_EQUAL.setProofs(Bool.iffByIf(//
					Bool.implies(left, right), //
					Basics.multiline(//
							Basics.be(left), //
							Basics.blankSeparated(Basics.TO_PROOF, AsubclassB, Basics.comment("(die Umkehrung geht genauso)")), //
							Bool.impliesMultiline(//
									xElemA, //
									Bool.and(xElemA, Bool.VERUM), //
									Bool.and(xElemA, Logic.bracket(Bool.or(xNotElemB, xElemB))), //
									Bool.orWithBrackets(Bool.and(xElemA, xNotElemB), Bool.and(xElemA, xElemB)), //
									Bool.or(ClassesSets.elementOf(x, AminusB), xElemB), //
									Bool.or(ClassesSets.elementOf(x, BminusA), xElemB), //
									Bool.or(xElemB, xElemB), //
									xElemB) //
					), //
					Bool.implies(right, left), //
					Basics.TRIVIAL//
			));

			INTERSECTION_AND_DIFFERENCE = SINGLETON.normal("INTERSECTION_AND_DIFFERENCE");
			INTERSECTION_AND_DIFFERENCE.be(classA, classB, classC);
			left = Intersection.intersection(A, Logic.bracket(BminusC));
			INTERSECTION_AND_DIFFERENCE.setMain(Subset.subclass(left, AminusC));
			lemma(INTERSECTION_AND_DIFFERENCE, null, null, "Schnitt mit Differenz ist Teilklasse der Differenz", null);
			INTERSECTION_AND_DIFFERENCE.setProofs(Basics.multiline(//
					left, //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, ClassesSets.elementOf(x, left))), //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, Bool.and(xElemA, ClassesSets.elementOf(x, BminusC)))), //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, Bool.and(xElemA, Bool.and(xElemB, xNotElemC)))), //
					Subset.subclass(ClassesSets.classByPredicate(x, Bool.and(xElemA, xNotElemC))), //
					Subset.subclass(ClassesSets.classByPredicate(x, ClassesSets.elementOf(x, AminusC))), //
					Logic.isEqualTo(AminusC)));

			UNION_AND_DIFFERENCE = SINGLETON.normal("UNION_AND_DIFFERENCE");
			UNION_AND_DIFFERENCE.be(classA, classB, classC);
			right = Union.union(Logic.bracket(BminusA), A);
			UNION_AND_DIFFERENCE.setMain(Subset.subclass(B, right));
			lemma(UNION_AND_DIFFERENCE, null, null, "Teilklasse von Differenz mit Vereinigung", null);
			UNION_AND_DIFFERENCE.setProofs(Basics.multiline(//
					B, //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, xElemB)), //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, Bool.and(xElemB, Bool.VERUM))), //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, Bool.and(xElemB, Logic.bracket(Bool.or(xElemA, xNotElemA))))), //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, Bool.orWithBrackets(Bool.and(xElemB, xNotElemA), Bool.and(xElemB, xElemA)))), //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, Bool.orWithBrackets(ClassesSets.elementOf(x, BminusA), Bool.and(xElemB, xElemA)))), //
					Subset.subclass(ClassesSets.classByPredicate(x, Bool.orWithBrackets(ClassesSets.elementOf(x, BminusA), xElemA))), //
					Logic.isEqualTo(ClassesSets.classByPredicate(x, ClassesSets.elementOf(x, right))), //
					Logic.isEqualTo(right)
			));

			DIFFERENCE_UNION_INTERSECTION_IS_FIRST = SINGLETON.normal("DIFFERENCE_UNION_INTERSECTION_IS_FIRST");
			DIFFERENCE_UNION_INTERSECTION_IS_FIRST.be(classA, classB);
			right = Union.union(Logic.bracket(AminusB), Logic.bracket(AinterB));
			DIFFERENCE_UNION_INTERSECTION_IS_FIRST.setMain(Logic.equals(A, right));
			lemma(DIFFERENCE_UNION_INTERSECTION_IS_FIRST, null, null, "Vereinigung von Differenz mit Schnittmenge ist erste Klasse", null);
			DIFFERENCE_UNION_INTERSECTION_IS_FIRST.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, right), //
					Bool.orWithBrackets(ClassesSets.elementOf(x, AminusB), ClassesSets.elementOf(x, AinterB)), //
					Bool.orWithBrackets(ClassesSets.elementOf(x, AminusB), Bool.and(xElemA, xElemB)), //
					Bool.andWithBrackets(Bool.or(ClassesSets.elementOf(x, AminusB), xElemA), Bool.or(ClassesSets.elementOf(x, AminusB), xElemB)), //
					Bool.and(xElemA, ClassesSets.elementOf(x, AunionB)), xElemA));

			SUBSET_EQUIVALENCES = SINGLETON.normal("SUBSET_EQUIVALENCES");
			SUBSET_EQUIVALENCES.be(AsubclassB);
			Statement AstrictSubsetB = Subset.strictSubclass(A, B);
			Statement BnotSubsetA = Subset.notSubclass(B, A);
			Statement differenceNotEmpty = Logic.notEquals(BminusA, EmptySet.EMPTY_SET);

			SUBSET_EQUIVALENCES.setMain(Bool.iffMultiline(AstrictSubsetB, BnotSubsetA, differenceNotEmpty));
			lemma(SUBSET_EQUIVALENCES, null, null, "Äquivalenzen bei Teilklassen", null);
			SUBSET_EQUIVALENCES.setProofs(Basics.multiline(//
					Bool.RINGSCHLUSS, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(AstrictSubsetB, BnotSubsetA)), //
					Logic.proofByContradiction(//
							Basics.multiline(//
									Bool.impliesMultiline(Bool.and(AstrictSubsetB, BsubclassA), //
											Bool.and(AsubclassB, BsubclassA), //
											Logic.equals(A, B),
											Basics.blankSeparated("Widerspruch, da wegen ", AstrictSubsetB, "gelten muss: ", Logic.notEquals(A, B)))//
							)),//
					Basics.PROOF_END,
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(BnotSubsetA, differenceNotEmpty)), //
					Bool.impliesMultiline(//
							BnotSubsetA, //
							Logic.exists(xElemB, xNotElemA),
							Logic.exists(x, ClassesSets.elementOf(x, BminusA)),//
							differenceNotEmpty),
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(differenceNotEmpty, AstrictSubsetB)), //
					Bool.impliesMultiline(//
							differenceNotEmpty, //
							Logic.exists(x, ClassesSets.elementOf(x, BminusA)), //
							Logic.exists(xElemB, xNotElemA), //
							Logic.notEquals(B, A), // +
							Basics.proofline(AstrictSubsetB, AsubclassB) //
					)//
					//
					));
			
						
			EQUIVALENCES = SINGLETON.normal("EQUIVALENCES");
			EQUIVALENCES.be(classA, classB, classC);
			Statement a = AsubclassB;
			Statement b = Logic.equals(AunionB, B);
			Statement c = Logic.forAll(C, Subset.subclass(AunionC, BunionC));
			Statement d = Logic.equals(AinterB, A);
			Statement e = Logic.forAll(C, Subset.subclass(AinterC, BinterC));
			Statement f = Logic.forAll(C, Subset.subclass(AminusC, BminusC));
			Statement g = Logic.equals(AminusB, EmptySet.EMPTY_SET);
			Statement h = Subset.subclass(AminusB, BminusA);
			Statement i = Logic.equals(Union.union(A, Logic.bracket(BminusA)), B);
			EQUIVALENCES.setMain(Bool.iffMultiline(a, b, c, d, e, f, g, h, i));
			lemma(EQUIVALENCES, null, null, "Äquivalenzen", null);
			EQUIVALENCES.setProofs(Basics.multiline(//
					Bool.RINGSCHLUSS, //
					Basics.proofline(Bool.iff(a, b), Union.UNION_WITH_SUBCLASS),//
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(b, c)), //
					Subset.subclass(AunionC, Logic.equals(Union.union(AunionC, B), Union.union(AunionB, C), BunionC)), //
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(c, a)), //
					Subset.subclass(Logic.equals(A, Union.union(A, EmptySet.EMPTY_SET)), Logic.equals(Union.union(B, EmptySet.EMPTY_SET), B)), //
					Basics.PROOF_END, //
					Basics.proofline(Bool.iff(a, d), Intersection.INTERSECTION_WITH_SUBCLASS), //
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(d, e)), //
							Subset.subclass(Logic.equals(AinterC, Intersection.intersection(Logic.bracket(AinterB), C),
									Intersection.intersection(A, Logic.bracket(BinterC))), BinterC), //
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(e, f)), //
					AminusC, Logic.isEqualTo(Intersection.intersection(A, AminusC)), //
					Subset.subclass(Intersection.intersection(B, AminusC)), //
					Basics.proofline(Subset.subclass(BminusC), INTERSECTION_AND_DIFFERENCE), //
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(f, g)), //
					Subset.subclass(AminusB, Logic.equals(BminusB, EmptySet.EMPTY_SET)), // ,
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(g, h)), //
					Subset.subclass(Logic.equals(AminusB, EmptySet.EMPTY_SET), BminusA), // ,
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(h, a)), //
					Subset.subclasses(A, Union.union(Logic.bracket(AminusB), B), Union.union(Logic.bracket(BminusA), B), B), //
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(i, a)), //
					Subset.subclass(A, Logic.equals(Union.union(A, Logic.bracket(BminusA)), B)), //
					Basics.PROOF_END, //
					Basics.blankSeparated(Basics.TO_PROOF, Bool.implies(a, i)), //
					Logic.equals(Union.union(A, Logic.bracket(BminusA)), AunionB, B) //
					));

			// -------------------------------------------------------------------------------------------
			// -------------------------------------------------------------------------------------------

			titleText(SINGLETON.unit(2), null, null, "Lemmata über Operationen auf Klassen (2)", null);

			// -------------------------------------------------------------------------------------------
			Statement BelememI = ClassesSets.elementOf(B, I);

			UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE = SINGLETON.normal("UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE");
			UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE.setReferences(References.ml1("1.5.9"));
			UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE.be(classA, nonEmptySetOfSetsI);
			UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE
					.setMain(Logic.equals(Union.union(A, Logic.bracket(arbitraryIntersectionIB)),
							Intersection.arbitraryIntersection(B, I, Logic.bracket(Union.union(A, B)))));
			lemma(UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE, null, null, "Distributivgesetz Vereinigung-verallgemeinerter Schnitt", null);
			UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE.setProofs(//
					Bool.iffMultiline(ClassesSets.elementOf(x, Union.union(A, Logic.bracket(arbitraryIntersectionIB))), //
							Bool.or(xElemA, ClassesSets.elementOf(x, arbitraryIntersectionIB)), //
							Bool.or(xElemA, Logic.bracket(Logic.forAll(BelememI, xElemB))), //
							Basics.proofline(Logic.forAll(BelememI, Bool.or(xElemA, xElemB)), Logic.SWAP_OR_FOR_ALL), //
							Logic.forAll(BelememI, ClassesSets.elementOf(x, Union.union(A, B))),
							ClassesSets.elementOf(x, Intersection.arbitraryIntersection(B, I, Logic.bracket(Union.union(A, B))))));


			UNION_ARBITRARY_INTERSECTIONS = SINGLETON.normal("UNION_ARBITRARY_INTERSECTIONS");
			UNION_ARBITRARY_INTERSECTIONS.be(nonEmptySetOfSetsI, nonEmptySetOfSetsJ);
			left = Union.union(Logic.bracket(arbitraryIntersectionJA), Logic.bracket(arbitraryIntersectionIB));
			right = Intersection.arbitraryIntersection(B, I, Intersection.arbitraryIntersection(A, J, Logic.bracket(Union.union(A, B))));
			UNION_ARBITRARY_INTERSECTIONS.setMain(Logic.equals(left, right));
			lemma(UNION_ARBITRARY_INTERSECTIONS, null, null, "Vereinigung von Schnitten", null);
			UNION_ARBITRARY_INTERSECTIONS.setProofs(//
					Logic.equalsMultiline(//
							left, //
							Intersection.arbitraryIntersection(B, I, Logic.bracket(Union.union(Logic.bracket(arbitraryIntersectionJA), B))), //
							right));

			INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE = SINGLETON.normal("INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE");
			INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE.setReferences(References.ml1("1.5.9"));
			INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE.be(classA, nonEmptySetOfSetsI);
			INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE.setMain(Logic.equals(Intersection.intersection(A, Logic.bracket(arbitraryUnionIB)),
					Union.arbitraryUnion(B, I, Logic.bracket(Intersection.intersection(A, B)))));
			lemma(INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE, null, null, "Distributivgesetz Schnitt-verallgemeinerte Vereinigung", null);
			INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE.setProofs(//
					Bool.iffMultiline(ClassesSets.elementOf(x, Intersection.intersection(A, Logic.bracket(arbitraryUnionIB))), //
							Bool.and(xElemA, ClassesSets.elementOf(x, arbitraryUnionIB)), //
							Bool.and(xElemA, Logic.bracket(Logic.exists(BelememI, xElemB))), //
							Basics.proofline(Logic.exists(BelememI, Bool.and(xElemA, xElemB)), Logic.SWAP_AND_EXISTS), //
							Logic.exists(BelememI, ClassesSets.elementOf(x, Intersection.intersection(A, B))),
							ClassesSets.elementOf(x, Union.arbitraryUnion(B, I, Logic.bracket(Intersection.intersection(A, B))))));

			INTERSECTION_ARBITRARY_UNIONS = SINGLETON.normal("INTERSECTION_ARBITRARY_UNIONS");
			INTERSECTION_ARBITRARY_UNIONS.be(nonEmptySetOfSetsI, nonEmptySetOfSetsJ);
			left = Intersection.intersection(Logic.bracket(arbitraryUnionJA), Logic.bracket(arbitraryUnionIB));
			right = Union.arbitraryUnion(B, I, Union.arbitraryUnion(A, J, Logic.bracket(Intersection.intersection(A, B))));
			INTERSECTION_ARBITRARY_UNIONS.setMain(Logic.equals(left, right));
			lemma(INTERSECTION_ARBITRARY_UNIONS, null, null, "Schnitt von Vereinigungen", "Insbesondere gilt ", Logic.equals(
					Intersection.intersection(A, Logic.bracket(arbitraryUnionIB)), Union.arbitraryUnion(B, I, Logic.bracket(Intersection.intersection(A, B)))));
			INTERSECTION_ARBITRARY_UNIONS.setProofs(//
					Logic.equalsMultiline(//
							left, //
							Union.arbitraryUnion(B, I, Logic.bracket(Intersection.intersection(Logic.bracket(arbitraryUnionJA), B))), //
							right));


			DIFFERENCE_OF_INTERSECTIONS_IS_UNION = SINGLETON.normal("DIFFERENCE_OF_INTERSECTIONS_IS_UNION");
			DIFFERENCE_OF_INTERSECTIONS_IS_UNION.be(classA, nonEmptySetOfSetsI);
			left = Difference.difference(A, Logic.bracket(arbitraryIntersectionIB));
			right = Union.arbitraryUnion(B, I, AminusB);
			DIFFERENCE_OF_INTERSECTIONS_IS_UNION.setMain(Logic.equals(left, right));
			lemma(DIFFERENCE_OF_INTERSECTIONS_IS_UNION, null, null, "Differenz von Schnitten ist Vereinigung der Differenzen (De-Morgansche Regel)",
					"Betrachtet man ", A, " als Universum, so vereinfacht sich die Regel zu ",
					Logic.equals(Difference.complement(Logic.bracket(arbitraryIntersectionIB)), Union.arbitraryUnion(B, I, Difference.complement(B))));
			DIFFERENCE_OF_INTERSECTIONS_IS_UNION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, right), //
					Logic.exists(BelemI, ClassesSets.elementOf(x, AminusB)), //
					Logic.exists(BelemI, Bool.and(xElemA, xNotElemB)), //
					Bool.and(xElemA, Logic.exists(BelemI, xNotElemB)), //
					Bool.and(xElemA, Logic.exists(BelemI, Bool.not(xElemB))), //
					Bool.and(xElemA, Bool.not(Logic.forAll(BelemI, xElemB))), //
					Bool.and(xElemA, Bool.not(ClassesSets.elementOf(x, arbitraryIntersectionIB))), //
					ClassesSets.elementOf(x, left)//
			//
			));

			DIFFERENCE_OF_UNIONS_IS_INTERSECTION = SINGLETON.normal("DIFFERENCE_OF_UNIONS_IS_INTERSECTION");
			DIFFERENCE_OF_UNIONS_IS_INTERSECTION.be(classA, nonEmptySetOfSetsI);
			left = Difference.difference(A, Logic.bracket(arbitraryUnionIB));
			right = Intersection.arbitraryIntersection(B, I, AminusB);
			DIFFERENCE_OF_UNIONS_IS_INTERSECTION.setMain(Logic.equals(left, right));
			lemma(DIFFERENCE_OF_UNIONS_IS_INTERSECTION, null, null, "Differenz von Vereinigungen ist Schnitt der Differenzen (De-Morgansche Regel)",
					"Betrachtet man ", A,
					" als Universum, so vereinfacht sich die Regel zu ",
					Logic.equals(Difference.complement(Logic.bracket(arbitraryUnionIB)), Intersection.arbitraryIntersection(B, I, Difference.complement(B))));
			DIFFERENCE_OF_UNIONS_IS_INTERSECTION.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(x, right), //
					Logic.forAll(BelemI, ClassesSets.elementOf(x, AminusB)), //
					Logic.forAll(BelemI, Bool.and(xElemA, xNotElemB)), //
					Bool.and(xElemA, Logic.forAll(BelemI, xNotElemB)), //
					Bool.and(xElemA, Logic.forAll(BelemI, Bool.not(xElemB))), //
					Bool.and(xElemA, Bool.not(Logic.exists(BelemI, xElemB))), //
					Bool.and(xElemA, Bool.not(ClassesSets.elementOf(x, arbitraryUnionIB))), //
					ClassesSets.elementOf(x, left)//
			//
			));
			
			UNION_IS_SYMMETRIC_DIFFERENCE_AND_INTERSECTION = SINGLETON.normal("UNION_IS_SYMMETRIC_DIFFERENCE_AND_INTERSECTION");
			UNION_IS_SYMMETRIC_DIFFERENCE_AND_INTERSECTION.be(classA, classB);

			right = Union.unionWithBrackets(Difference.symmetricDifference(A, B), AinterB);
			UNION_IS_SYMMETRIC_DIFFERENCE_AND_INTERSECTION.setMain(Logic.equals(AunionB, right));
			lemma(UNION_IS_SYMMETRIC_DIFFERENCE_AND_INTERSECTION, null, null, "Vereinigungen ist symmetrische Differenz plus Schnitt", null);
			UNION_IS_SYMMETRIC_DIFFERENCE_AND_INTERSECTION.setProofs(Logic.equalsMultiline(//
					right, //
					Union.unionWithBrackets(Union.unionWithBrackets(AminusB, BminusA), AinterB), //
					Union.unionWithBrackets(Union.unionWithBrackets(AminusB, AinterB), Union.unionWithBrackets(BminusA, AinterB)), //
					Union.union(A, B)));

			PARTITION_OF_SUBSET = SINGLETON.normal("PARTITION_OF_SUBSET");
			PARTITION_OF_SUBSET.setReferences(wt1("1.2.6"));
			PARTITION_OF_SUBSET.be(Union.partition(I, U), AsubclassU);
			PARTITION_OF_SUBSET.setMain(Logic.equals(A, Union.arbitraryDisjointUnion(B, I, Intersection.intersection(A, B))));
			lemma(PARTITION_OF_SUBSET, null, null, "Partition einer Teilmenge ", null);
			PARTITION_OF_SUBSET
					.setProofs(Basics.multiline(//
							Logic.equals(A, Intersection.intersection(A, U), Intersection.intersection(A, arbitraryUnionIB),
									Union.arbitraryUnion(B, I, AinterB)),
							Bool.implies(Basics.be(ClassesSets.elementOf(Basics.commaSeparated(B_1, B_2), I)),
									Bool.implies(Logic.equals(Intersection.intersection(B_1, B_2), EmptySet.EMPTY_SET),
											Logic.equals(
													Intersection.intersectionWithBrackets(Intersection.intersection(B_1, A),
															Intersection.intersection(B_2, A)),
													EmptySet.EMPTY_SET)))
			//
			));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}




	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(UNION_INTERSECTION_DISTRIBUTIVE, INTERSECTION_UNION_DISTRIBUTIVE, FIRST_DIFFERENCE_THEN_INTERSECTION_IS_EMPTY,
						FIRST_DIFFERENCE_THEN_UNION_IS_UNION, DIFFERENCE_OF_INTERSECTION_IS_UNION, DIFFERENCE_OF_INTERSECTION_WITH_SAME_IS_DIFFERENCE,
						DIFFERENCE_OF_UNION_IS_INTERSECTION,
						FIRST_UNION_THEN_DIFFERENCE_IS_UNION, FIRST_UNION_THEN_DIFFERENCE_OF_SAME, FIRST_INTERSECTION_THEN_DIFFERENCE_IS_INTERSECTION,
						DIFFERENCE_OF_DIFFERENCE_IS_UNION, DIFFERENCE_WITH_DIFFERENCE_OF_SAME_IS_INTERSECTION, DIFFERENCE_FROM_DIFFERENCE,
						INTERSECTION_EMPTY_IMPLIES_DIFFERENCE_IS_CLASS, CLASSES_EQUAL_IFF_INTERSECTIONS_EQUAL, INTERSECTION_AND_DIFFERENCE,
						UNION_AND_DIFFERENCE, DIFFERENCE_UNION_INTERSECTION_IS_FIRST, SUBSET_EQUIVALENCES,
						EQUIVALENCES),
				(List) Arrays.asList());
	}

	public static StudyUnit createStudyUnit2() {

		return new StudyUnit(SINGLETON, 2,
				Arrays.asList(UNION_IS_SYMMETRIC_DIFFERENCE_AND_INTERSECTION, UNION_ARBITRARY_INTERSECTION_DISTRIBUTIVE, UNION_ARBITRARY_INTERSECTIONS,
						INTERSECTION_ARBITRARY_UNION_DISTRIBUTIVE,
						INTERSECTION_ARBITRARY_UNIONS,
						DIFFERENCE_OF_INTERSECTIONS_IS_UNION,
						DIFFERENCE_OF_UNIONS_IS_INTERSECTION, PARTITION_OF_SUBSET),
				(List) Arrays.asList());
	}

}
