package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.BasicsFactory;
import net.sf.gluebooster.demos.pojo.math.library.VariableExamples;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.BoolFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.CartesianProductFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.DifferenceFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.IntersectionFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.UnionFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.CompositionFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinaryFactory;

public interface SetTheorySamples extends VariableExamples {

	Statement classA = ClassesSetsFactory.clasz(A);
	Statement classB = ClassesSetsFactory.clasz(B);
	Statement classC = ClassesSetsFactory.clasz(C);
	Statement classD = ClassesSetsFactory.clasz(D);

	Statement setA = ClassesSetsFactory.set(A);
	Statement setAextended = ClassesSetsFactory.set(A).setDisplayIdentifyingName(true);

	Statement setB = ClassesSetsFactory.set(B);
	Statement setC = ClassesSetsFactory.set(C);

	Statement setU = ClassesSetsFactory.set(U);

	Statement setX = ClassesSets.set(X);

	Statement nonEmptyClassA = BasicsFactory.commaSeparated(classA.cloneWithDisplayIdentifyingName(), EmptySetFactory.notEmptySet(A));
	Statement nonEmptyClassB = BasicsFactory.commaSeparated(classB.cloneWithDisplayIdentifyingName(), EmptySetFactory.notEmptySet(B));

	Statement nonEmptySetI = BasicsFactory.commaSeparated(ClassesSetsFactory.set(I).cloneWithDisplayIdentifyingName(), EmptySetFactory.notEmptySet(I));
	Statement nonEmptySetOfSetsI = BasicsFactory.commaSeparated(ClassesSetsFactory.setOfSets(I).cloneWithDisplayIdentifyingName(),
			EmptySetFactory.notEmptySet(I));
	Statement nonEmptySetOfSetsJ = BasicsFactory.commaSeparated(ClassesSetsFactory.setOfSets(J).cloneWithDisplayIdentifyingName(),
			EmptySetFactory.notEmptySet(J));


	Statement EMPTY_SET = EmptySetFactory.EMPTY_SET;

	Statement aElemA = ClassesSetsFactory.elementOf(a, A);
	Statement aElemB = ClassesSetsFactory.elementOf(a, B);
	Statement aElemC = ClassesSetsFactory.elementOf(a, C);
	Statement aGc = Basics.notSeparated(a, G, c);
	Statement aGc1 = Basics.notSeparated(a, G, c_1);
	Statement aGc2 = Basics.notSeparated(a, G, c_2);

	Statement bElemA = ClassesSetsFactory.elementOf(b, A);
	Statement bElemB = ClassesSetsFactory.elementOf(b, B);

	Statement cElemA = ClassesSetsFactory.elementOf(c, A);
	Statement cElemB = ClassesSetsFactory.elementOf(c, B);
	Statement cFb = Basics.notSeparated(c, F, b);
	Statement c1Fb1 = Basics.notSeparated(c_1, F, b_1);
	Statement c2Fb1 = Basics.notSeparated(c_2, F, b_1);
	Statement c2Fb2 = Basics.notSeparated(c_2, F, b_2);

	Statement dElemD = ClassesSetsFactory.elementOf(d, D);

	Statement eElemA = ClassesSetsFactory.elementOf(e, A);

	Statement iElemI = ClassesSetsFactory.elementOf(i, I);

	Statement xElemA = ClassesSetsFactory.elementOf(x, A);
	Statement xElemB = ClassesSetsFactory.elementOf(x, B);
	Statement xElemC = ClassesSetsFactory.elementOf(x, C);
	Statement xElemX = ClassesSetsFactory.elementOf(x, X);
	Statement xElemDf = ClassesSetsFactory.elementOf(x, RelationBinaryFactory.domain(f));
	Statement xElemDg = ClassesSetsFactory.elementOf(x, RelationBinaryFactory.domain(g));
	Statement xElemDF = ClassesSetsFactory.elementOf(x, RelationBinaryFactory.domain(F));
	Statement xElemDG = ClassesSetsFactory.elementOf(x, RelationBinaryFactory.domain(G));

	Statement yElemB = ClassesSetsFactory.elementOf(y, B);
	Statement yElemC = ClassesSetsFactory.elementOf(y, C);
	Statement yElemD = ClassesSetsFactory.elementOf(y, D);


	Statement AelemC = ClassesSetsFactory.elementOf(A, C);
	Statement AelemI = ClassesSetsFactory.elementOf(A, I);
	Statement BelemI = ClassesSetsFactory.elementOf(B, I);

	Statement XelemA = ClassesSets.elementOf(X, A);
	Statement XelemI = ClassesSets.elementOf(X, I);

	Statement xNotElemA = ClassesSetsFactory.notElementOf(x, A);
	Statement xNotElemB = ClassesSetsFactory.notElementOf(x, B);
	Statement xNotElemC = ClassesSetsFactory.notElementOf(x, C);

	Statement xElemAorB = BoolFactory.or(xElemA, xElemB);
	Statement xElemAandB = BoolFactory.and(xElemA, xElemB);

	Statement xTy = TuplesFactory.pair(x, y);

	Statement yNotElemD = ClassesSetsFactory.notElementOf(y, D);

	Statement AsubclassB = SubsetFactory.subclass(A, B);
	Statement AsubclassC = SubsetFactory.subclass(A, C);
	Statement AsubclassU = SubsetFactory.subclass(A, U);
	Statement AsubclassX = SubsetFactory.subclass(A, X);

	Statement BsubclassA = SubsetFactory.subclass(B, A);
	Statement BsubclassC = SubsetFactory.subclass(B, C);
	Statement BsubclassD = SubsetFactory.subclass(B, D);
	Statement BsubclassU = SubsetFactory.subclass(B, U);

	Statement Gofa = RelationBinary.functionValueAt(G, a);
	Statement Gofx = RelationBinary.functionValueAt(G, x);

	Statement XsubclassA = SubsetFactory.subclass(X, A);
	Statement XsubclassB = SubsetFactory.subclass(X, B);

	Statement YsubclassA = SubsetFactory.subclass(Y, A);
	Statement YsubclassB = SubsetFactory.subclass(Y, B);

	Statement arbitraryIntersectionIB = IntersectionFactory.arbitraryIntersection(B, I, B);
	Statement arbitraryIntersectionIX = IntersectionFactory.arbitraryIntersection(X, I, X);
	Statement arbitraryIntersectionJA = IntersectionFactory.arbitraryIntersection(A, J, A);
	Statement arbitraryIntersectionAi = IntersectionFactory.arbitraryIntersection(i, I, A_i);
	Statement arbitraryIntersectionBi = IntersectionFactory.arbitraryIntersection(i, I, B_i);

	Statement arbitraryUnionIB = UnionFactory.arbitraryUnion(B, I, B);
	Statement arbitraryUnionIX = UnionFactory.arbitraryUnion(X, I, X);
	Statement arbitraryUnionJA = UnionFactory.arbitraryUnion(A, J, A);
	Statement arbitraryUnionJC = UnionFactory.arbitraryUnion(C, J, C);
	Statement arbitraryUnionAi = UnionFactory.arbitraryUnion(i, I, A_i);
	Statement arbitraryUnionBi = UnionFactory.arbitraryUnion(i, I, B_i);
	Statement arbitraryUnionAapos = UnionFactory.arbitraryUnion(Aapos);
	Statement arbitraryUnionCapos = UnionFactory.arbitraryUnion(Capos);

	Statement AinterB = IntersectionFactory.intersection(A, B);
	Statement AinterC = IntersectionFactory.intersection(A, C);
	Statement BinterC = IntersectionFactory.intersection(B, C);
	Statement BinterD = IntersectionFactory.intersection(B, D);
	Statement CinterD = IntersectionFactory.intersection(C, D);

	Statement AunionB = UnionFactory.union(A, B);
	Statement AunionC = UnionFactory.union(A, C);
	Statement BunionC = UnionFactory.union(B, C);
	Statement BunionD = UnionFactory.union(B, D);

	Statement AminusA = DifferenceFactory.difference(A, A);
	Statement AminusB = DifferenceFactory.difference(A, B);
	Statement AminusC = DifferenceFactory.difference(A, C);

	Statement BminusA = DifferenceFactory.difference(B, A);
	Statement BminusB = DifferenceFactory.difference(B, B);
	Statement BminusC = DifferenceFactory.difference(B, C);
	Statement BminusD = DifferenceFactory.difference(B, D);

	Statement UminusB = DifferenceFactory.difference(U, B);

	Statement XminusY = DifferenceFactory.difference(X, Y);

	Statement AcrossB = CartesianProductFactory.binary(A, B);
	Statement AcrossC = CartesianProductFactory.binary(A, C);
	Statement AcrossD = CartesianProductFactory.binary(A, D);
	Statement BcrossA = CartesianProductFactory.binary(B, A);
	Statement CcrossD = CartesianProductFactory.binary(C, D);

	Statement domF = RelationBinaryFactory.domain(F);
	Statement domG = RelationBinaryFactory.domain(G);
	Statement domR = RelationBinaryFactory.domain(R);
	Statement dom_f = RelationBinaryFactory.domain(f);
	Statement dom_g = RelationBinaryFactory.domain(g);

	Statement FafterG = CompositionFactory.composite(F, G);

	Statement Acomplement = DifferenceFactory.complement(A);
	Statement Bcomplement = DifferenceFactory.complement(B);
}
