package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import net.sf.gluebooster.demos.pojo.math.MathStudies;
import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.operations.Powerset;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.CompositionFactory;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.Relation;
import net.sf.gluebooster.demos.pojo.math.library.setTheory.relations.RelationBinary;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.Write;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteExtended;
import net.sf.gluebooster.demos.pojo.math.studies.WriteMulti;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.basic.math.GeometryPositionConstraint;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of set theory concerning classes.
 * 
 * @see https://glossar.hs-augsburg.de/Klasse_(Mengenlehre)
 * 
 * @author cbauer
 *
 */
public class Subset extends SubsetFactory implements SetTheorySamples {


	public static Statement SUBCLASS;
	public static Statement SUBCLASSES;
	public static Statement SUBCLASSES_MULTILINE;

	public static Statement REFLEXIV;

	public static Statement ANTISYMMETRIC;

	public static Statement EQUALITY_PROOF_BY_SUBSETS;

	// public static Statement ANTISYMMETRIC_BACKWARDS;

	// public static Statement ANTISYMMETRIC_BICONDITIONAL;

	public static Statement TRANSITIVE;

	public static Statement NOT_SUBCLASS;

	public static Statement NOT_SUBCLASS_AND_EXISTS;
	
	public static Statement STRICT_SUBCLASS;

	public static Statement SUPERCLASS;

	public static Statement NOT_SUPERCLASS;

	public static Statement SUBSET;


	public static Statement SUPERSET;

	public static Statement SUBSET_NEGATION;

	public static Statement SUBCLASS_RELATION;

	public static Statement SUBCLASS_RELATION_TRANSITIVE;

	private Subset() {
	}

	static {
		try {
			titleText(SINGLETON.unit(1), "Subclass/subset (1)", null, "Teilklasse/Teilmenge (1)", null);






			SUBCLASS = subclass(A, B);
			SUBCLASS.setReferences(References.wikiEn("Subclass_(set_theory)"), References.wikiDe("Teilmenge"));
			SUBCLASS.be(classA, classB);
			SUBCLASS.setMain(
					Arrays.asList(Bool.definedAsEqualTo(subclass(A, B), Logic.forAll(x, Bool.implies(xElemA, xElemB)))));
			definition(SUBCLASS, "Subclass", null, "Teilklasse", "Ist a keine Teilklasse von B, so schreibt man ", notSubclass(A, B));
			MathMLGenerator.displayRule(SUBCLASS, new WriteOperation("⊆"));
			SUBCLASS.setExamples(//
					subclass(ClassesSets.explicitSetWithoutName(ZERO, ONE, TWO), ClassesSets.explicitSetWithoutName(ZERO, ONE, TWO, THREE))
			//
			);

			SUBCLASSES = subclasses();
			MathMLGenerator.displayRule(SUBCLASSES, new WriteOperation("⊆"));

			SUBCLASSES_MULTILINE = subclassesMultiline();
			MathMLGenerator.displayRule(SUBCLASSES_MULTILINE, writeMultiline(subclass(Basics.EMPTY, Basics.EMPTY)));

			NOT_SUBCLASS_AND_EXISTS = SINGLETON.normal("NOT_SUBCLASS_AND_EXISTS");
			NOT_SUBCLASS_AND_EXISTS.setReferences(References.ml1("1.6.6"));
			NOT_SUBCLASS_AND_EXISTS.be(classA, classB);
			NOT_SUBCLASS_AND_EXISTS.setMain(Arrays.asList(Bool.iff(notSubclass(A, B), Logic.exists(xElemA, xNotElemB))));
			NOT_SUBCLASS_AND_EXISTS.setProofs(Bool.iffMultiline(//
					notSubclass(A, B), //
					Bool.not(subclass(A, B)), //
					Bool.not(Logic.forAll(x, Bool.implies(xElemA, ClassesSets.elementOf(x, B)))), //
					Logic.exists(x, Bool.notWithBrackets(Bool.implies(xElemA, xElemB))),
					Logic.exists(x, Bool.notWithBrackets(Bool.implies(xNotElemB, xNotElemA))),
					Logic.exists(x, Bool.notWithBrackets(Bool.or(Bool.not(xNotElemB), xNotElemA))), //
					Logic.exists(x, Bool.and(Bool.not(Bool.not(xNotElemB)), Bool.not(xNotElemA))), //
					Logic.exists(x, Bool.and(xNotElemB, xElemA)), //
					Logic.exists(xElemA, xNotElemB)
			//
			));
			lemma(NOT_SUBCLASS_AND_EXISTS, null, null, "Keine Teilklasse impliziert weiteres Element", null);

			SUBSET = subset(A, B);
			SUBSET.setReferences(References.wikiEn("Subset"), References.wikiDe("Teilmenge"));
			SUBSET.setBe(Arrays.asList(ClassesSets.set(A), ClassesSets.set(B)));
			SUBSET.setMain(Bool.definedAsEqualTo(subset(A, B), subclass(A, B)));
			SUBSET.setWorthwileMain(false);
			definition(SUBSET, "Subset", null, "Teilmenge", "Eine Teilmenge ", subset(A, B),
					" ist eine Teilklasse einer Menge (und ist ebenfalls eine Menge). Statt Teilmenge spricht man auch von Untermenge.");
			MathMLGenerator.displayRule(SUBSET, new WriteOperation("⊆"));

			SUBSET_NEGATION = SINGLETON.normal("SUBSET_NEGATION");
			SUBSET_NEGATION.setReferences(References.ml1("1.6.2"));
			SUBSET_NEGATION.be(classA, classB);
			SUBSET_NEGATION.setMain(Bool.implies(subset(A, B), Logic.bracket(Bool.implies(xNotElemB, xNotElemA))));
			lemma(SUBSET_NEGATION, null, null, "Teilmenge und Nicht-Element-von", null);
			SUBSET_NEGATION.setProofs(Bool.impliesMultiline(//
					subset(A, B), //
					Logic.bracket(Bool.implies(xElemA, xElemB)), //
					Logic.bracket(Bool.impliesWithBrackets(Bool.not(xElemB), Bool.not(xElemA))), //
					Logic.bracket(Bool.implies(xNotElemB, xNotElemA)) //
			));

			SUPERSET = superset(B, A);
			SUPERSET.setReferences(References.wikiEn("Subset"), References.wikiDe("Teilmenge"));
			SUPERSET.setBe(Arrays.asList(ClassesSets.set(A), ClassesSets.set(B)));
			SUPERSET.setMain(Bool.definedAsEqualTo(superset(B, A), superclass(B, A)));
			SUPERSET.setWorthwileMain(false);
			definition(SUPERSET, "Superset", null, "Obermenge", "Eine Obermenge ", superset(B, A), " ist eine Oberklasse, die eine Menge ist.");
			MathMLGenerator.displayRule(SUPERSET, new WriteOperation("⊇"));

			REFLEXIV = SINGLETON.lemma("subclassReflexiv");
			REFLEXIV.setReferences(References.wikiEn("Subset"), References.wikiDe("Teilmenge"));
			REFLEXIV.setBe(Arrays.asList(classA));
			REFLEXIV.setMain(subclass(A, A));
			lemma(REFLEXIV, "Any class is subclass of itself", null, "die Teilklassenrelation ist reflexiv", "Jede Klasse ist Teilklasse von sich selbst");
			REFLEXIV.setWorthwhileToTranslate(false);
			REFLEXIV.setProofs(
					Bool.impliesMultiline(Bool.implies(xElemA, xElemA), Logic.forAll(x, Bool.implies(xElemA, xElemA)), subclass(A, A)));

			ANTISYMMETRIC = SINGLETON.lemma("subclassAntisymmetric");
			ANTISYMMETRIC.setReferences(References.wikiEn("Subset"), References.wikiDe("Teilmenge"));
			ANTISYMMETRIC.be(classA, classB);
			ANTISYMMETRIC.setMain(Bool.iff(Bool.and(subclass(A, B), subclass(B, A)), Logic.equals(Arrays.asList(A, B))));
			lemma(ANTISYMMETRIC, "The subclass relation is antisymmetric", null, "die Teilklassenrelation ist antisymmtrisch", null);
			ANTISYMMETRIC.setWorthwhileToTranslate(false);
			ANTISYMMETRIC
					.setProofs(Bool.biconditionalMultiline(//
							Logic.equals(Arrays.asList(A, B)),
							Basics.proofline(Logic.forAll(x, Bool.iff(ClassesSets.elementOf(x, A), ClassesSets.elementOf(x, B))),
									Basics.DEFINITION),
							Logic.forAll(
									x, Bool
											.andWithBrackets(Bool.implies(ClassesSets.elementOf(x, A), ClassesSets.elementOf(x, B)),
													Bool.impliedBy(ClassesSets.elementOf(x, A),
															ClassesSets.elementOf(x, B)))),
							Bool.andWithBrackets(Logic.forAll(x, Bool.implies(ClassesSets.elementOf(x, A), ClassesSets.elementOf(x, B))),
									Logic.forAll(x, Bool.impliedBy(ClassesSets.elementOf(x, A), ClassesSets.elementOf(x, B)))),
							Bool.andWithBrackets(Logic.forAll(x, Bool.implies(ClassesSets.elementOf(x, A), ClassesSets.elementOf(x, B))),
									Logic.forAll(x, Bool.implies(ClassesSets.elementOf(x, B), ClassesSets.elementOf(x, A)))),
							Bool.and(subclass(A, B), subclass(B, A))
			//
			));

			EQUALITY_PROOF_BY_SUBSETS = equalsBySubclasses(null, null);
			MathMLGenerator.displayRule(EQUALITY_PROOF_BY_SUBSETS,
					WriteAfterStatementTransformation.ruleTransformation(Basics.MULTILINE, //
							new Object[] { Basics.NOT_SEPARATED, "'", Subset.subclass(Basics.EMPTY, Basics.EMPTY), "' " }, //
							FIRST_VARIABLE, //
							new Object[] { Basics.NOT_SEPARATED, "'", Subset.superclass(Basics.EMPTY, Basics.EMPTY), "' " }, //
							SECOND_VARIABLE));
			// ANTISYMMETRIC_BACKWARDS = FACTORY.lemma("subclassAntisymmetricBackwards");
			// // SUBCLASS_ANTISYMMETRIC_BACKWARDS.setReferences(References.wikiEn("Subset"), References.wikiDe("Teilmenge"));
			// ANTISYMMETRIC_BACKWARDS.be(classA, classB);
			// ANTISYMMETRIC_BACKWARDS.setMain(Boolean.implies(Logic.equals(Arrays.asList(A, B)), Boolean.and(subclass(A, B), subclass(B, A))));
			// lemma(ANTISYMMETRIC_BACKWARDS, null, null, "Rückschluss", null);

			// ANTISYMMETRIC_BICONDITIONAL = FACTORY.lemma("subclassAntisymmetricBiconditional");
			// // ANTISYMMETRIC_BICONDITIONAL.setReferences(References.wikiEn("Subset"), References.wikiDe("Teilmenge"));
			// ANTISYMMETRIC_BICONDITIONAL.be(classA, classB);
			// ANTISYMMETRIC_BICONDITIONAL.setMain(Boolean.biconditional(Logic.equals(Arrays.asList(A, B)), Boolean.and(subclass(A, B), subclass(B, A))));
			// lemma(ANTISYMMETRIC_BICONDITIONAL, null, null, "Antisymmetrie (Bikonditional)", null);

			TRANSITIVE = SINGLETON.lemma("subclassTransitive");
			TRANSITIVE.setReferences(References.wikiEn("Subset"), References.wikiDe("Teilmenge"));
			TRANSITIVE.be(classA, classB, ClassesSets.clasz(C));
			TRANSITIVE.setMain(Bool.implies(Bool.and(subclass(A, B), subclass(B, C)), subclass(A, C)));
			lemma(TRANSITIVE, "The subclass relation is transitive", null, "Die Teilklassenrelation ist transitiv", null);
			TRANSITIVE.setProofs(Bool.impliesMultiline(//
					xElemA, //
					Basics.proofline(xElemB, subclass(A, B)), //
					Basics.proofline(xElemC, subclass(B, C))
			//
			));

			NOT_SUBCLASS = notSubclass(A, B);
			// NOT_SUBCLASS.setReferences(References.wikiEn("Subclass_(set_theory)"));
			NOT_SUBCLASS.be(classA, classB);
			NOT_SUBCLASS.setMain(Bool.definedAsEqualTo(subclass(A, B), Bool.notWithBrackets(subclass(A, B))));
			// titleText(NOT_SUBCLASS, "No Subclass", null, "Keine Teilklasse", null);
			MathMLGenerator.displayRule(NOT_SUBCLASS, new WriteOperation("⊈"));

			STRICT_SUBCLASS = strictSubclass(A, B);
			STRICT_SUBCLASS.setReferences(References.wikiEn("Subset"), References.wikiDe("Teilmenge"));
			STRICT_SUBCLASS.be(classA, classB);
			STRICT_SUBCLASS.setMain(Bool.definedAsEqualTo(strictSubclass(A, B), Bool.and(subclass(A, B), Logic.notEquals(A, B))));
			definition(STRICT_SUBCLASS, "Strict (proper) subclass", null, "Echte Teilklasse", "Bei Mengen redet man auch von echten Teilmengen");
			MathMLGenerator.displayRule(STRICT_SUBCLASS, new WriteOperation("⊊"));

			SUPERCLASS = superclass(B, A);
			// SUPERCLASS.setReferences(References.wikiEn("Subclass_(set_theory)"));
			SUPERCLASS.setBe(Arrays.asList(classA, classB));
			SUPERCLASS.setMain(Arrays.asList(Bool.definedAsEqualTo(superclass(B, A), subclass(A, B))));
			definition(SUPERCLASS, "Superclass", null, "Oberklasse", "Ist B keine Oberklasse von A schreibt man ", notSuperclass(B, A));
			MathMLGenerator.displayRule(SUPERCLASS, new WriteOperation("⊇"));

			NOT_SUPERCLASS = notSuperclass(null, null);
			// NOT_SUBCLASS.setReferences(References.wikiEn("Subclass_(set_theory)"));
			NOT_SUPERCLASS.be(classA, classB);
			NOT_SUPERCLASS.setMain(Bool.definedAsEqualTo(notSuperclass(A, B), Bool.notWithBrackets(subclass(B, A))));
			// titleText(NOT_SUBCLASS, "No Subclass", null, "Keine Teilklasse", null);
			MathMLGenerator.displayRule(NOT_SUPERCLASS, new WriteOperation("⊉"));
			
			Write writeSubclassRelationSymbol = WriteAfterStatementTransformation.ruleTransformation(Basics.MANTISSA_INDEX_EXPONENT, Basics.comment("T"),
					FIRST_VARIABLE, "");
			Write writeASubclassOf = WriteAfterStatementTransformation.ruleTransformation(SUBCLASS, Basics.comment("A"), FIRST_VARIABLE);
			Write writeBSubclassOf = WriteAfterStatementTransformation.ruleTransformation(SUBCLASS, Basics.comment("B"), FIRST_VARIABLE);

			SUBCLASS_RELATION = subclassRelation(null);
			SUBCLASS_RELATION.setReferences(References.ml1("2.2.6"));
			SUBCLASS_RELATION.be(setC);
			SUBCLASS_RELATION.main(subclassRelation(C).setDisplayLevel(EXTENDED));
			MathMLGenerator.displayRule(SUBCLASS_RELATION, WriteExtended.shortDefault(writeSubclassRelationSymbol, writeSubclassRelationSymbol,
					new WriteMulti(writeSubclassRelationSymbol, ":={(A,B)| A⊆B, ", writeASubclassOf, ", ", writeBSubclassOf, "}")));
			definition(SUBCLASS_RELATION, null, null, "Teilmengenbeziehung als Relation auf der Potenzmenge",
					"Die Teilmengenrelation innerhalb einer Menge C ist eine Relation auf der Potenzmenge ", Powerset.powerset(C), " (da ",
					Bool.iff(AsubclassC, ClassesSets.elementOf(A, Powerset.powerset(C))));


			SUBCLASS_RELATION_TRANSITIVE = SINGLETON.normal("SUBCLASS_RELATION_TRANSITIVE");
			SUBCLASS_RELATION_TRANSITIVE.setReferences(References.ml1("2.3.10"));
			Statement T_C = subclassRelation(C);
			SUBCLASS_RELATION_TRANSITIVE.be(setC);
			SUBCLASS_RELATION_TRANSITIVE.main(Logic.equals(CompositionFactory.composite(T_C, T_C), T_C));
			lemma(SUBCLASS_RELATION_TRANSITIVE, null, null, "Die Teilmengenbeziehung ist transitiv.", null);
			SUBCLASS_RELATION_TRANSITIVE.setProofs(Bool.iffMultiline(//
					ClassesSets.elementOf(A_B, CompositionFactory.composite(T_C, T_C)), //
					Logic.exists(X, Bool.and(ClassesSets.elementOf(A_X, T_C), ClassesSets.elementOf(X_B, T_C))), //
					Logic.exists(X, Bool.and(AsubclassX, XsubclassB)), //
					Basics.proofline(AsubclassB, Bool.impliedBy(Basics.EMPTY, Basics.comment(": z.B. X=B")))
			//
			));

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(SUBCLASS, NOT_SUBCLASS_AND_EXISTS, SUBSET, SUBSET_NEGATION, STRICT_SUBCLASS, SUPERCLASS, SUPERSET, REFLEXIV, ANTISYMMETRIC,
						TRANSITIVE),
				Arrays.asList(NOT_SUBCLASS, EQUALITY_PROOF_BY_SUBSETS, NOT_SUPERCLASS, SUBCLASSES, SUBCLASSES_MULTILINE));
	}


}
