package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import net.sf.gluebooster.demos.pojo.math.MathStudies;
import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.MathMLGenerator;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.demos.pojo.math.studies.WriteAfterStatementTransformation;
import net.sf.gluebooster.demos.pojo.math.studies.WriteOperation;
import net.sf.gluebooster.java.booster.basic.math.GeometryPositionConstraint;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of set theory concerning classes.
 * 
 * @see https://glossar.hs-augsburg.de/Klasse_(Mengenlehre)
 * 
 * @author cbauer
 *
 */
public class SubsetFactory extends Statements {

	protected static final SubsetFactory SINGLETON = new SubsetFactory();



	protected SubsetFactory() {
		super("subset", SetTheory.SINGLETON);
	}



	public static Statement subclass(Statement subclass, Statement superclass) {
		return SINGLETON.normal("subclass", subclass, superclass);
	}

	/**
	 * Without the subclass, just the sign and superclass
	 * 
	 * @param superclass
	 * @return
	 */
	public static Statement subclass(Statement superclass) {
		return subclass(EMPTY, superclass);
	}

	/**
	 * 
	 * @param classes
	 *            The first class is the smallest
	 * @return
	 */
	public static Statement subclasses(Statement... classes) {
		return SINGLETON.normal("subclasses", classes);
	}

	public static Statement subclassesMultiline(Statement... classes) {
		return SINGLETON.normal("subclassesMultiline", classes);
	}

	public static Statement notSubclass(Statement subclass, Statement superclass) {
		return SINGLETON.normal("notSubclass", subclass, superclass);
	}

	public static Statement strictSubclass(Statement subclass, Statement superclass) {
		return SINGLETON.normal("strictSubclass", subclass, superclass);
	}

	public static Statement superclass(Statement superclass, Statement subclass) {
		return SINGLETON.normal("superclass", superclass, subclass);
	}

	public static Statement superclass(Statement... smallerClasses) {
		return SINGLETON.normal("superclass", smallerClasses);
	}

	public static Statement notSuperclass(Statement superclass, Statement subclass) {
		return SINGLETON.normal("notSuperclass", superclass, subclass);
	}

	public static Statement subset(Statement subset, Statement superset) {
		return SINGLETON.normal("subset", Arrays.asList(subset, superset));
	}

	public static Statement superset(Statement superset, Statement subset) {
		return SINGLETON.normal("superset", Arrays.asList(superset, subset));
	}


	public static Statement equalsBySubclasses(Statement proofLeftSubsetRight, Statement proofRightSubsetLeft) {
		return SINGLETON.normal("equalsBySubclasses", proofLeftSubsetRight, proofRightSubsetLeft);
	}

	public static Statement subclassRelation(Statement clasz) {
		Statement result = SINGLETON.normal("subclassRelation", clasz);
		return result;
	}

}
