package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import java.util.Arrays;
import java.util.List;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;
import net.sf.gluebooster.demos.pojo.math.library.Basics;
import net.sf.gluebooster.demos.pojo.math.library.References;
import net.sf.gluebooster.demos.pojo.math.library.logic.Bool;
import net.sf.gluebooster.demos.pojo.math.library.logic.Logic;
import net.sf.gluebooster.demos.pojo.math.studies.StudyUnit;
import net.sf.gluebooster.java.booster.essentials.utils.ThrowableBoostUtils;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class Tuples extends TuplesFactory {

	public static Statement ORDERED_PAIR;

	public static Statement AXIOM_OF_PAIRING;

	/**
	* 
	 * (x,y) := { {x}, {x,y}}
	 */
	public static Statement KURATOWSKI_PAIR;
	
	/**
	 * (a,b) = (c,d) <=> a=c and b=d
	 */
	public static Statement KURATOWSKI_PAIR_IS_ORDERED_PAIR;

	/**
	 * Inductive Definition
	 * (x1) = x1
	 * (x1...xn, xn+1) = ( (x1...xn), xn+1)  äußere Klammer kuratowski-paar, innere tuple
	 */
	public static Statement TUPLE;//
	public static Statement TUPLE_WITHOUT_BRACKETS;//
	
	public static Statement TUPLE_EQUALITY;//


	private Tuples() {
	}

	static {
		try {
			titleText(SINGLETON.getCategory(), "Tuples", null, "Tupel", null);

			Statement one = Logic.var("1");
			Statement n = Logic.var("n");
			Statement m = Logic.var("m");
			Statement x = Logic.var("x");
			Statement x1 = Logic.var("x", one);
			Statement xn = Logic.var("x", n);
			Statement xn1 = Logic.var("x", Logic.var("n+1"));
			Statement y = Logic.var("y");
			Statement y1 = Logic.var("y", one);
			Statement ym = Logic.var("y", m);
			Statement yn = Logic.var("y", n);
			Statement a = Logic.var("a");
			Statement b = Logic.var("b");
			Statement more = Basics.comment("...");

			titleText(SINGLETON.unit(1), "Tuples (1)", null, "Tupel (1)", null);

			ORDERED_PAIR = pair(null, null);
			ORDERED_PAIR.setReferences(References.wikiEn("Ordered_pair"), References.wikiDe("Geordnetes_Paar"));
			definition(ORDERED_PAIR, "Ordered pair", null, "Geordnetes Paar", "Eine Zusammenfassung zweier Objekte x,y zu einer Einheit ", pair(x, y),
					". x ist die 'erste Komponente', y die 'zweite Komponente'.");

			AXIOM_OF_PAIRING = SINGLETON.normal("AXIOM_OF_PAIRING");
			AXIOM_OF_PAIRING.setReferences(References.wikiEn("Axiom_of_pairing"), References.wikiDe("Geordnetes_Paar"));
			AXIOM_OF_PAIRING.setMain(Bool.biconditional(Logic.equals(pair(x, y), pair(a, b)), Bool.and(Logic.equals(x, a), Logic.equals(y, b))));
			lemma(AXIOM_OF_PAIRING, "axiom of pairing", null, "Paaraxiom",
					"Zwei Paare sind genau dann gleich, wenn ihre entsprechenden Komponenten gleich sind.");

			KURATOWSKI_PAIR = SINGLETON.naive("KURATOWSKI_PAIR");
			titleText(KURATOWSKI_PAIR, "Kuratowski pair", null, "Kuratowski Paar", "Ein geordnetes Paar (a,b) kann wie folgt als Menge dargestellt werden: ",
					ClassesSets.explicitSet(null, ClassesSets.explicitSet(null, a), ClassesSets.explicitSet(null, a, b)),
					" (Darstellung nach Kazimierz Kuratowski). Beachte, dass durch die Verwendung von Mengen die Elemente hier keine echten Klassen sein dürfen. Es gibt aber auch andere Definitionen, nach denen dies möglich ist.");

			TUPLE = tuple();
			TUPLE.setReferences(References.wikiEn("Tuple"), References.wikiDe("Tupel"));
			TUPLE.setInformalMain(Basics.comment("Rekursive Definition mittels des geordneten Paars: "), Logic.definedAs(tuple(x1), x1),
					Logic.definedAs(tuple(x1, more, xn, xn1), pair(tuple(x1, more, xn), xn1)));
			definition(TUPLE, "Tuple", null, "Tupel", "Eine Auflistung endlich vieler Objekte. Im Gegensatz zu Mengen ist hier auch die Reihenfolge wichtig.");

			TUPLE_WITHOUT_BRACKETS = tupleWithoutBrackets();

			TUPLE_EQUALITY = SINGLETON.normal("tuple equality");
			TUPLE_EQUALITY.setMain(Bool.biconditional(Logic.equals(tuple(x1, more, xn), tuple(y1, more, ym)),
					Bool.and(Logic.equals(n, m), Logic.equals(x1, y1), more, Logic.equals(xn, yn))));
			lemma(TUPLE_EQUALITY, null, null, "Gleichheit von Tupeln",
					"Tupel sind gleich, wenn sie gleich lang sind und an gleicher Position gleiche Elemente enthalten.");

		} catch (Exception ex) {
			throw ThrowableBoostUtils.toRuntimeException(ex);
		}

	}


	
	public static StudyUnit createStudyUnit1() {

		return new StudyUnit(SINGLETON, 1,
				Arrays.asList(ORDERED_PAIR, AXIOM_OF_PAIRING, KURATOWSKI_PAIR, TUPLE, TUPLE_EQUALITY),
				Arrays.asList(TUPLE_WITHOUT_BRACKETS));
	}

}
