package net.sf.gluebooster.demos.pojo.math.library.setTheory;

import net.sf.gluebooster.demos.pojo.math.Statement;
import net.sf.gluebooster.demos.pojo.math.Statements;

/**
 * Statements of the set theory
 * 
 * @author cbauer
 *
 */
public class TuplesFactory extends Statements {

	protected static final TuplesFactory SINGLETON = new TuplesFactory();


	protected TuplesFactory() {
		super("tuples", SetTheory.SINGLETON);
	}


	public static Statement pair(Statement element1, Statement element2) {
		Statement result = SINGLETON.normal("PAIR", element1, element2);
		return result;
	}


	public static Statement tuple(Statement... elements) {
		Statement result = SINGLETON.normal("TUPLE", elements);
		return result;
	}

	public static Statement tupleWithoutBrackets(Statement... elements) {
		Statement result = SINGLETON.normal("tupleWithoutBrackets", elements);
		return result;
	}

	

}
